/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.datagen;

import com.robotgryphon.compactmachines.datagen.BlockLootGenerator;
import com.robotgryphon.compactmachines.datagen.RecipeGenerator;
import com.robotgryphon.compactmachines.datagen.StateGenerator;
import com.robotgryphon.compactmachines.datagen.TunnelWallStateGenerator;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="compactmachines", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGeneration.registerServerProviders(event.getGenerator(), event);
        }
        if (event.includeClient()) {
            DataGeneration.registerClientProviders(event.getGenerator(), event);
        }
    }

    private static void registerServerProviders(DataGenerator generator, GatherDataEvent event) {
        generator.func_200390_a((IDataProvider)new BlockLootGenerator(generator));
        generator.func_200390_a((IDataProvider)new RecipeGenerator(generator));
    }

    private static void registerClientProviders(DataGenerator generator, GatherDataEvent event) {
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.func_200390_a((IDataProvider)new StateGenerator(generator, helper));
        generator.func_200390_a((IDataProvider)new TunnelWallStateGenerator(generator, helper));
    }
}

