/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.item;

import com.mojang.authlib.GameProfile;
import com.robotgryphon.compactmachines.block.BlockCompactMachine;
import com.robotgryphon.compactmachines.reference.EnumMachineSize;
import com.robotgryphon.compactmachines.util.PlayerUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ItemBlockMachine
extends BlockItem {
    public ItemBlockMachine(Block blockIn, EnumMachineSize size, Item.Properties builder) {
        super(blockIn, builder);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int coords;
        CompoundNBT machineData;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!stack.func_77942_o()) {
            return;
        }
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt.func_74764_b("cm") && (machineData = nbt.func_74775_l("cm")).func_74764_b("coords") && (coords = machineData.func_74762_e("coords")) > -1) {
            TranslationTextComponent coordsTC = new TranslationTextComponent("tooltip.compactmachines.machine_id", new Object[]{coords});
            tooltip.add((ITextComponent)coordsTC);
        }
        if (nbt.func_74764_b("owner")) {
            UUID owner = nbt.func_186857_a("owner");
            Optional<GameProfile> playerProfile = PlayerUtil.getProfileByUUID((IWorld)worldIn, owner);
            IFormattableTextComponent player = playerProfile.map(p -> new StringTextComponent(p.getName())).orElseGet(() -> new TranslationTextComponent("tooltip.compactmachines.unknown_player"));
            IFormattableTextComponent ownerText = new TranslationTextComponent("tooltip.compactmachines.owner").func_230529_a_((ITextComponent)player);
            tooltip.add((ITextComponent)ownerText);
        }
        if (Screen.func_231173_s_()) {
            Block b = Block.func_149634_a((Item)stack.func_77973_b());
            if (b instanceof BlockCompactMachine) {
                EnumMachineSize size = ((BlockCompactMachine)b).getSize();
                int internalSize = size.getInternalSize();
                IFormattableTextComponent text = new TranslationTextComponent("tooltip.compactmachines.machine.size", new Object[]{internalSize}).func_240699_a_(TextFormatting.YELLOW);
                tooltip.add((ITextComponent)text);
            }
        } else {
            IFormattableTextComponent text = new TranslationTextComponent("tooltip.compactmachines.hold_shift.hint").func_240699_a_(TextFormatting.GRAY);
            tooltip.add((ITextComponent)text);
        }
    }
}

