/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.tunnels;

import com.robotgryphon.compactmachines.api.tunnels.EnumTunnelSide;
import com.robotgryphon.compactmachines.api.tunnels.ITunnelConnectionInfo;
import com.robotgryphon.compactmachines.api.tunnels.TunnelDefinition;
import com.robotgryphon.compactmachines.block.tiles.TunnelWallTile;
import com.robotgryphon.compactmachines.block.walls.TunnelWallBlock;
import com.robotgryphon.compactmachines.core.Registration;
import com.robotgryphon.compactmachines.data.CompactMachineServerData;
import com.robotgryphon.compactmachines.data.SavedMachineData;
import com.robotgryphon.compactmachines.data.machines.CompactMachineRegistrationData;
import com.robotgryphon.compactmachines.teleportation.DimensionalPosition;
import com.robotgryphon.compactmachines.tunnels.TunnelConnectionInfo;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.RegistryObject;

public class TunnelHelper {
    public static ITunnelConnectionInfo generateConnectionInfo(TunnelWallTile tunnelTile) {
        return new TunnelConnectionInfo(tunnelTile);
    }

    public static ITunnelConnectionInfo generateConnectionInfo(@Nonnull IBlockReader tunnelWorld, @Nonnull BlockPos tunnelPos) {
        TunnelWallTile tile = (TunnelWallTile)tunnelWorld.func_175625_s(tunnelPos);
        return TunnelHelper.generateConnectionInfo(tile);
    }

    @Nonnull
    public static Direction getNextDirection(Direction in) {
        switch (in) {
            case UP: {
                return Direction.DOWN;
            }
            case DOWN: {
                return Direction.NORTH;
            }
            case NORTH: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.UP;
            }
        }
        return Direction.UP;
    }

    @Nonnull
    public static Optional<TunnelDefinition> getTunnelDefinitionFromType(ResourceLocation id) {
        Optional<RegistryObject> first = Registration.TUNNEL_DEFINITIONS.getEntries().stream().filter(t -> ((TunnelDefinition)t.get()).getRegistryName() == id).findFirst();
        return first.map(RegistryObject::get);
    }

    public static Set<BlockPos> getTunnelsForMachineSide(int machine, ServerWorld world, Direction machineSide) {
        ServerWorld compactWorld = world.func_73046_m().func_71218_a(Registration.COMPACT_DIMENSION);
        HashSet<BlockPos> tunnelPositions = new HashSet<BlockPos>();
        CompactMachineServerData data = SavedMachineData.getInstance(world.func_73046_m()).getData();
        Optional<CompactMachineRegistrationData> mData = data.getMachineData(machine);
        mData.ifPresent(machineData -> {
            int internalSize;
            BlockPos machineCenter = machineData.getCenter();
            AxisAlignedBB allBlocksInMachine = new AxisAlignedBB(machineCenter, machineCenter).func_186662_g((double)(internalSize = machineData.getSize().getInternalSize()));
            Set tunnelPositionsUnfiltered = BlockPos.func_239581_a_((AxisAlignedBB)allBlocksInMachine).filter(pos -> !compactWorld.func_175623_d(pos)).map(BlockPos::func_185334_h).collect(Collectors.toSet());
            if (!tunnelPositionsUnfiltered.isEmpty()) {
                Set tunnelPositionsFiltered = tunnelPositionsUnfiltered.stream().filter(pos -> {
                    BlockState state = compactWorld.func_180495_p(pos);
                    boolean tunnel = state.func_177230_c() instanceof TunnelWallBlock;
                    if (!tunnel) {
                        return false;
                    }
                    Direction externalSide = (Direction)state.func_177229_b((Property)TunnelWallBlock.CONNECTED_SIDE);
                    return externalSide == machineSide;
                }).map(BlockPos::func_185334_h).collect(Collectors.toSet());
                tunnelPositions.addAll(tunnelPositionsFiltered);
            }
        });
        return tunnelPositions;
    }

    @Nonnull
    public static Optional<DimensionalPosition> getTunnelConnectedPosition(TunnelWallTile tunnel, EnumTunnelSide side) {
        switch (side) {
            case OUTSIDE: {
                return tunnel.getConnectedPosition();
            }
            case INSIDE: {
                RegistryKey<World> world = Registration.COMPACT_DIMENSION;
                BlockPos offsetInside = tunnel.func_174877_v().func_177972_a(tunnel.getTunnelSide());
                DimensionalPosition pos = new DimensionalPosition(world, offsetInside);
                return Optional.of(pos);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<BlockState> getConnectedState(TunnelWallTile twt, EnumTunnelSide side) {
        DimensionalPosition connectedPosition = TunnelHelper.getTunnelConnectedPosition(twt, side).orElse(null);
        if (connectedPosition == null) {
            return Optional.empty();
        }
        if (twt.func_145831_w() instanceof ServerWorld) {
            ServerWorld sw = (ServerWorld)twt.func_145831_w();
            Optional<ServerWorld> connectedWorld = connectedPosition.getWorld(sw.func_73046_m());
            if (!connectedWorld.isPresent()) {
                return Optional.empty();
            }
            ServerWorld csw = connectedWorld.get();
            BlockPos connectedPos = connectedPosition.getBlockPosition();
            BlockState state = csw.func_180495_p(connectedPos);
            return Optional.of(state);
        }
        return Optional.empty();
    }
}

