/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.util;

import com.robotgryphon.compactmachines.core.Registration;
import com.robotgryphon.compactmachines.reference.EnumMachineSize;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class CompactStructureGenerator {
    public static void generateCompactWall(IWorld world, EnumMachineSize size, BlockPos cubeCenter, Direction wallDirection) {
        AxisAlignedBB wallBounds;
        boolean horiz;
        int s = size.getInternalSize() / 2;
        BlockState unbreakableWall = ((Block)Registration.BLOCK_SOLID_WALL.get()).func_176223_P();
        BlockPos start = BlockPos.field_177992_a;
        boolean bl = horiz = wallDirection.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL;
        if (horiz) {
            start = cubeCenter.func_177979_c(s).func_177967_a(wallDirection, s + 1);
            wallBounds = new AxisAlignedBB(start, start).func_72321_a(0.0, (double)(s * 2 + 1), 0.0);
        } else {
            start = cubeCenter.func_177967_a(wallDirection, s + 1);
            wallBounds = new AxisAlignedBB(start, start).func_72314_b((double)(s + 1), 0.0, (double)(s + 1));
        }
        switch (wallDirection) {
            case NORTH: 
            case SOUTH: {
                wallBounds = wallBounds.func_72314_b((double)(s + 1), 0.0, 0.0);
                break;
            }
            case WEST: 
            case EAST: {
                wallBounds = wallBounds.func_72314_b(0.0, 0.0, (double)(s + 1));
            }
        }
        BlockPos.func_239581_a_((AxisAlignedBB)wallBounds).filter(arg_0 -> ((IWorld)world).func_175623_d(arg_0)).map(BlockPos::func_185334_h).forEach(p -> world.func_180501_a(p, unbreakableWall, 7));
    }

    public static void generateCompactStructure(IWorld world, EnumMachineSize size, BlockPos center) {
        int s = size.getInternalSize() / 2;
        BlockPos floorCenter = center.func_177967_a(Direction.DOWN, s);
        AxisAlignedBB floorBlocks = new AxisAlignedBB(floorCenter, floorCenter).func_72314_b((double)s, 0.0, (double)s);
        boolean anyAir = BlockPos.func_239581_a_((AxisAlignedBB)floorBlocks).anyMatch(arg_0 -> ((IWorld)world).func_175623_d(arg_0));
        if (anyAir) {
            Arrays.stream(Direction.values()).forEach(d -> CompactStructureGenerator.generateCompactWall(world, size, center, d));
        }
    }
}

