/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.util;

import com.mojang.authlib.GameProfile;
import com.robotgryphon.compactmachines.CompactMachines;
import com.robotgryphon.compactmachines.data.CompactMachineServerData;
import com.robotgryphon.compactmachines.data.SavedMachineData;
import com.robotgryphon.compactmachines.data.machines.CompactMachinePlayerData;
import com.robotgryphon.compactmachines.data.machines.CompactMachineRegistrationData;
import com.robotgryphon.compactmachines.teleportation.DimensionalPosition;
import com.robotgryphon.compactmachines.util.CompactMachinePlayerUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class PlayerUtil {
    public static Optional<GameProfile> getProfileByUUID(IWorld world, UUID uuid) {
        PlayerEntity player = world.func_217371_b(uuid);
        if (player == null) {
            return Optional.empty();
        }
        GameProfile profile = player.func_146103_bH();
        return Optional.of(profile);
    }

    public static DimensionalPosition getPlayerDimensionalPosition(PlayerEntity player) {
        Vector3d pos = player.func_213303_ch();
        RegistryKey dim = player.field_70170_p.func_234923_W_();
        return new DimensionalPosition((RegistryKey<World>)dim, pos);
    }

    public static void teleportPlayerOutOfMachine(ServerWorld world, ServerPlayerEntity serverPlayer) {
        SavedMachineData machineData = SavedMachineData.getInstance(world.func_73046_m());
        CompactMachineServerData serverData = machineData.getData();
        Optional<CompactMachineRegistrationData> machine = serverData.getMachineContainingPosition(serverPlayer.func_213303_ch());
        if (!machine.isPresent()) {
            serverPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("not_inside_machine"), true);
            return;
        }
        CompactMachineRegistrationData machineInfo = machine.get();
        Optional<CompactMachinePlayerData> machinePlayers = serverData.getPlayerData(machineInfo.getId());
        if (!machinePlayers.isPresent()) {
            CompactMachines.LOGGER.warn("Warning: Machine player data not set but machine registered, and player is inside. Machine ID: {}", (Object)machineInfo.getId());
            serverPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("ah_crap"), true);
            return;
        }
        Optional<DimensionalPosition> lastPos = machinePlayers.get().getExternalSpawn(serverPlayer);
        if (!lastPos.isPresent()) {
            return;
        }
        DimensionalPosition p = lastPos.get();
        Vector3d bp = p.getPosition();
        Optional<ServerWorld> outsideWorld = p.getWorld(world.func_73046_m());
        outsideWorld.ifPresent(w -> machine.ifPresent(m -> {
            serverPlayer.func_200619_a(w, bp.func_82615_a(), bp.func_82617_b(), bp.func_82616_c(), serverPlayer.field_70177_z, serverPlayer.field_70125_A);
            CompactMachinePlayerUtil.removePlayerFromMachine(serverPlayer, machineInfo.getOutsidePosition(serverPlayer.func_184102_h()).getBlockPosition(), m.getId());
        }));
    }
}

