/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.framework.widgets;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import org.dave.compactmachines3.gui.framework.event.MouseClickEvent;
import org.dave.compactmachines3.gui.framework.event.MouseEnterEvent;
import org.dave.compactmachines3.gui.framework.event.MouseExitEvent;
import org.dave.compactmachines3.gui.framework.event.MouseMoveEvent;
import org.dave.compactmachines3.gui.framework.event.ValueChangedEvent;
import org.dave.compactmachines3.gui.framework.event.WidgetEventResult;
import org.dave.compactmachines3.gui.framework.widgets.Widget;

public class WidgetPanel
extends Widget {
    List<Widget> children = new LinkedList<Widget>();
    List<Widget> previouslyHovered = new ArrayList<Widget>();

    public WidgetPanel() {
        this.addListener(MouseMoveEvent.class, (event, widget) -> {
            for (Widget child : this.children) {
                MouseMoveEvent shifted = new MouseMoveEvent(event.x, event.y);
                child.fireEvent(shifted);
                if (!child.isPosInside(event.x, event.y)) {
                    if (!this.previouslyHovered.contains(child)) continue;
                    child.fireEvent(new MouseExitEvent());
                    this.previouslyHovered.remove(child);
                    continue;
                }
                if (this.previouslyHovered.contains(child)) continue;
                child.fireEvent(new MouseEnterEvent());
                this.previouslyHovered.add(child);
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            int innerX = event.x - widget.getActualX();
            int innerY = event.y - widget.getActualY();
            for (Widget child : this.children) {
                if (!child.visible || !child.isPosInside(event.x, event.y) || child.fireEvent(new MouseClickEvent(event.x, event.y, event.button)) != WidgetEventResult.HANDLED) continue;
                return WidgetEventResult.HANDLED;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        HashSet eventsToIgnore = Sets.newHashSet((Object[])new Class[]{MouseClickEvent.class, MouseMoveEvent.class, MouseEnterEvent.class, MouseExitEvent.class, ValueChangedEvent.class});
        this.addAnyListener((event, widget) -> {
            if (eventsToIgnore.contains(event.getClass())) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            for (Widget child : this.children) {
                WidgetEventResult immediateResult = child.fireEvent(event);
                if (immediateResult != WidgetEventResult.HANDLED) continue;
                return WidgetEventResult.HANDLED;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    @Override
    public boolean focusable() {
        return false;
    }

    public void clear() {
        this.children.clear();
    }

    public void add(Widget widget) {
        this.children.add(widget);
        widget.setParent(this);
    }

    public void remove(Widget widget) {
        this.children.remove(widget);
    }

    public List<Widget> getHoveredWidgets() {
        ArrayList<Widget> result = new ArrayList<Widget>();
        this.getHoveredWidgets(result);
        return result;
    }

    private void getHoveredWidgets(List<Widget> result) {
        for (Widget widget : this.previouslyHovered) {
            if (widget instanceof WidgetPanel) {
                ((WidgetPanel)widget).getHoveredWidgets(result);
                continue;
            }
            result.add(widget);
        }
    }

    public Widget getHoveredWidget(int mouseX, int mouseY) {
        for (Widget child : this.children) {
            if (!child.visible || !child.isPosInside(mouseX, mouseY)) continue;
            Widget maybeResult = null;
            if (child instanceof WidgetPanel) {
                maybeResult = ((WidgetPanel)child).getHoveredWidget(mouseX, mouseY);
            }
            if (maybeResult != null && maybeResult.hasToolTip()) {
                return maybeResult;
            }
            return child;
        }
        return null;
    }

    @Override
    public void draw(GuiScreen screen) {
        for (Widget child : this.children) {
            if (!child.visible) continue;
            child.shiftAndDraw(screen);
        }
    }
}

