/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Properties;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.clothconfig2.impl.EasingMethods;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClothConfigInitializer
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"ClothConfig");
    private static EasingMethod easingMethod = EasingMethod.EasingMethodImpl.QUART;
    private static long scrollDuration = 1000L;
    private static double scrollStep = 16.0;
    private static double bounceBackMultiplier = 0.24;

    public static EasingMethod getEasingMethod() {
        return easingMethod;
    }

    public static long getScrollDuration() {
        return scrollDuration;
    }

    public static double getScrollStep() {
        return scrollStep;
    }

    public static double getBounceBackMultiplier() {
        return bounceBackMultiplier;
    }

    private static void loadConfig() {
        File file = new File(FabricLoader.getInstance().getConfigDirectory(), "cloth-config2/config.properties");
        try {
            file.getParentFile().mkdirs();
            easingMethod = EasingMethod.EasingMethodImpl.QUART;
            scrollDuration = 1000L;
            scrollStep = 16.0;
            bounceBackMultiplier = 0.24;
            if (!file.exists()) {
                ClothConfigInitializer.saveConfig();
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            String easing = properties.getProperty("easingMethod", "QUART");
            for (EasingMethod value : EasingMethods.getMethods()) {
                if (!value.toString().equalsIgnoreCase(easing)) continue;
                easingMethod = value;
                break;
            }
            scrollDuration = Long.parseLong(properties.getProperty("scrollDuration", "1000"));
            scrollStep = Double.parseDouble(properties.getProperty("scrollStep", "16"));
            bounceBackMultiplier = Double.parseDouble(properties.getProperty("bounceBackMultiplier2", "0.24"));
        }
        catch (Exception e) {
            e.printStackTrace();
            easingMethod = EasingMethod.EasingMethodImpl.QUART;
            scrollDuration = 1000L;
            scrollStep = 16.0;
            bounceBackMultiplier = 0.24;
            try {
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ClothConfigInitializer.saveConfig();
        }
    }

    private static void saveConfig() {
        File file = new File(FabricLoader.getInstance().getConfigDirectory(), "cloth-config2/config.properties");
        try {
            FileWriter writer = new FileWriter(file, false);
            Properties properties = new Properties();
            properties.setProperty("easingMethod", easingMethod.toString());
            properties.setProperty("scrollDuration", scrollDuration + "");
            properties.setProperty("scrollStep", scrollStep + "");
            properties.setProperty("bounceBackMultiplier2", bounceBackMultiplier + "");
            properties.store(writer, null);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            easingMethod = EasingMethod.EasingMethodImpl.QUART;
            scrollDuration = 1000L;
            scrollStep = 16.0;
            bounceBackMultiplier = 0.24;
        }
    }

    public void onInitializeClient() {
        ClothConfigInitializer.loadConfig();
        if (FabricLoader.getInstance().isModLoaded("modmenu")) {
            try {
                Class<?> clazz = Class.forName("io.github.prospector.modmenu.api.ModMenuApi");
                Method method = clazz.getMethod("addConfigOverride", String.class, Runnable.class);
                method.invoke(null, "cloth-config2", () -> {
                    try {
                        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(class_310.method_1551().field_1755).setTitle("Cloth Mod Config Config");
                        builder.setDefaultBackgroundTexture(new class_2960("minecraft:textures/block/oak_planks.png"));
                        ConfigCategory scrolling = builder.getOrCreateCategory("Scrolling");
                        ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
                        scrolling.addEntry(entryBuilder.startDropdownMenu("Easing Method", DropdownMenuBuilder.TopCellElementBuilder.of(easingMethod, str -> {
                            for (EasingMethod m : EasingMethods.getMethods()) {
                                if (!m.toString().equals(str)) continue;
                                return m;
                            }
                            return null;
                        })).setDefaultValue(EasingMethod.EasingMethodImpl.QUART).setSaveConsumer(o -> {
                            easingMethod = (EasingMethod)o;
                        }).setSelections(EasingMethods.getMethods()).build());
                        scrolling.addEntry(entryBuilder.startLongSlider("Scroll Duration", scrollDuration, 0L, 5000L).setTextGetter(integer -> integer <= 0L ? "Value: Disabled" : (integer > 1500L ? String.format("Value: %.1fs", Float.valueOf((float)integer.longValue() / 1000.0f)) : "Value: " + integer + "ms")).setDefaultValue(1000L).setSaveConsumer(i -> {
                            scrollDuration = i;
                        }).build());
                        scrolling.addEntry(entryBuilder.startDoubleField("Scroll Step", scrollStep).setDefaultValue(16.0).setSaveConsumer(i -> {
                            scrollStep = i;
                        }).build());
                        scrolling.addEntry(entryBuilder.startDoubleField("Bounce Multiplier", bounceBackMultiplier).setDefaultValue(0.24).setSaveConsumer(i -> {
                            bounceBackMultiplier = i;
                        }).build());
                        ConfigCategory testing = builder.getOrCreateCategory("Testing");
                        testing.addEntry(entryBuilder.startDropdownMenu("lol apple", DropdownMenuBuilder.TopCellElementBuilder.ofItemObject(class_1802.field_8279), DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(class_1802.field_8279).setSelections(class_2378.field_11142.method_10220().sorted(Comparator.comparing(class_1792::toString)).collect(Collectors.toSet())).setSaveConsumer(item -> System.out.println("save this " + item)).build());
                        builder.setSavingRunnable(() -> ClothConfigInitializer.saveConfig());
                        builder.transparentBackground();
                        class_310.method_1551().method_1507(builder.build());
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("[ClothConfig] Failed to add test config override for ModMenu!", (Throwable)e);
            }
        }
    }
}

