/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.RunSixtyTimesEverySec;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.compat.RenderHelper;
import me.shedaniel.math.impl.PointHelper;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;

public class DropdownBoxEntry<T>
extends TooltipListEntry<T> {
    protected class_4185 resetButton;
    protected SelectionElement<T> selectionElement;
    @Nonnull
    private Supplier<T> defaultValue;
    @Nullable
    private Consumer<T> saveConsumer;

    @Deprecated
    public DropdownBoxEntry(String fieldName, @Nonnull String resetButtonKey, @Nullable Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart, @Nullable Supplier<T> defaultValue, @Nullable Consumer<T> saveConsumer, @Nullable Iterable<T> selections, @Nonnull SelectionTopCellElement<T> topRenderer, @Nonnull SelectionCellCreator<T> cellCreator) {
        super(class_1074.method_4662((String)fieldName, (Object[])new Object[0]), tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.saveConsumer = saveConsumer;
        this.resetButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_1727(class_1074.method_4662((String)resetButtonKey, (Object[])new Object[0])) + 6, 20, class_1074.method_4662((String)resetButtonKey, (Object[])new Object[0]), widget -> {
            this.selectionElement.topRenderer.setValue(defaultValue.get());
            this.getScreen().setEdited(true, this.isRequiresRestart());
        });
        this.selectionElement = new SelectionElement(this, new Rectangle(0, 0, 150, 20), new DefaultDropdownMenuElement(selections == null ? ImmutableList.of() : ImmutableList.copyOf(selections)), topRenderer, cellCreator);
    }

    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        class_1041 window = class_310.method_1551().field_1704;
        this.resetButton.active = this.isEditable() && this.getDefaultValue().isPresent() && (!this.defaultValue.get().equals(this.getValue()) || this.getConfigError().isPresent());
        this.resetButton.y = y;
        this.selectionElement.active = this.isEditable();
        this.selectionElement.bounds.y = y;
        if (class_310.method_1551().field_1772.method_1726()) {
            class_310.method_1551().field_1772.method_1720(class_1074.method_4662((String)this.getFieldName(), (Object[])new Object[0]), (float)(window.method_4486() - x - class_310.method_1551().field_1772.method_1727(class_1074.method_4662((String)this.getFieldName(), (Object[])new Object[0]))), (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.x = x;
            this.selectionElement.bounds.x = x + this.resetButton.getWidth() + 1;
        } else {
            class_310.method_1551().field_1772.method_1720(class_1074.method_4662((String)this.getFieldName(), (Object[])new Object[0]), (float)x, (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.x = x + entryWidth - this.resetButton.getWidth();
            this.selectionElement.bounds.x = x + entryWidth - 150 + 1;
        }
        this.selectionElement.bounds.width = 150 - this.resetButton.getWidth() - 4;
        this.resetButton.render(mouseX, mouseY, delta);
        this.selectionElement.render(mouseX, mouseY, delta);
    }

    @Nonnull
    public ImmutableList<T> getSelections() {
        return this.selectionElement.menu.getSelections();
    }

    @Override
    public T getValue() {
        return this.selectionElement.getValue();
    }

    @Override
    public Optional<T> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public List<? extends class_364> children() {
        return Lists.newArrayList((Object[])new class_332[]{this.selectionElement, this.resetButton});
    }

    @Override
    public Optional<String> getError() {
        return this.selectionElement.topRenderer.getError();
    }

    @Override
    public void lateRender(int mouseX, int mouseY, float delta) {
        this.selectionElement.lateRender(mouseX, mouseY, delta);
    }

    @Override
    public int getMorePossibleHeight() {
        return this.selectionElement.getMorePossibleHeight();
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        return this.selectionElement.mouseScrolled(double_1, double_2, double_3);
    }

    public static class DefaultSelectionTopCellElement<R>
    extends SelectionTopCellElement<R> {
        protected class_342 textFieldWidget;
        protected Function<String, R> toObjectFunction;
        protected Function<R, String> toStringFunction;
        protected R value;

        public DefaultSelectionTopCellElement(R value, Function<String, R> toObjectFunction, Function<R, String> toStringFunction) {
            this.value = Objects.requireNonNull(value);
            this.toObjectFunction = Objects.requireNonNull(toObjectFunction);
            this.toStringFunction = Objects.requireNonNull(toStringFunction);
            this.textFieldWidget = new class_342(class_310.method_1551().field_1772, 0, 0, 148, 18, ""){

                public void render(int int_1, int int_2, float float_1) {
                    boolean f = this.isFocused();
                    this.setFocused(this.getParent().getParent().getFocused() == this.getParent() && this.getParent().getFocused() == this.getParent().selectionElement && this.getParent().selectionElement.getFocused() == this && this.getFocused() == this);
                    super.render(int_1, int_2, float_1);
                    this.setFocused(f);
                }

                public boolean keyPressed(int int_1, int int_2, int int_3) {
                    if (int_1 == 257 || int_1 == 335) {
                        this.selectFirstRecommendation();
                        return true;
                    }
                    return super.keyPressed(int_1, int_2, int_3);
                }
            };
            this.textFieldWidget.method_1858(false);
            this.textFieldWidget.method_1880(999999);
            this.textFieldWidget.method_1852(toStringFunction.apply(value));
            this.textFieldWidget.method_1863(s -> {
                if (!((String)toStringFunction.apply(value)).equals(s)) {
                    this.getParent().getScreen().setEdited(true, this.getParent().isRequiresRestart());
                }
            });
        }

        @Override
        public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
            this.textFieldWidget.x = x + 4;
            this.textFieldWidget.y = y + 6;
            this.textFieldWidget.setWidth(width - 8);
            this.textFieldWidget.method_1888(this.getParent().isEditable());
            this.textFieldWidget.method_1868(this.getPreferredTextColor());
            this.textFieldWidget.render(mouseX, mouseY, delta);
        }

        @Override
        public R getValue() {
            if (this.hasConfigError()) {
                return this.value;
            }
            return this.toObjectFunction.apply(this.textFieldWidget.method_1882());
        }

        @Override
        public void setValue(R value) {
            this.textFieldWidget.method_1852(this.toStringFunction.apply(value));
            this.textFieldWidget.method_1883(0);
        }

        @Override
        public String getSearchTerm() {
            return this.textFieldWidget.method_1882();
        }

        @Override
        public Optional<String> getError() {
            if (this.toObjectFunction.apply(this.textFieldWidget.method_1882()) != null) {
                return Optional.empty();
            }
            return Optional.of("Invalid Value!");
        }

        public List<? extends class_364> children() {
            return Collections.singletonList(this.textFieldWidget);
        }
    }

    public static abstract class SelectionTopCellElement<R>
    extends class_362 {
        @Deprecated
        private DropdownBoxEntry<R> entry;

        public abstract R getValue();

        public abstract void setValue(R var1);

        public abstract String getSearchTerm();

        public abstract Optional<String> getError();

        public final Optional<String> getConfigError() {
            return this.entry.getConfigError();
        }

        public DropdownBoxEntry<R> getParent() {
            return this.entry;
        }

        public final boolean hasConfigError() {
            return this.getConfigError().isPresent();
        }

        public final int getPreferredTextColor() {
            return this.getConfigError().isPresent() ? 0xFF5555 : 0xFFFFFF;
        }

        public void selectFirstRecommendation() {
            List children = this.getParent().selectionElement.menu.children();
            for (SelectionCellElement child : children) {
                if (child.getSelection() == null) continue;
                this.setValue(child.getSelection());
                this.getParent().selectionElement.setFocused(null);
                break;
            }
        }

        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, float var7);
    }

    public static class DefaultSelectionCellElement<R>
    extends SelectionCellElement<R> {
        protected R r;
        protected int x;
        protected int y;
        protected int width;
        protected int height;
        protected boolean rendering;
        protected Function<R, String> toStringFunction;

        public DefaultSelectionCellElement(R r, Function<R, String> toStringFunction) {
            this.r = r;
            this.toStringFunction = toStringFunction;
        }

        @Override
        public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
            boolean b;
            this.rendering = true;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
            if (b) {
                DefaultSelectionCellElement.fill((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
            }
            class_310.method_1551().field_1772.method_1720(this.toStringFunction.apply(this.r), (float)(x + 6), (float)(y + 3), b ? 0xFFFFFF : 0x888888);
        }

        @Override
        public void dontRender(float delta) {
            this.rendering = false;
        }

        @Override
        @Nullable
        public String getSearchKey() {
            return this.toStringFunction.apply(this.r);
        }

        @Override
        @Nullable
        public R getSelection() {
            return this.r;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int int_1) {
            boolean b;
            boolean bl = b = this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
            if (b) {
                this.getEntry().selectionElement.topRenderer.setValue(this.r);
                this.getEntry().selectionElement.setFocused(null);
                this.getEntry().selectionElement.dontReFocus = true;
                return true;
            }
            return false;
        }
    }

    public static abstract class SelectionCellElement<R>
    extends class_362 {
        @Deprecated
        @Nonnull
        private DropdownBoxEntry<R> entry;

        @Nonnull
        public final DropdownBoxEntry<R> getEntry() {
            return this.entry;
        }

        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, float var7);

        public abstract void dontRender(float var1);

        @Nullable
        public abstract String getSearchKey();

        @Nullable
        public abstract R getSelection();
    }

    public static class DefaultSelectionCellCreator<R>
    extends SelectionCellCreator<R> {
        protected Function<R, String> toStringFunction;

        public DefaultSelectionCellCreator(Function<R, String> toStringFunction) {
            this.toStringFunction = toStringFunction;
        }

        public DefaultSelectionCellCreator() {
            this(Object::toString);
        }

        @Override
        public SelectionCellElement<R> create(R selection) {
            return new DefaultSelectionCellElement<R>(selection, this.toStringFunction);
        }

        @Override
        public int getCellHeight() {
            return 14;
        }

        @Override
        public int getDropBoxMaxHeight() {
            return this.getCellHeight() * 7;
        }
    }

    public static abstract class SelectionCellCreator<R> {
        public abstract SelectionCellElement<R> create(R var1);

        public abstract int getCellHeight();

        public abstract int getDropBoxMaxHeight();

        public int getCellWidth() {
            return 132;
        }
    }

    public static class DefaultDropdownMenuElement<R>
    extends DropdownMenuElement<R> {
        @Nonnull
        protected ImmutableList<R> selections;
        @Nonnull
        protected List<SelectionCellElement<R>> cells;
        @Nonnull
        protected List<SelectionCellElement<R>> currentElements;
        protected String lastSearchKeyword = "";
        protected Rectangle lastRectangle;
        protected boolean scrolling;
        protected double scroll;
        protected double target;
        protected long start;
        protected long duration;
        protected RunSixtyTimesEverySec clamper = () -> {
            this.target = this.clamp(this.target);
            if (this.target < 0.0) {
                this.target *= ClothConfigInitializer.getBounceBackMultiplier();
            } else if (this.target > this.getMaxScrollPosition()) {
                this.target = (this.target - this.getMaxScrollPosition()) * ClothConfigInitializer.getBounceBackMultiplier() + this.getMaxScrollPosition();
            } else {
                this.unregisterClamper();
            }
        };

        public DefaultDropdownMenuElement(@Nonnull ImmutableList<R> selections) {
            this.selections = selections;
            this.cells = Lists.newArrayList();
            this.currentElements = Lists.newArrayList();
        }

        protected void unregisterClamper() {
            this.clamper.unregisterTick();
        }

        public final double clamp(double v) {
            return class_3532.method_15350((double)v, (double)-200.0, (double)(this.getMaxScrollPosition() + 200.0));
        }

        public double getMaxScroll() {
            return this.getCellCreator().getCellHeight() * this.currentElements.size();
        }

        protected double getMaxScrollPosition() {
            return Math.max(0.0, this.getMaxScroll() - (double)this.getHeight());
        }

        @Override
        @Nonnull
        public ImmutableList<R> getSelections() {
            return this.selections;
        }

        @Override
        public void initCells() {
            for (Object selection : this.getSelections()) {
                this.cells.add(this.getCellCreator().create(selection));
            }
            for (SelectionCellElement cell : this.cells) {
                cell.entry = this.getEntry();
            }
            this.search();
        }

        public void search() {
            this.currentElements.clear();
            String keyword = this.lastSearchKeyword.toLowerCase();
            for (SelectionCellElement<R> cell : this.cells) {
                String key = cell.getSearchKey();
                if (key != null && !key.toLowerCase().contains(keyword)) continue;
                this.currentElements.add(cell);
            }
            if (!keyword.isEmpty()) {
                Comparator<SelectionCellElement> c = Comparator.comparingDouble(i -> i.getSearchKey() == null ? Double.MAX_VALUE : this.similarity(i.getSearchKey(), keyword));
                this.currentElements.sort(c.reversed());
            }
            this.scrollTo(0.0, false);
        }

        protected int editDistance(String s1, String s2) {
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();
            int[] costs = new int[s2.length() + 1];
            for (int i = 0; i <= s1.length(); ++i) {
                int lastValue = i;
                for (int j = 0; j <= s2.length(); ++j) {
                    if (i == 0) {
                        costs[j] = j;
                        continue;
                    }
                    if (j <= 0) continue;
                    int newValue = costs[j - 1];
                    if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                        newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                    }
                    costs[j - 1] = lastValue;
                    lastValue = newValue;
                }
                if (i <= 0) continue;
                costs[s2.length()] = lastValue;
            }
            return costs[s2.length()];
        }

        protected double similarity(String s1, String s2) {
            int longerLength;
            String longer = s1;
            String shorter = s2;
            if (s1.length() < s2.length()) {
                longer = s2;
                shorter = s1;
            }
            if ((longerLength = longer.length()) == 0) {
                return 1.0;
            }
            return (double)(longerLength - this.editDistance(longer, shorter)) / (double)longerLength;
        }

        @Override
        public void render(int mouseX, int mouseY, Rectangle rectangle, float delta) {
            if (!this.getEntry().selectionElement.topRenderer.getSearchTerm().equals(this.lastSearchKeyword)) {
                this.lastSearchKeyword = this.getEntry().selectionElement.topRenderer.getSearchTerm();
                this.search();
            }
            this.updatePosition(delta);
            this.lastRectangle = rectangle.clone();
            this.lastRectangle.translate(0, -1);
        }

        private void updatePosition(float delta) {
            this.target = this.clamp(this.target);
            if ((this.target < 0.0 || this.target > this.getMaxScrollPosition()) && !this.clamper.isRegistered()) {
                this.clamper.registerTick();
            }
            this.scroll = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals(this.scroll, this.target, (double)0.001f) ? (double)((float)DynamicNewSmoothScrollingEntryListWidget.Interpolation.expoEase(this.scroll, this.target, Math.min((double)(System.currentTimeMillis() - this.start) / (double)this.duration, 1.0))) : this.target;
        }

        @Override
        public void lateRender(int mouseX, int mouseY, float delta) {
            int last10Height = this.getHeight();
            int cWidth = this.getCellCreator().getCellWidth();
            DefaultDropdownMenuElement.fill((int)this.lastRectangle.x, (int)(this.lastRectangle.y + this.lastRectangle.height), (int)(this.lastRectangle.x + cWidth), (int)(this.lastRectangle.y + this.lastRectangle.height + last10Height + 1), (int)-6250336);
            DefaultDropdownMenuElement.fill((int)(this.lastRectangle.x + 1), (int)(this.lastRectangle.y + this.lastRectangle.height + 1), (int)(this.lastRectangle.x + cWidth - 1), (int)(this.lastRectangle.y + this.lastRectangle.height + last10Height), (int)-16777216);
            RenderHelper.pushMatrix();
            ScissorsHandler.INSTANCE.scissor(new Rectangle(this.lastRectangle.x, this.lastRectangle.y + this.lastRectangle.height + 1, cWidth - 6, last10Height - 1));
            double yy = (double)(this.lastRectangle.y + this.lastRectangle.height) - this.scroll;
            for (SelectionCellElement<R> cell : this.currentElements) {
                if (yy + (double)this.getCellCreator().getCellHeight() >= (double)(this.lastRectangle.y + this.lastRectangle.height) && yy <= (double)(this.lastRectangle.y + this.lastRectangle.height + last10Height + 1)) {
                    cell.render(mouseX, mouseY, this.lastRectangle.x, (int)yy, this.getMaxScrollPosition() > 6.0 ? this.getCellCreator().getCellWidth() - 6 : this.getCellCreator().getCellWidth(), this.getCellCreator().getCellHeight(), delta);
                } else {
                    cell.dontRender(delta);
                }
                yy += (double)this.getCellCreator().getCellHeight();
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            if (this.currentElements.isEmpty()) {
                class_327 textRenderer = class_310.method_1551().field_1772;
                String s = class_1074.method_4662((String)"text.cloth-config.dropdown.value.unknown", (Object[])new Object[0]);
                textRenderer.method_1720(s, (float)(this.lastRectangle.x + this.getCellCreator().getCellWidth() / 2 - textRenderer.method_1727(s) / 2), (float)(this.lastRectangle.y + this.lastRectangle.height + 3), -1);
            }
            if (this.getMaxScrollPosition() > 6.0) {
                RenderHelper.disableTexture();
                int scrollbarPositionMinX = this.lastRectangle.x + this.getCellCreator().getCellWidth() - 6;
                int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
                int height = (int)((double)(last10Height * last10Height) / this.getMaxScrollPosition());
                height = class_3532.method_15340((int)height, (int)32, (int)(last10Height - 8));
                height = (int)((double)height - Math.min(this.scroll < 0.0 ? (double)((int)(-this.scroll)) : (this.scroll > this.getMaxScrollPosition() ? (double)((int)this.scroll) - this.getMaxScrollPosition() : 0.0), (double)height * 0.95));
                height = Math.max(10, height);
                int minY = (int)Math.min(Math.max((double)((int)this.scroll * (last10Height - height)) / this.getMaxScrollPosition() + (double)(this.lastRectangle.y + this.lastRectangle.height + 1), (double)(this.lastRectangle.y + this.lastRectangle.height + 1)), (double)(this.lastRectangle.y + this.lastRectangle.height + 1 + last10Height - height));
                int bottomc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse()) ? 168 : 128;
                int topc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse()) ? 222 : 172;
                class_289 tessellator = class_289.method_1348();
                class_287 buffer = tessellator.method_1349();
                buffer.method_1328(7, class_290.field_1575);
                buffer.method_1315((double)scrollbarPositionMinX, (double)(minY + height), 0.0).method_1313(0, 1).method_1323(bottomc, bottomc, bottomc, 255).method_1344();
                buffer.method_1315((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).method_1313(1, 1).method_1323(bottomc, bottomc, bottomc, 255).method_1344();
                buffer.method_1315((double)scrollbarPositionMaxX, (double)minY, 0.0).method_1313(1, 0).method_1323(bottomc, bottomc, bottomc, 255).method_1344();
                buffer.method_1315((double)scrollbarPositionMinX, (double)minY, 0.0).method_1313(0, 0).method_1323(bottomc, bottomc, bottomc, 255).method_1344();
                tessellator.method_1350();
                buffer.method_1328(7, class_290.field_1575);
                buffer.method_1315((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).method_1313(0, 1).method_1323(topc, topc, topc, 255).method_1344();
                buffer.method_1315((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).method_1313(1, 1).method_1323(topc, topc, topc, 255).method_1344();
                buffer.method_1315((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).method_1313(1, 0).method_1323(topc, topc, topc, 255).method_1344();
                buffer.method_1315((double)scrollbarPositionMinX, (double)minY, 0.0).method_1313(0, 0).method_1323(topc, topc, topc, 255).method_1344();
                tessellator.method_1350();
                RenderHelper.enableTexture();
            }
            RenderHelper.popMatrix();
        }

        @Override
        public int getHeight() {
            return Math.max(Math.min(this.getCellCreator().getDropBoxMaxHeight(), (int)this.getMaxScroll()), 14);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.isExpended() && mouseX >= (double)this.lastRectangle.x && mouseX <= (double)(this.lastRectangle.x + this.getCellCreator().getCellWidth()) && mouseY >= (double)(this.lastRectangle.y + this.lastRectangle.height) && mouseY <= (double)(this.lastRectangle.y + this.lastRectangle.height + this.getHeight() + 1);
        }

        public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
            if (!this.isExpended()) {
                return false;
            }
            if (int_1 == 0 && this.scrolling) {
                if (double_2 < (double)this.lastRectangle.y + (double)this.lastRectangle.height) {
                    this.scrollTo(0.0, false);
                } else if (double_2 > (double)this.lastRectangle.y + (double)this.lastRectangle.height + (double)this.getHeight()) {
                    this.scrollTo(this.getMaxScrollPosition(), false);
                } else {
                    double double_5 = Math.max(1.0, this.getMaxScrollPosition());
                    int int_2 = this.getHeight();
                    int int_3 = class_3532.method_15340((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                    double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                    this.offset(double_4 * double_6, false);
                }
                this.target = class_3532.method_15350((double)this.target, (double)0.0, (double)this.getMaxScrollPosition());
                return true;
            }
            return false;
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double double_3) {
            if (this.isMouseOver(mouseX, mouseY)) {
                this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
                return true;
            }
            return false;
        }

        protected void updateScrollingState(double double_1, double double_2, int int_1) {
            this.scrolling = this.isExpended() && this.lastRectangle != null && int_1 == 0 && double_1 >= (double)this.lastRectangle.x + (double)this.getCellCreator().getCellWidth() - 6.0 && double_1 < (double)(this.lastRectangle.x + this.getCellCreator().getCellWidth());
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            if (!this.isExpended()) {
                return false;
            }
            this.updateScrollingState(double_1, double_2, int_1);
            return super.mouseClicked(double_1, double_2, int_1) || this.scrolling;
        }

        public void offset(double value, boolean animated) {
            this.scrollTo(this.target + value, animated);
        }

        public void scrollTo(double value, boolean animated) {
            this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
        }

        public void scrollTo(double value, boolean animated, long duration) {
            this.target = this.clamp(value);
            if (animated) {
                this.start = System.currentTimeMillis();
                this.duration = duration;
            } else {
                this.scroll = this.target;
            }
        }

        @Override
        public List<SelectionCellElement<R>> children() {
            return this.currentElements;
        }
    }

    public static abstract class DropdownMenuElement<R>
    extends class_362 {
        @Deprecated
        @Nonnull
        private SelectionCellCreator<R> cellCreator;
        @Deprecated
        @Nonnull
        private DropdownBoxEntry<R> entry;

        @Nonnull
        public SelectionCellCreator<R> getCellCreator() {
            return this.cellCreator;
        }

        @Nonnull
        public final DropdownBoxEntry<R> getEntry() {
            return this.entry;
        }

        @Nonnull
        public abstract ImmutableList<R> getSelections();

        public abstract void initCells();

        public abstract void render(int var1, int var2, Rectangle var3, float var4);

        public abstract void lateRender(int var1, int var2, float var3);

        public abstract int getHeight();

        public final boolean isExpended() {
            return (this.getEntry().selectionElement.getFocused() == this.getEntry().selectionElement.topRenderer || this.getEntry().selectionElement.getFocused() == this.getEntry().selectionElement.menu) && this.getEntry().getFocused() == this.getEntry().selectionElement && this.getEntry().getParent().getFocused() == this.getEntry();
        }

        public abstract List<SelectionCellElement<R>> children();
    }

    public static class SelectionElement<R>
    extends class_362
    implements class_4068 {
        protected Rectangle bounds;
        protected boolean active;
        protected SelectionTopCellElement<R> topRenderer;
        protected DropdownBoxEntry<R> entry;
        protected DropdownMenuElement<R> menu;
        protected boolean dontReFocus = false;

        public SelectionElement(DropdownBoxEntry<R> entry, Rectangle bounds, DropdownMenuElement<R> menu, SelectionTopCellElement<R> topRenderer, SelectionCellCreator<R> cellCreator) {
            this.bounds = bounds;
            this.entry = entry;
            this.menu = Objects.requireNonNull(menu);
            ((DropdownMenuElement)this.menu).entry = entry;
            ((DropdownMenuElement)this.menu).cellCreator = Objects.requireNonNull(cellCreator);
            this.menu.initCells();
            this.topRenderer = Objects.requireNonNull(topRenderer);
            ((SelectionTopCellElement)this.topRenderer).entry = entry;
        }

        public void render(int mouseX, int mouseY, float delta) {
            SelectionElement.fill((int)this.bounds.x, (int)this.bounds.y, (int)(this.bounds.x + this.bounds.width), (int)(this.bounds.y + this.bounds.height), (int)-6250336);
            SelectionElement.fill((int)(this.bounds.x + 1), (int)(this.bounds.y + 1), (int)(this.bounds.x + this.bounds.width - 1), (int)(this.bounds.y + this.bounds.height - 1), (int)-16777216);
            this.topRenderer.render(mouseX, mouseY, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, delta);
            if (this.menu.isExpended()) {
                this.menu.render(mouseX, mouseY, this.bounds, delta);
            }
        }

        public boolean mouseScrolled(double double_1, double double_2, double double_3) {
            if (this.menu.isExpended()) {
                return this.menu.mouseScrolled(double_1, double_2, double_3);
            }
            return false;
        }

        public void lateRender(int mouseX, int mouseY, float delta) {
            if (this.menu.isExpended()) {
                this.menu.lateRender(mouseX, mouseY, delta);
            }
        }

        public int getMorePossibleHeight() {
            if (this.menu.isExpended()) {
                return this.menu.getHeight();
            }
            return -1;
        }

        public R getValue() {
            return this.topRenderer.getValue();
        }

        public List<? extends class_364> children() {
            return Lists.newArrayList((Object[])new class_362[]{this.topRenderer, this.menu});
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            this.dontReFocus = false;
            boolean b = super.mouseClicked(double_1, double_2, int_1);
            if (this.dontReFocus) {
                this.setFocused(null);
                this.dontReFocus = false;
            }
            return b;
        }
    }
}

