/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.gui.entries.BaseListCell;
import me.shedaniel.clothconfig2.gui.entries.BaseListEntry;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;

public class FloatListListEntry
extends BaseListEntry<Float, FloatListCell> {
    private float minimum = -3.4028235E38f;
    private float maximum = Float.MAX_VALUE;
    private Function<Float, Optional<String>> cellErrorSupplier;

    @Deprecated
    public FloatListListEntry(String fieldName, List<Float> value, boolean defaultExpended, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Float>> saveConsumer, Supplier<List<Float>> defaultValue, String resetButtonKey) {
        this(fieldName, value, defaultExpended, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false);
    }

    @Deprecated
    public FloatListListEntry(String fieldName, List<Float> value, boolean defaultExpended, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Float>> saveConsumer, Supplier<List<Float>> defaultValue, String resetButtonKey, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, defaultValue, (BaseListEntry baseListEntry) -> new FloatListCell(0.0f, (FloatListListEntry)((Object)baseListEntry)), saveConsumer, resetButtonKey, requiresRestart);
        for (float f : value) {
            this.cells.add(new FloatListCell(f, this));
        }
        this.widgets.addAll(this.cells);
        this.expended = defaultExpended;
    }

    public Function<Float, Optional<String>> getCellErrorSupplier() {
        return this.cellErrorSupplier;
    }

    public void setCellErrorSupplier(Function<Float, Optional<String>> cellErrorSupplier) {
        this.cellErrorSupplier = cellErrorSupplier;
    }

    @Override
    public List<Float> getValue() {
        return this.cells.stream().map(FloatListCell::getValue).collect(Collectors.toList());
    }

    public FloatListListEntry setMaximum(float maximum) {
        this.maximum = maximum;
        return this;
    }

    public FloatListListEntry setMinimum(float minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    protected FloatListCell getFromValue(Float value) {
        return new FloatListCell(value.floatValue(), this);
    }

    public static class FloatListCell
    extends BaseListCell {
        private Function<String, String> stripCharacters = s -> {
            StringBuilder stringBuilder_1 = new StringBuilder();
            char[] var2 = s.toCharArray();
            int var3 = var2.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                if (!Character.isDigit(var2[var4]) && var2[var4] != '-' && var2[var4] != '.') continue;
                stringBuilder_1.append(var2[var4]);
            }
            return stringBuilder_1.toString();
        };
        private class_342 widget;
        private boolean isSelected;
        private FloatListListEntry listListEntry;

        public FloatListCell(float value, FloatListListEntry listListEntry) {
            this.listListEntry = listListEntry;
            this.setErrorSupplier(() -> listListEntry.cellErrorSupplier == null ? Optional.empty() : listListEntry.getCellErrorSupplier().apply(Float.valueOf(this.getValue())));
            this.widget = new class_342(class_310.method_1551().field_1772, 0, 0, 100, 18, ""){

                public void render(int int_1, int int_2, float float_1) {
                    boolean f = this.isFocused();
                    this.setFocused(isSelected);
                    widget.method_1868(this.getPreferredTextColor());
                    super.render(int_1, int_2, float_1);
                    this.setFocused(f);
                }

                public void method_1867(String string_1) {
                    super.method_1867((String)stripCharacters.apply(string_1));
                }
            };
            this.widget.method_1880(999999);
            this.widget.method_1858(false);
            this.widget.method_1852(value + "");
            this.widget.method_1863(s -> {
                if (!(value + "").equalsIgnoreCase((String)s)) {
                    listListEntry.getScreen().setEdited(true, listListEntry.isRequiresRestart());
                }
            });
        }

        public float getValue() {
            try {
                return Float.valueOf(this.widget.method_1882()).floatValue();
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }

        @Override
        public Optional<String> getError() {
            try {
                float i = Float.valueOf(this.widget.method_1882()).floatValue();
                if (i > this.listListEntry.maximum) {
                    return Optional.of(class_1074.method_4662((String)"text.cloth-config.error.too_large", (Object[])new Object[]{Float.valueOf(this.listListEntry.maximum)}));
                }
                if (i < this.listListEntry.minimum) {
                    return Optional.of(class_1074.method_4662((String)"text.cloth-config.error.too_small", (Object[])new Object[]{Float.valueOf(this.listListEntry.minimum)}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(class_1074.method_4662((String)"text.cloth-config.error.not_valid_number_float", (Object[])new Object[0]));
            }
            return Optional.empty();
        }

        @Override
        public int getCellHeight() {
            return 20;
        }

        @Override
        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.widget.setWidth(entryWidth - 12);
            this.widget.x = x;
            this.widget.y = y + 1;
            this.widget.method_1888(this.listListEntry.isEditable());
            this.isSelected = isSelected;
            this.widget.render(mouseX, mouseY, delta);
            if (isSelected && this.listListEntry.isEditable()) {
                FloatListCell.fill((int)x, (int)(y + 12), (int)(x + entryWidth - 12), (int)(y + 13), (int)(this.getConfigError().isPresent() ? -43691 : -2039584));
            }
        }

        public List<? extends class_364> children() {
            return Collections.singletonList(this.widget);
        }
    }
}

