/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TextFieldListEntry;
import net.minecraft.class_1074;
import net.minecraft.class_342;

public class IntegerListEntry
extends TextFieldListEntry<Integer> {
    private static Function<String, String> stripCharacters = s -> {
        StringBuilder stringBuilder_1 = new StringBuilder();
        char[] var2 = s.toCharArray();
        int var3 = var2.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            if (!Character.isDigit(var2[var4]) && var2[var4] != '-') continue;
            stringBuilder_1.append(var2[var4]);
        }
        return stringBuilder_1.toString();
    };
    private int minimum = -2147483647;
    private int maximum = Integer.MAX_VALUE;
    private Consumer<Integer> saveConsumer;

    @Deprecated
    public IntegerListEntry(String fieldName, Integer value, Consumer<Integer> saveConsumer) {
        this(fieldName, value, "text.cloth-config.reset_value", null, saveConsumer);
    }

    @Deprecated
    public IntegerListEntry(String fieldName, Integer value, String resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveConsumer = saveConsumer;
    }

    @Deprecated
    public IntegerListEntry(String fieldName, Integer value, String resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer, Supplier<Optional<String[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    public IntegerListEntry(String fieldName, Integer value, String resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer, Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveConsumer = saveConsumer;
    }

    @Override
    protected String stripAddText(String s) {
        return stripCharacters.apply(s);
    }

    @Override
    protected void textFieldPreRender(class_342 widget) {
        try {
            double i = Integer.valueOf(this.textFieldWidget.method_1882()).intValue();
            if (i < (double)this.minimum || i > (double)this.maximum) {
                widget.method_1868(0xFF5555);
            } else {
                widget.method_1868(0xE0E0E0);
            }
        }
        catch (NumberFormatException ex) {
            widget.method_1868(0xFF5555);
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        return this.getDefaultValue().isPresent() ? text.equals(((Integer)this.defaultValue.get()).toString()) : false;
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public IntegerListEntry setMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    public IntegerListEntry setMinimum(int minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public Integer getValue() {
        try {
            return Integer.valueOf(this.textFieldWidget.method_1882());
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public Optional<String> getError() {
        try {
            int i = Integer.valueOf(this.textFieldWidget.method_1882());
            if (i > this.maximum) {
                return Optional.of(class_1074.method_4662((String)"text.cloth-config.error.too_large", (Object[])new Object[]{this.maximum}));
            }
            if (i < this.minimum) {
                return Optional.of(class_1074.method_4662((String)"text.cloth-config.error.too_small", (Object[])new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(class_1074.method_4662((String)"text.cloth-config.error.not_valid_number_int", (Object[])new Object[0]));
        }
        return super.getError();
    }
}

