/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class SelectionListEntry<T>
extends TooltipListEntry<T> {
    private ImmutableList<T> values;
    private AtomicInteger index;
    private class_4185 buttonWidget;
    private class_4185 resetButton;
    private Consumer<T> saveConsumer;
    private Supplier<T> defaultValue;
    private List<class_364> widgets;
    private Function<T, String> nameProvider;

    @Deprecated
    public SelectionListEntry(String fieldName, T[] valuesArray, T value, Consumer<T> saveConsumer) {
        this(fieldName, valuesArray, value, "text.cloth-config.reset_value", null, saveConsumer);
    }

    @Deprecated
    public SelectionListEntry(String fieldName, T[] valuesArray, T value, String resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer) {
        this(fieldName, valuesArray, value, resetButtonKey, defaultValue, saveConsumer, null);
    }

    @Deprecated
    public SelectionListEntry(String fieldName, T[] valuesArray, T value, String resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer, Function<T, String> nameProvider) {
        this(fieldName, valuesArray, value, resetButtonKey, defaultValue, saveConsumer, nameProvider, null);
    }

    @Deprecated
    public SelectionListEntry(String fieldName, T[] valuesArray, T value, String resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer, Function<T, String> nameProvider, Supplier<Optional<String[]>> tooltipSupplier) {
        this(fieldName, valuesArray, value, resetButtonKey, defaultValue, saveConsumer, nameProvider, tooltipSupplier, false);
    }

    @Deprecated
    public SelectionListEntry(String fieldName, T[] valuesArray, T value, String resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer, Function<T, String> nameProvider, Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.values = valuesArray != null ? ImmutableList.copyOf((Object[])valuesArray) : ImmutableList.of(value);
        this.defaultValue = defaultValue;
        this.index = new AtomicInteger(this.values.indexOf(value));
        this.index.compareAndSet(-1, 0);
        this.buttonWidget = new class_4185(0, 0, 150, 20, "", widget -> {
            this.index.incrementAndGet();
            this.index.compareAndSet(this.values.size(), 0);
            this.getScreen().setEdited(true, this.isRequiresRestart());
        });
        this.resetButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_1727(class_1074.method_4662((String)resetButtonKey, (Object[])new Object[0])) + 6, 20, class_1074.method_4662((String)resetButtonKey, (Object[])new Object[0]), widget -> {
            this.index.set(this.getDefaultIndex());
            this.getScreen().setEdited(true, this.isRequiresRestart());
        });
        this.saveConsumer = saveConsumer;
        this.widgets = Lists.newArrayList((Object[])new class_364[]{this.buttonWidget, this.resetButton});
        this.nameProvider = nameProvider == null ? t -> class_1074.method_4662((String)(t instanceof Translatable ? ((Translatable)t).getKey() : t.toString()), (Object[])new Object[0]) : nameProvider;
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    public T getValue() {
        return (T)this.values.get(this.index.get());
    }

    @Override
    public Optional<T> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        class_1041 window = class_310.method_1551().field_1704;
        this.resetButton.active = this.isEditable() && this.getDefaultValue().isPresent() && this.getDefaultIndex() != this.index.get();
        this.resetButton.y = y;
        this.buttonWidget.active = this.isEditable();
        this.buttonWidget.y = y;
        this.buttonWidget.setMessage(this.nameProvider.apply(this.getValue()));
        if (class_310.method_1551().field_1772.method_1726()) {
            class_310.method_1551().field_1772.method_1720(class_1074.method_4662((String)this.getFieldName(), (Object[])new Object[0]), (float)(window.method_4486() - x - class_310.method_1551().field_1772.method_1727(class_1074.method_4662((String)this.getFieldName(), (Object[])new Object[0]))), (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.x = x;
            this.buttonWidget.x = x + this.resetButton.getWidth() + 2;
            this.buttonWidget.setWidth(150 - this.resetButton.getWidth() - 2);
        } else {
            class_310.method_1551().field_1772.method_1720(class_1074.method_4662((String)this.getFieldName(), (Object[])new Object[0]), (float)x, (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.x = x + entryWidth - this.resetButton.getWidth();
            this.buttonWidget.x = x + entryWidth - 150;
            this.buttonWidget.setWidth(150 - this.resetButton.getWidth() - 2);
        }
        this.resetButton.render(mouseX, mouseY, delta);
        this.buttonWidget.render(mouseX, mouseY, delta);
    }

    private int getDefaultIndex() {
        return Math.max(0, this.values.indexOf(this.defaultValue.get()));
    }

    public List<? extends class_364> children() {
        return this.widgets;
    }

    public static interface Translatable {
        @Nonnull
        public String getKey();
    }
}

