/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;

public class BooleanToggleBuilder
extends FieldBuilder<Boolean, BooleanListEntry> {
    @Nullable
    private Consumer<Boolean> saveConsumer = null;
    @Nonnull
    private Function<Boolean, Optional<String[]>> tooltipSupplier = bool -> Optional.empty();
    private boolean value;
    @Nullable
    private Function<Boolean, String> yesNoTextSupplier = null;

    public BooleanToggleBuilder(String resetButtonKey, String fieldNameKey, boolean value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    public BooleanToggleBuilder setErrorSupplier(@Nullable Function<Boolean, Optional<String>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public BooleanToggleBuilder requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public BooleanToggleBuilder setSaveConsumer(Consumer<Boolean> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public BooleanToggleBuilder setDefaultValue(Supplier<Boolean> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public BooleanToggleBuilder setDefaultValue(boolean defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public BooleanToggleBuilder setTooltipSupplier(@Nonnull Function<Boolean, Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public BooleanToggleBuilder setTooltipSupplier(@Nonnull Supplier<Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = bool -> (Optional)tooltipSupplier.get();
        return this;
    }

    public BooleanToggleBuilder setTooltip(Optional<String[]> tooltip) {
        this.tooltipSupplier = bool -> tooltip;
        return this;
    }

    public BooleanToggleBuilder setTooltip(String ... tooltip) {
        this.tooltipSupplier = bool -> Optional.ofNullable(tooltip);
        return this;
    }

    @Nullable
    public Function<Boolean, String> getYesNoTextSupplier() {
        return this.yesNoTextSupplier;
    }

    public BooleanToggleBuilder setYesNoTextSupplier(@Nullable Function<Boolean, String> yesNoTextSupplier) {
        this.yesNoTextSupplier = yesNoTextSupplier;
        return this;
    }

    @Override
    public BooleanListEntry build() {
        BooleanListEntry entry = new BooleanListEntry(this.getFieldNameKey(), this.value, this.getResetButtonKey(), this.defaultValue, this.saveConsumer, null, this.isRequireRestart()){

            @Override
            public String getYesNoText(boolean bool) {
                if (BooleanToggleBuilder.this.yesNoTextSupplier == null) {
                    return super.getYesNoText(bool);
                }
                return (String)BooleanToggleBuilder.this.yesNoTextSupplier.apply(bool);
            }
        };
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

