/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.BaseListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListListEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.class_1074;

public class DoubleListBuilder
extends FieldBuilder<List<Double>, DoubleListListEntry> {
    protected Function<Double, Optional<String>> cellErrorSupplier;
    private Consumer<List<Double>> saveConsumer = null;
    private Function<List<Double>, Optional<String[]>> tooltipSupplier = list -> Optional.empty();
    private List<Double> value;
    private boolean expended = false;
    private Double min = null;
    private Double max = null;
    private Function<BaseListEntry, DoubleListListEntry.DoubleListCell> createNewInstance;
    private String addTooltip = class_1074.method_4662((String)"text.cloth-config.list.add", (Object[])new Object[0]);
    private String removeTooltip = class_1074.method_4662((String)"text.cloth-config.list.remove", (Object[])new Object[0]);
    private boolean deleteButtonEnabled = true;
    private boolean insertInFront = true;

    public DoubleListBuilder(String resetButtonKey, String fieldNameKey, List<Double> value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    public Function<Double, Optional<String>> getCellErrorSupplier() {
        return this.cellErrorSupplier;
    }

    public DoubleListBuilder setCellErrorSupplier(Function<Double, Optional<String>> cellErrorSupplier) {
        this.cellErrorSupplier = cellErrorSupplier;
        return this;
    }

    public DoubleListBuilder setErrorSupplier(Function<List<Double>, Optional<String>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public DoubleListBuilder setDeleteButtonEnabled(boolean deleteButtonEnabled) {
        this.deleteButtonEnabled = deleteButtonEnabled;
        return this;
    }

    public DoubleListBuilder setInsertInFront(boolean insertInFront) {
        this.insertInFront = insertInFront;
        return this;
    }

    public DoubleListBuilder setAddButtonTooltip(String addTooltip) {
        this.addTooltip = addTooltip;
        return this;
    }

    public DoubleListBuilder setRemoveButtonTooltip(String removeTooltip) {
        this.removeTooltip = removeTooltip;
        return this;
    }

    public DoubleListBuilder requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public DoubleListBuilder setCreateNewInstance(Function<BaseListEntry, DoubleListListEntry.DoubleListCell> createNewInstance) {
        this.createNewInstance = createNewInstance;
        return this;
    }

    public DoubleListBuilder setExpended(boolean expended) {
        this.expended = expended;
        return this;
    }

    public DoubleListBuilder setSaveConsumer(Consumer<List<Double>> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public DoubleListBuilder setDefaultValue(Supplier<List<Double>> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DoubleListBuilder setMin(double min) {
        this.min = min;
        return this;
    }

    public DoubleListBuilder setMax(double max) {
        this.max = max;
        return this;
    }

    public DoubleListBuilder removeMin() {
        this.min = null;
        return this;
    }

    public DoubleListBuilder removeMax() {
        this.max = null;
        return this;
    }

    public DoubleListBuilder setDefaultValue(List<Double> defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public DoubleListBuilder setTooltipSupplier(Function<List<Double>, Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public DoubleListBuilder setTooltipSupplier(Supplier<Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = list -> (Optional)tooltipSupplier.get();
        return this;
    }

    public DoubleListBuilder setTooltip(Optional<String[]> tooltip) {
        this.tooltipSupplier = list -> tooltip;
        return this;
    }

    public DoubleListBuilder setTooltip(String ... tooltip) {
        this.tooltipSupplier = list -> Optional.ofNullable(tooltip);
        return this;
    }

    @Override
    public DoubleListListEntry build() {
        DoubleListListEntry entry = new DoubleListListEntry(this.getFieldNameKey(), this.value, this.expended, null, this.saveConsumer, this.defaultValue, this.getResetButtonKey(), this.isRequireRestart()){

            @Override
            public boolean isDeleteButtonEnabled() {
                return DoubleListBuilder.this.deleteButtonEnabled;
            }

            @Override
            public boolean insertInFront() {
                return DoubleListBuilder.this.insertInFront;
            }
        };
        if (this.min != null) {
            entry.setMinimum(this.min);
        }
        if (this.max != null) {
            entry.setMaximum(this.max);
        }
        if (this.createNewInstance != null) {
            entry.setCreateNewInstance(this.createNewInstance);
        }
        entry.setCellErrorSupplier(this.cellErrorSupplier);
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply((List<Double>)entry.getValue()));
        entry.setAddTooltip(this.addTooltip);
        entry.setRemoveTooltip(this.removeTooltip);
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

