/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.BaseListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListListEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.class_1074;

public class IntListBuilder
extends FieldBuilder<List<Integer>, IntegerListListEntry> {
    protected Function<Integer, Optional<String>> cellErrorSupplier;
    private Consumer<List<Integer>> saveConsumer = null;
    private Function<List<Integer>, Optional<String[]>> tooltipSupplier = list -> Optional.empty();
    private List<Integer> value;
    private boolean expended = false;
    private Integer min = null;
    private Integer max = null;
    private Function<BaseListEntry, IntegerListListEntry.IntegerListCell> createNewInstance;
    private String addTooltip = class_1074.method_4662((String)"text.cloth-config.list.add", (Object[])new Object[0]);
    private String removeTooltip = class_1074.method_4662((String)"text.cloth-config.list.remove", (Object[])new Object[0]);
    private boolean deleteButtonEnabled = true;
    private boolean insertInFront = true;

    public IntListBuilder(String resetButtonKey, String fieldNameKey, List<Integer> value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    public Function<Integer, Optional<String>> getCellErrorSupplier() {
        return this.cellErrorSupplier;
    }

    public IntListBuilder setCellErrorSupplier(Function<Integer, Optional<String>> cellErrorSupplier) {
        this.cellErrorSupplier = cellErrorSupplier;
        return this;
    }

    public IntListBuilder setErrorSupplier(Function<List<Integer>, Optional<String>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public IntListBuilder setDeleteButtonEnabled(boolean deleteButtonEnabled) {
        this.deleteButtonEnabled = deleteButtonEnabled;
        return this;
    }

    public IntListBuilder setInsertInFront(boolean insertInFront) {
        this.insertInFront = insertInFront;
        return this;
    }

    public IntListBuilder setAddButtonTooltip(String addTooltip) {
        this.addTooltip = addTooltip;
        return this;
    }

    public IntListBuilder setRemoveButtonTooltip(String removeTooltip) {
        this.removeTooltip = removeTooltip;
        return this;
    }

    public IntListBuilder requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public IntListBuilder setCreateNewInstance(Function<BaseListEntry, IntegerListListEntry.IntegerListCell> createNewInstance) {
        this.createNewInstance = createNewInstance;
        return this;
    }

    public IntListBuilder setExpended(boolean expended) {
        this.expended = expended;
        return this;
    }

    public IntListBuilder setSaveConsumer(Consumer<List<Integer>> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public IntListBuilder setDefaultValue(Supplier<List<Integer>> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public IntListBuilder setMin(int min) {
        this.min = min;
        return this;
    }

    public IntListBuilder setMax(int max) {
        this.max = max;
        return this;
    }

    public IntListBuilder removeMin() {
        this.min = null;
        return this;
    }

    public IntListBuilder removeMax() {
        this.max = null;
        return this;
    }

    public IntListBuilder setDefaultValue(List<Integer> defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public IntListBuilder setTooltipSupplier(Function<List<Integer>, Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public IntListBuilder setTooltipSupplier(Supplier<Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = list -> (Optional)tooltipSupplier.get();
        return this;
    }

    public IntListBuilder setTooltip(Optional<String[]> tooltip) {
        this.tooltipSupplier = list -> tooltip;
        return this;
    }

    public IntListBuilder setTooltip(String ... tooltip) {
        this.tooltipSupplier = list -> Optional.ofNullable(tooltip);
        return this;
    }

    @Override
    public IntegerListListEntry build() {
        IntegerListListEntry entry = new IntegerListListEntry(this.getFieldNameKey(), this.value, this.expended, null, this.saveConsumer, this.defaultValue, this.getResetButtonKey(), this.isRequireRestart()){

            @Override
            public boolean isDeleteButtonEnabled() {
                return IntListBuilder.this.deleteButtonEnabled;
            }

            @Override
            public boolean insertInFront() {
                return IntListBuilder.this.insertInFront;
            }
        };
        if (this.min != null) {
            entry.setMinimum(this.min);
        }
        if (this.max != null) {
            entry.setMaximum(this.max);
        }
        if (this.createNewInstance != null) {
            entry.setCreateNewInstance(this.createNewInstance);
        }
        entry.setCellErrorSupplier(this.cellErrorSupplier);
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply((List<Integer>)entry.getValue()));
        entry.setAddTooltip(this.addTooltip);
        entry.setRemoveTooltip(this.removeTooltip);
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

