/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.QueuedTooltip;
import me.shedaniel.clothconfig2.gui.entries.BaseListCell;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class BaseListEntry<T, C extends BaseListCell, SELF extends BaseListEntry<T, C, SELF>>
extends TooltipListEntry<List<T>> {
    protected static final class_2960 CONFIG_TEX = new class_2960("cloth-config2", "textures/gui/cloth_config.png");
    protected final @NotNull List<C> cells;
    protected final @NotNull List<class_364> widgets;
    protected boolean expanded;
    protected boolean deleteButtonEnabled;
    protected boolean insertInFront;
    protected @Nullable Consumer<List<T>> saveConsumer;
    protected ListLabelWidget labelWidget;
    protected class_339 resetWidget;
    protected @NotNull Function<SELF, C> createNewInstance;
    protected @NotNull Supplier<List<T>> defaultValue;
    protected @Nullable String addTooltip = class_1074.method_4662((String)"text.cloth-config.list.add", (Object[])new Object[0]);
    protected @Nullable String removeTooltip = class_1074.method_4662((String)"text.cloth-config.list.remove", (Object[])new Object[0]);

    @Deprecated
    public BaseListEntry(@NotNull String fieldName, @Nullable Supplier<Optional<String[]>> tooltipSupplier, @NotNull Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, String resetButtonKey) {
        this(fieldName, tooltipSupplier, defaultValue, createNewInstance, saveConsumer, resetButtonKey, false);
    }

    @Deprecated
    public BaseListEntry(@NotNull String fieldName, @Nullable Supplier<Optional<String[]>> tooltipSupplier, @NotNull Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, String resetButtonKey, boolean requiresRestart) {
        this(fieldName, tooltipSupplier, defaultValue, createNewInstance, saveConsumer, resetButtonKey, requiresRestart, true, true);
    }

    @Deprecated
    public BaseListEntry(@NotNull String fieldName, @Nullable Supplier<Optional<String[]>> tooltipSupplier, @NotNull Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, String resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.deleteButtonEnabled = deleteButtonEnabled;
        this.insertInFront = insertInFront;
        this.cells = Lists.newArrayList();
        this.labelWidget = new ListLabelWidget();
        this.widgets = Lists.newArrayList((Object[])new class_364[]{this.labelWidget});
        this.resetWidget = new class_4185(0, 0, class_310.method_1551().field_1772.method_1727(class_1074.method_4662((String)resetButtonKey, (Object[])new Object[0])) + 6, 20, class_1074.method_4662((String)resetButtonKey, (Object[])new Object[0]), widget -> {
            this.widgets.removeAll(this.cells);
            this.cells.clear();
            ((List)defaultValue.get()).stream().map(this::getFromValue).forEach(this.cells::add);
            this.widgets.addAll(this.cells);
            this.getScreen().setEdited(true, this.isRequiresRestart());
        });
        this.widgets.add((class_364)this.resetWidget);
        this.saveConsumer = saveConsumer;
        this.createNewInstance = createNewInstance;
        this.defaultValue = defaultValue;
    }

    public abstract SELF self();

    public boolean isDeleteButtonEnabled() {
        return this.deleteButtonEnabled;
    }

    protected abstract C getFromValue(T var1);

    public @NotNull Function<SELF, C> getCreateNewInstance() {
        return this.createNewInstance;
    }

    public void setCreateNewInstance(@NotNull Function<SELF, C> createNewInstance) {
        this.createNewInstance = createNewInstance;
    }

    public @Nullable String getAddTooltip() {
        return this.addTooltip;
    }

    public void setAddTooltip(@Nullable String addTooltip) {
        this.addTooltip = addTooltip;
    }

    public @Nullable String getRemoveTooltip() {
        return this.removeTooltip;
    }

    public void setRemoveTooltip(@Nullable String removeTooltip) {
        this.removeTooltip = removeTooltip;
    }

    @Override
    public Optional<List<T>> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue.get());
    }

    @Override
    public int getItemHeight() {
        if (this.expanded) {
            int i = 24;
            for (BaseListCell entry : this.cells) {
                i += entry.getCellHeight();
            }
            return i;
        }
        return 24;
    }

    public List<? extends class_364> children() {
        if (!this.expanded) {
            ArrayList<class_364> elements = new ArrayList<class_364>(this.widgets);
            elements.removeAll(this.cells);
            return elements;
        }
        return this.widgets;
    }

    @Override
    public Optional<String> getError() {
        List errors = this.cells.stream().map(BaseListCell::getConfigError).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (errors.size() > 1) {
            return Optional.of(class_1074.method_4662((String)"text.cloth-config.multi_error", (Object[])new Object[0]));
        }
        return errors.stream().findFirst();
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
        this.labelWidget.rectangle.x = x - 15;
        this.labelWidget.rectangle.y = y;
        this.labelWidget.rectangle.width = entryWidth + 15;
        this.labelWidget.rectangle.height = 24;
        return this.labelWidget.rectangle.contains(mouseX, mouseY) && this.getParent().isMouseOver(mouseX, mouseY) && !this.resetWidget.isMouseOver((double)mouseX, (double)mouseY);
    }

    protected boolean isInsideCreateNew(double mouseX, double mouseY) {
        return mouseX >= (double)(this.labelWidget.rectangle.x + 12) && mouseY >= (double)(this.labelWidget.rectangle.y + 3) && mouseX <= (double)(this.labelWidget.rectangle.x + 12 + 11) && mouseY <= (double)(this.labelWidget.rectangle.y + 3 + 11);
    }

    protected boolean isInsideDelete(double mouseX, double mouseY) {
        return this.isDeleteButtonEnabled() && mouseX >= (double)(this.labelWidget.rectangle.x + 25) && mouseY >= (double)(this.labelWidget.rectangle.y + 3) && mouseX <= (double)(this.labelWidget.rectangle.x + 25 + 11) && mouseY <= (double)(this.labelWidget.rectangle.y + 3 + 11);
    }

    public Optional<String[]> getTooltip(int mouseX, int mouseY) {
        if (this.addTooltip != null && this.isInsideCreateNew(mouseX, mouseY)) {
            return Optional.of(new String[]{this.addTooltip});
        }
        if (this.removeTooltip != null && this.isInsideDelete(mouseX, mouseY)) {
            return Optional.of(new String[]{this.removeTooltip});
        }
        if (this.getTooltipSupplier() != null) {
            return this.getTooltipSupplier().get();
        }
        return Optional.empty();
    }

    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        Optional<String[]> tooltip;
        this.labelWidget.rectangle.x = x - 19;
        this.labelWidget.rectangle.y = y;
        this.labelWidget.rectangle.width = entryWidth + 19;
        this.labelWidget.rectangle.height = 24;
        if (this.isMouseInside(mouseX, mouseY, x, y, entryWidth, entryHeight) && (tooltip = this.getTooltip(mouseX, mouseY)).isPresent() && tooltip.get().length > 0) {
            this.getScreen().queueTooltip(QueuedTooltip.create(new Point(mouseX, mouseY), tooltip.get()));
        }
        class_310.method_1551().method_1531().method_22813(CONFIG_TEX);
        class_308.method_1450();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BaseListCell focused = !this.expanded || this.getFocused() == null || !(this.getFocused() instanceof BaseListCell) ? null : (BaseListCell)this.getFocused();
        boolean insideCreateNew = this.isInsideCreateNew(mouseX, mouseY);
        boolean insideDelete = this.isInsideDelete(mouseX, mouseY);
        this.blit(x - 15, y + 4, 33, (this.labelWidget.rectangle.contains(mouseX, mouseY) && !insideCreateNew && !insideDelete ? 18 : 0) + (this.expanded ? 9 : 0), 9, 9);
        this.blit(x - 15 + 13, y + 4, 42, insideCreateNew ? 9 : 0, 9, 9);
        if (this.isDeleteButtonEnabled()) {
            this.blit(x - 15 + 26, y + 4, 51, focused == null ? 0 : (insideDelete ? 18 : 9), 9, 9);
        }
        this.resetWidget.x = x + entryWidth - this.resetWidget.getWidth();
        this.resetWidget.y = y;
        this.resetWidget.active = this.isEditable() && this.getDefaultValue().isPresent();
        this.resetWidget.render(mouseX, mouseY, delta);
        class_310.method_1551().field_1772.method_1720(class_1074.method_4662((String)this.getFieldName(), (Object[])new Object[0]), this.isDeleteButtonEnabled() ? (float)(x + 24) : (float)(x + 24 - 9), (float)(y + 5), this.labelWidget.rectangle.contains(mouseX, mouseY) && !this.resetWidget.isMouseOver((double)mouseX, (double)mouseY) && !insideDelete && !insideCreateNew ? -1638890 : this.getPreferredTextColor());
        if (this.expanded) {
            int yy = y + 24;
            for (BaseListCell cell : this.cells) {
                cell.render(-1, yy, x + 14, entryWidth - 14, cell.getCellHeight(), mouseX, mouseY, this.getParent().getFocused() != null && this.getParent().getFocused().equals((Object)this) && this.getFocused() != null && this.getFocused().equals((Object)cell), delta);
                yy += cell.getCellHeight();
            }
        }
    }

    @Override
    public void updateSelected(boolean isSelected) {
        for (BaseListCell cell : this.cells) {
            cell.updateSelected(isSelected && this.getFocused() == cell && this.expanded);
        }
    }

    public boolean insertInFront() {
        return this.insertInFront;
    }

    public class ListLabelWidget
    implements class_364 {
        protected Rectangle rectangle = new Rectangle();

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            if (BaseListEntry.this.resetWidget.isMouseOver(double_1, double_2)) {
                return false;
            }
            if (BaseListEntry.this.isInsideCreateNew(double_1, double_2)) {
                BaseListEntry.this.expanded = true;
                if (BaseListEntry.this.insertInFront()) {
                    BaseListCell cell = (BaseListCell)((Object)BaseListEntry.this.createNewInstance.apply(BaseListEntry.this.self()));
                    BaseListEntry.this.cells.add(0, cell);
                    BaseListEntry.this.widgets.add(0, (class_364)cell);
                } else {
                    BaseListCell cell = (BaseListCell)((Object)BaseListEntry.this.createNewInstance.apply(BaseListEntry.this.self()));
                    BaseListEntry.this.cells.add(cell);
                    BaseListEntry.this.widgets.add((class_364)cell);
                }
                BaseListEntry.this.getScreen().setEdited(true, BaseListEntry.this.isRequiresRestart());
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                return true;
            }
            if (BaseListEntry.this.isDeleteButtonEnabled() && BaseListEntry.this.isInsideDelete(double_1, double_2)) {
                class_364 focused = BaseListEntry.this.getFocused();
                if (BaseListEntry.this.expanded && focused instanceof BaseListCell) {
                    BaseListEntry.this.cells.remove(focused);
                    BaseListEntry.this.widgets.remove(focused);
                    BaseListEntry.this.getScreen().setEdited(true, BaseListEntry.this.isRequiresRestart());
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                }
                return true;
            }
            if (this.rectangle.contains(double_1, double_2)) {
                BaseListEntry.this.expanded = !BaseListEntry.this.expanded;
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                return true;
            }
            return false;
        }
    }
}

