/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.widget;

import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public abstract class DynamicNewSmoothScrollingEntryListWidget<E extends DynamicEntryListWidget.Entry<E>>
extends DynamicEntryListWidget<E> {
    protected double target;
    protected boolean smoothScrolling = true;
    protected long start;
    protected long duration;

    public DynamicNewSmoothScrollingEntryListWidget(class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
        super(client, width, height, top, bottom, backgroundLocation);
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        this.smoothScrolling = smoothScrolling;
    }

    @Override
    public void capYPosition(double double_1) {
        if (!this.smoothScrolling) {
            this.scroll = class_3532.method_15350((double)double_1, (double)0.0, (double)this.getMaxScroll());
        } else {
            this.scroll = ClothConfigInitializer.clamp(double_1, this.getMaxScroll());
            this.target = ClothConfigInitializer.clamp(double_1, this.getMaxScroll());
        }
    }

    @Override
    public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (!this.smoothScrolling) {
            return super.mouseDragged(double_1, double_2, int_1, double_3, double_4);
        }
        if (this.getFocused() != null && this.isDragging() && int_1 == 0 && this.getFocused().mouseDragged(double_1, double_2, int_1, double_3, double_4)) {
            return true;
        }
        if (int_1 == 0 && this.scrolling) {
            if (double_2 < (double)this.top) {
                this.capYPosition(0.0);
            } else if (double_2 > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = class_3532.method_15340((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(class_3532.method_15350((double)(this.getScroll() + double_4 * double_6), (double)0.0, (double)this.getMaxScroll()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        for (DynamicEntryListWidget.Entry entry : this.children()) {
            if (!entry.mouseScrolled(double_1, double_2, double_3)) continue;
            return true;
        }
        if (!this.smoothScrolling) {
            this.scroll += 16.0 * -double_3;
            this.scroll = class_3532.method_15350((double)double_3, (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
        return true;
    }

    public void offset(double value, boolean animated) {
        this.scrollTo(this.target + value, animated);
    }

    public void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    public void scrollTo(double value, boolean animated, long duration) {
        this.target = ClothConfigInitializer.clamp(value, this.getMaxScroll());
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scroll = this.target;
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        double[] target = new double[]{this.target};
        this.scroll = ClothConfigInitializer.handleScrollingPosition(target, this.scroll, this.getMaxScroll(), delta, this.start, this.duration);
        this.target = target[0];
        super.render(mouseX, mouseY, delta);
    }

    @Override
    protected void renderScrollBar(class_289 tessellator, class_287 buffer, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (!this.smoothScrolling) {
            super.renderScrollBar(tessellator, buffer, maxScroll, scrollbarPositionMinX, scrollbarPositionMaxX);
        } else if (maxScroll > 0) {
            int height = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            height = class_3532.method_15340((int)height, (int)32, (int)(this.bottom - this.top - 8));
            height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)this.getMaxScroll() ? (int)this.scroll - this.getMaxScroll() : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.getScroll() * (this.bottom - this.top - height) / maxScroll + this.top, this.top), this.bottom - height);
            int bottomc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse()) ? 168 : 128;
            int topc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse()) ? 222 : 172;
            buffer.method_1328(7, class_290.field_1575);
            buffer.method_22912((double)scrollbarPositionMinX, (double)this.bottom, 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)this.bottom, 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)this.top, 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)this.top, 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            tessellator.method_1350();
            buffer.method_1328(7, class_290.field_1575);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height), 0.0).method_22913(0.0f, 1.0f).method_1336(bottomc, bottomc, bottomc, 255).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).method_22913(1.0f, 1.0f).method_1336(bottomc, bottomc, bottomc, 255).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)minY, 0.0).method_22913(1.0f, 0.0f).method_1336(bottomc, bottomc, bottomc, 255).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22913(0.0f, 0.0f).method_1336(bottomc, bottomc, bottomc, 255).method_1344();
            tessellator.method_1350();
            buffer.method_1328(7, class_290.field_1575);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).method_22913(0.0f, 1.0f).method_1336(topc, topc, topc, 255).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).method_22913(1.0f, 1.0f).method_1336(topc, topc, topc, 255).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).method_22913(1.0f, 0.0f).method_1336(topc, topc, topc, 255).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22913(0.0f, 0.0f).method_1336(topc, topc, topc, 255).method_1344();
            tessellator.method_1350();
        }
    }

    public static class Precision {
        public static final float FLOAT_EPSILON = 0.001f;
        public static final double DOUBLE_EPSILON = 1.0E-7;

        public static boolean almostEquals(float value1, float value2, float acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }

        public static boolean almostEquals(double value1, double value2, double acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }
    }

    public static class Interpolation {
        public static double expoEase(double start, double end, double amount) {
            return start + (end - start) * ClothConfigInitializer.getEasingMethod().apply(amount);
        }
    }
}

