/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.api;

import java.util.function.Consumer;
import me.shedaniel.forge.clothconfig2.api.ConfigCategory;
import me.shedaniel.forge.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.forge.clothconfig2.impl.ConfigBuilderImpl;
import me.shedaniel.forge.clothconfig2.impl.ConfigEntryBuilderImpl;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface ConfigBuilder {
    public static ConfigBuilder create() {
        return new ConfigBuilderImpl();
    }

    @Deprecated
    public static ConfigBuilder create(Screen parent, String title) {
        return ConfigBuilder.create().setParentScreen(parent).setTitle(title);
    }

    public ConfigBuilder setFallbackCategory(ConfigCategory var1);

    public Screen getParentScreen();

    public ConfigBuilder setParentScreen(Screen var1);

    public String getTitle();

    public ConfigBuilder setTitle(String var1);

    public boolean isEditable();

    public ConfigBuilder setEditable(boolean var1);

    public ConfigCategory getOrCreateCategory(String var1);

    public ConfigBuilder removeCategory(String var1);

    public ConfigBuilder removeCategoryIfExists(String var1);

    public boolean hasCategory(String var1);

    public ConfigBuilder setShouldTabsSmoothScroll(boolean var1);

    public boolean isTabsSmoothScrolling();

    public ConfigBuilder setShouldListSmoothScroll(boolean var1);

    public boolean isListSmoothScrolling();

    public ConfigBuilder setDoesConfirmSave(boolean var1);

    public boolean doesConfirmSave();

    public ConfigBuilder setDoesProcessErrors(boolean var1);

    public boolean doesProcessErrors();

    public ResourceLocation getDefaultBackgroundTexture();

    public ConfigBuilder setDefaultBackgroundTexture(ResourceLocation var1);

    public Runnable getSavingRunnable();

    public ConfigBuilder setSavingRunnable(Runnable var1);

    public Consumer<Screen> getAfterInitConsumer();

    public ConfigBuilder setAfterInitConsumer(Consumer<Screen> var1);

    default public ConfigBuilder alwaysShowTabs() {
        return this.setAlwaysShowTabs(true);
    }

    public boolean isAlwaysShowTabs();

    public ConfigBuilder setAlwaysShowTabs(boolean var1);

    public ConfigBuilder setTransparentBackground(boolean var1);

    default public ConfigBuilder transparentBackground() {
        return this.setTransparentBackground(true);
    }

    default public ConfigBuilder solidBackground() {
        return this.setTransparentBackground(false);
    }

    default public ConfigEntryBuilder getEntryBuilder() {
        return this.entryBuilder();
    }

    default public ConfigEntryBuilder entryBuilder() {
        return ConfigEntryBuilderImpl.create();
    }

    public Screen build();
}

