/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.impl;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.forge.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.forge.clothconfig2.api.ConfigCategory;
import me.shedaniel.forge.clothconfig2.api.Pair;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConfigCategoryImpl
implements ConfigCategory {
    private final Supplier<List<Pair<String, Object>>> listSupplier;
    private final Consumer<ResourceLocation> backgroundConsumer;
    private final Runnable destroyCategory;
    private final String categoryKey;

    ConfigCategoryImpl(String categoryKey, Consumer<ResourceLocation> backgroundConsumer, Supplier<List<Pair<String, Object>>> listSupplier, Runnable destroyCategory) {
        this.listSupplier = listSupplier;
        this.backgroundConsumer = backgroundConsumer;
        this.categoryKey = categoryKey;
        this.destroyCategory = destroyCategory;
    }

    @Override
    public String getCategoryKey() {
        return this.categoryKey;
    }

    @Override
    public List<Object> getEntries() {
        return this.listSupplier.get().stream().map(Pair::getRight).collect(Collectors.toList());
    }

    @Override
    public ConfigCategory addEntry(AbstractConfigListEntry entry) {
        this.listSupplier.get().add(new Pair<String, AbstractConfigListEntry>(entry.getFieldName(), entry));
        return this;
    }

    @Override
    public ConfigCategory setCategoryBackground(ResourceLocation identifier) {
        this.backgroundConsumer.accept(identifier);
        return this;
    }

    @Override
    public void removeCategory() {
        this.destroyCategory.run();
    }
}

