/*
 * Decompiled with CFR 0.152.
 */
package ca.cjloewen.corntopia;

import ca.cjloewen.corntopia.mixin.SignTypeMixin;
import com.mojang.datafixers.DSL;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1208;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1822;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2440;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2508;
import net.minecraft.class_2510;
import net.minecraft.class_2517;
import net.minecraft.class_2533;
import net.minecraft.class_2551;
import net.minecraft.class_2571;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BuildingBlocks {
    private static final Logger LOGGER = LogManager.getLogger((String)"Corntopia");
    public static final Map<String, class_2248> BLOCKS = new HashMap<String, class_2248>();
    public static final Map<String, class_2248> STAIRS_BLOCKS = new HashMap<String, class_2248>();
    public static final Map<String, class_2248> SIGN_BLOCKS = new HashMap<String, class_2248>();
    public static final Map<String, class_2248> WALL_SIGN_BLOCKS = new HashMap<String, class_2248>();
    public static final Map<String, class_2248> PRESSURE_PLATE_BLOCKS = new HashMap<String, class_2248>();
    public static final Map<String, class_2248> TRAPDOOR_BLOCKS = new HashMap<String, class_2248>();
    public static final Map<String, class_2248> BUTTON_BLOCKS = new HashMap<String, class_2248>();
    public static final Map<String, class_2248> SLAB_BLOCKS = new HashMap<String, class_2248>();
    public static final Map<String, class_1792> ITEMS = new HashMap<String, class_1792>();
    public static final Map<String, class_1792> STAIRS_ITEMS = new HashMap<String, class_1792>();
    public static final Map<String, class_1792> SIGN_ITEMS = new HashMap<String, class_1792>();
    public static final Map<String, class_1792> PRESSURE_PLATE_ITEMS = new HashMap<String, class_1792>();
    public static final Map<String, class_1792> TRAPDOOR_ITEMS = new HashMap<String, class_1792>();
    public static final Map<String, class_1792> BUTTON_ITEMS = new HashMap<String, class_1792>();
    public static final Map<String, class_1792> SLAB_ITEMS = new HashMap<String, class_1792>();
    public static final Map<String, class_2591<class_2625>> SIGNS = new HashMap<String, class_2591<class_2625>>();

    public static void register(String name, long exclude, class_3614 material, class_3620 color, class_2498 soundGroup) {
        class_2248 planks = null;
        if (!ExcludeMask.PLANKS.contains(exclude)) {
            planks = BuildingBlocks.createPlanksBlock(material, color, soundGroup);
            BLOCKS.put(name, (class_2248)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new class_2960("corntopia", name + "_planks"), (Object)BuildingBlocks.registerFlammable(planks, material)));
            ITEMS.put(name, (class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("corntopia", name + "_planks"), (Object)BuildingBlocks.createBuildingBlockItem(planks)));
        }
        if (!ExcludeMask.SLAB.contains(exclude)) {
            class_2482 slab = BuildingBlocks.createSlab(material, color, soundGroup);
            SLAB_BLOCKS.put(name, (class_2248)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new class_2960("corntopia", name + "_slab"), (Object)BuildingBlocks.registerFlammable((class_2248)slab, material)));
            SLAB_ITEMS.put(name, (class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("corntopia", name + "_slab"), (Object)BuildingBlocks.createBuildingBlockItem((class_2248)slab)));
        }
        if (!ExcludeMask.STAIRS.contains(exclude) && planks != null) {
            class_2510 stairs = BuildingBlocks.createStairsBlock(planks);
            STAIRS_BLOCKS.put(name, (class_2248)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new class_2960("corntopia", name + "_stairs"), (Object)BuildingBlocks.registerFlammable((class_2248)stairs, material)));
            STAIRS_ITEMS.put(name, (class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("corntopia", name + "_stairs"), (Object)BuildingBlocks.createBuildingBlockItem((class_2248)stairs)));
        } else if (planks == null) {
            LOGGER.warn("Stairs was not made for the %s building block type (missing Planks).", (Object)name);
        }
        if (!ExcludeMask.PRESSURE_PLATE.contains(exclude) && planks != null) {
            class_2440 pressurePlate = BuildingBlocks.createPressurePlate(planks);
            PRESSURE_PLATE_BLOCKS.put(name, (class_2248)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new class_2960("corntopia", name + "_pressure_plate"), (Object)pressurePlate));
            PRESSURE_PLATE_ITEMS.put(name, (class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("corntopia", name + "_pressure_plate"), (Object)BuildingBlocks.createRedstoneBlockItem((class_2248)pressurePlate)));
        } else if (planks == null) {
            LOGGER.warn("A pressure plate was not made for the %s building block type (missing Planks).", (Object)name);
        }
        if (!ExcludeMask.SIGN.contains(exclude)) {
            CustomSignType signType = new CustomSignType(name);
            class_2508 sign = BuildingBlocks.createSignBlock(signType, material, soundGroup);
            class_2551 wallSign = BuildingBlocks.createWallSignBlock(signType, sign, material, soundGroup);
            class_2591 signEntityType = class_2591.class_2592.method_20528(class_2625::new, (class_2248[])new class_2248[]{sign, wallSign}).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)"sign"));
            SignTypeMixin.invokeRegister(signType);
            SIGNS.put(name, (class_2591<class_2625>)((class_2591)class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)new class_2960("corntopia", name + "sign"), (Object)signEntityType)));
            SIGN_BLOCKS.put(name, (class_2248)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new class_2960("corntopia", name + "_sign"), (Object)sign));
            WALL_SIGN_BLOCKS.put(name, (class_2248)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new class_2960("corntopia", name + "_wall_sign"), (Object)wallSign));
            SIGN_ITEMS.put(name, (class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("corntopia", name + "_sign"), (Object)BuildingBlocks.createSignBlockItem(sign, wallSign)));
        }
        if (!ExcludeMask.TRAPDOOR.contains(exclude)) {
            class_2533 trapdoor = BuildingBlocks.createTrapdoor(material, color, soundGroup);
            TRAPDOOR_BLOCKS.put(name, (class_2248)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new class_2960("corntopia", name + "_trapdoor"), (Object)BuildingBlocks.registerRenderLayer((class_2248)trapdoor, class_1921.method_23581())));
            TRAPDOOR_ITEMS.put(name, (class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("corntopia", name + "_trapdoor"), (Object)BuildingBlocks.createRedstoneBlockItem((class_2248)trapdoor)));
        }
        if (!ExcludeMask.BUTTON.contains(exclude)) {
            class_2269 button = BuildingBlocks.createButton(material, soundGroup);
            BUTTON_BLOCKS.put(name, (class_2248)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new class_2960("corntopia", name + "_button"), (Object)button));
            BUTTON_ITEMS.put(name, (class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("corntopia", name + "_button"), (Object)BuildingBlocks.createRedstoneBlockItem((class_2248)button)));
        }
    }

    public static void register(String name, long exclude) {
        BuildingBlocks.register(name, exclude, class_3614.field_15932, class_3620.field_15996, class_2498.field_11547);
    }

    public static void register(String name) {
        BuildingBlocks.register(name, 0L);
    }

    private static class_2248 createPlanksBlock(class_3614 material, class_3620 color, class_2498 soundGroup) {
        return new class_2248((class_4970.class_2251)FabricBlockSettings.of((class_3614)material, (class_3620)color).strength(2.0f, 3.0f).sounds(soundGroup));
    }

    private static class_2510 createStairsBlock(class_2248 planks) {
        return new CustomStairsBlock(planks.method_9564(), (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)planks));
    }

    private static class_2440 createPressurePlate(class_2248 planks) {
        return new CustomPressurePlateBlock(class_2440.class_2441.field_11361, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)planks).noCollision().strength(0.5f));
    }

    private static class_2508 createSignBlock(class_4719 type, class_3614 material, class_2498 soundGroup) {
        return new class_2508((class_4970.class_2251)FabricBlockSettings.of((class_3614)material).noCollision().strength(1.0f).sounds(soundGroup), type);
    }

    private static class_2551 createWallSignBlock(class_4719 type, class_2508 sign, class_3614 material, class_2498 soundGroup) {
        return new class_2551((class_4970.class_2251)FabricBlockSettings.of((class_3614)material).noCollision().strength(1.0f).sounds(soundGroup).dropsLike((class_2248)sign), type);
    }

    private static class_2533 createTrapdoor(class_3614 material, class_3620 color, class_2498 soundGroup) {
        return new CustomTrapdoorBlock((class_4970.class_2251)FabricBlockSettings.of((class_3614)material, (class_3620)color).strength(3.0f).sounds(soundGroup).nonOpaque().allowsSpawning(BuildingBlocks::never));
    }

    private static class_2269 createButton(class_3614 material, class_2498 soundGroup) {
        if (material.equals(class_3614.field_15914)) {
            return new CustomStoneButtonBlock((class_4970.class_2251)FabricBlockSettings.of((class_3614)class_3614.field_15924).noCollision().strength(0.5f).sounds(soundGroup));
        }
        return new CustomWoodenButtonBlock((class_4970.class_2251)FabricBlockSettings.of((class_3614)class_3614.field_15924).noCollision().strength(0.5f).sounds(soundGroup));
    }

    private static class_2482 createSlab(class_3614 material, class_3620 color, class_2498 soundGroup) {
        return new class_2482((class_4970.class_2251)FabricBlockSettings.of((class_3614)material, (class_3620)color).strength(2.0f, 3.0f).sounds(soundGroup));
    }

    private static class_1792 createBuildingBlockItem(class_2248 block) {
        return new class_1747(block, new class_1792.class_1793().method_7892(class_1761.field_7931));
    }

    private static class_1792 createRedstoneBlockItem(class_2248 block) {
        return new class_1747(block, new class_1792.class_1793().method_7892(class_1761.field_7914));
    }

    private static class_1792 createSignBlockItem(class_2508 sign, class_2551 wallSign) {
        return new class_1822(new class_1792.class_1793().method_7889(16).method_7892(class_1761.field_7928), (class_2248)sign, (class_2248)wallSign);
    }

    private static Boolean never(class_2680 state, class_1922 world, class_2338 pos, class_1299<?> type) {
        return false;
    }

    private static class_2248 registerFlammable(class_2248 block, class_3614 material) {
        if (class_3614.field_15932.equals(material)) {
            FlammableBlockRegistry.getDefaultInstance().add(block, (Object)new FlammableBlockRegistry.Entry(5, 20));
        }
        return block;
    }

    private static class_2248 registerRenderLayer(class_2248 block, class_1921 renderLayer) {
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT)) {
            BlockRenderLayerMap.INSTANCE.putBlock(block, renderLayer);
        }
        return block;
    }

    private static class CustomWoodenButtonBlock
    extends class_2571 {
        protected CustomWoodenButtonBlock(class_4970.class_2251 settings) {
            super(settings);
        }
    }

    private static class CustomStoneButtonBlock
    extends class_2517 {
        protected CustomStoneButtonBlock(class_4970.class_2251 settings) {
            super(settings);
        }
    }

    private static class CustomTrapdoorBlock
    extends class_2533 {
        protected CustomTrapdoorBlock(class_4970.class_2251 settings) {
            super(settings);
        }
    }

    private static class CustomPressurePlateBlock
    extends class_2440 {
        protected CustomPressurePlateBlock(class_2440.class_2441 type, class_4970.class_2251 settings) {
            super(type, settings);
        }
    }

    private static class CustomSignType
    extends class_4719 {
        public CustomSignType(String name) {
            super(name);
        }
    }

    private static class CustomStairsBlock
    extends class_2510 {
        public CustomStairsBlock(class_2680 baseBlockState, class_4970.class_2251 settings) {
            super(baseBlockState, settings);
        }
    }

    public static enum ExcludeMask {
        PLANKS(1L),
        SLAB(2L),
        STAIRS(4L),
        PRESSURE_PLATE(8L),
        SIGN(16L),
        TRAPDOOR(32L),
        BUTTON(64L);

        public final long mask;

        private ExcludeMask(long mask) {
            this.mask = mask;
        }

        public boolean contains(long mask) {
            return (mask & this.mask) != 0L;
        }
    }
}

