/*
 * Decompiled with CFR 0.152.
 */
package ca.cjloewen.corntopia.structure;

import ca.cjloewen.corntopia.BuildingBlocks;
import ca.cjloewen.corntopia.loot.LootTables;
import ca.cjloewen.corntopia.structure.StructurePieceType;
import ca.cjloewen.corntopia.structure.processor.BrokenStructureProcessor;
import ca.cjloewen.corntopia.structure.processor.OffsetYStructureProcessor;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2380;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3470;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3793;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;

public class BarnGenerator {
    public static void addPieces(class_3485 manager, class_2338 pos, class_2470 rotation, List<class_3443> pieces, Random random) {
        boolean[] toggles = new boolean[10];
        class_2680 pileState = (class_2680)class_2246.field_10359.method_9564().method_11657((class_2769)class_2380.field_11459, (Comparable)class_2350.class_2351.field_11052);
        for (int i = 0; i < toggles.length; ++i) {
            toggles[i] = random.nextBoolean();
        }
        BarnType barnType = toggles[4] || toggles[7] ? BarnType.USED : (toggles[0] || toggles[1] || toggles[2] || toggles[3] || toggles[4] || toggles[7] ? BarnType.ABANDONED : BarnType.BROKEN);
        pieces.add((class_3443)new BarnPiece(manager, "base", pos, rotation, false, BuildingBlocks.BLOCKS.get("barn").method_9564(), barnType));
        if (toggles[0]) {
            pieces.add((class_3443)new BarnPiece(manager, "pile_front", pos.method_10081((class_2382)new class_2338(8, 1, 2).method_10070(rotation)), rotation, false, pileState, barnType));
        }
        if (toggles[1]) {
            pieces.add((class_3443)new BarnPiece(manager, "pile_front", pos.method_10081((class_2382)new class_2338(3, 1, 2).method_10070(rotation)), rotation, true, pileState, barnType));
        }
        if (toggles[2]) {
            pieces.add((class_3443)new BarnPiece(manager, "pile_back", pos.method_10081((class_2382)new class_2338(7, 1, 10).method_10070(rotation)), rotation, false, pileState, barnType));
        }
        if (toggles[3]) {
            pieces.add((class_3443)new BarnPiece(manager, "pile_back", pos.method_10081((class_2382)new class_2338(4, 1, 10).method_10070(rotation)), rotation, true, pileState, barnType));
        }
        if (toggles[4]) {
            pieces.add((class_3443)new BarnPiece(manager, "platform", pos.method_10081((class_2382)new class_2338(6, 0, 2).method_10070(rotation)), rotation, false, BuildingBlocks.BLOCKS.get("barn").method_9564(), barnType));
            if (toggles[5]) {
                pieces.add((class_3443)new BarnPiece(manager, "lamp_tall", pos.method_10081((class_2382)new class_2338(8, 3, 8).method_10070(rotation)), rotation, false, class_2246.field_10124.method_9564(), barnType));
            } else if (toggles[6]) {
                pieces.add((class_3443)new BarnPiece(manager, "lamp_short", pos.method_10081((class_2382)new class_2338(8, 3, 8).method_10070(rotation)), rotation, false, class_2246.field_10124.method_9564(), barnType));
            }
        }
        if (toggles[7]) {
            pieces.add((class_3443)new BarnPiece(manager, "platform", pos.method_10081((class_2382)new class_2338(5, 0, 2).method_10070(rotation)), rotation, true, BuildingBlocks.BLOCKS.get("barn").method_9564(), barnType));
            if (toggles[8]) {
                pieces.add((class_3443)new BarnPiece(manager, "lamp_tall", pos.method_10081((class_2382)new class_2338(3, 3, 8).method_10070(rotation)), rotation, true, class_2246.field_10124.method_9564(), barnType));
            } else if (toggles[9]) {
                pieces.add((class_3443)new BarnPiece(manager, "lamp_short", pos.method_10081((class_2382)new class_2338(3, 3, 8).method_10070(rotation)), rotation, true, class_2246.field_10124.method_9564(), barnType));
            }
        }
        if (!barnType.equals((Object)BarnType.BROKEN)) {
            class_2470 houseRot = BarnGenerator.getHouseRotation(rotation, random);
            pieces.add(new CenterPiece(manager, pos.method_10081((class_2382)new class_2338(4, 0, 0).method_10070(rotation)), rotation, houseRot));
        }
    }

    private static class_2470 getHouseRotation(class_2470 barnRotation, Random random) {
        EnumSet<class_2470> houseRots = EnumSet.allOf(class_2470.class);
        houseRots.remove(barnRotation);
        int houseI = random.nextInt(houseRots.size());
        int i = 0;
        for (class_2470 houseRot : houseRots) {
            if (i == houseI) {
                return houseRot;
            }
            ++i;
        }
        throw new IllegalStateException("The laws of mathematics failed!");
    }

    public static class CenterPiece
    extends class_3443 {
        public static final int CENTER_DIAMETER = 7;
        public static final int ENTRANCE_WIDTH = 4;
        public static final int LENGTH = 16;
        public static final int WIDTH = 4;
        public static final int MARGIN = 4;
        private final class_2338 pos;
        private final class_2350 barnDir;
        private final class_2350 houseDir;

        public CenterPiece(class_3485 structureManager, class_2338 pos, class_2470 rotation, class_2470 houseRotation) {
            super(StructurePieceType.BARN_PATH, 0);
            this.pos = pos;
            this.barnDir = rotation.method_10503(class_2350.field_11043);
            this.houseDir = houseRotation.method_10503(class_2350.field_11043);
            this.calculateBoundingBox();
        }

        public CenterPiece(class_3485 structureManager, class_2487 compoundTag) {
            super(StructurePieceType.BARN_PATH, compoundTag);
            this.pos = new class_2338(compoundTag.method_10550("TPX"), compoundTag.method_10550("TPY"), compoundTag.method_10550("TPZ"));
            this.barnDir = class_2350.method_10143((int)compoundTag.method_10550("Direction"));
            this.houseDir = class_2350.method_10143((int)compoundTag.method_10550("HouseDirection"));
            this.calculateBoundingBox();
        }

        private void calculateBoundingBox() {
            int diameter = 32;
            int acrossOffset = 2 - diameter / 2;
            class_3341 blockBox = new class_3341(0, 0, 0, diameter, 1, diameter);
            blockBox.method_14661(this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260());
            blockBox.method_14661(this.barnDir.method_10170().method_10148() * acrossOffset, 0, this.barnDir.method_10170().method_10165() * acrossOffset);
            this.field_15315 = blockBox;
        }

        protected void method_14943(class_2487 tag) {
            tag.method_10569("TPX", this.pos.method_10263());
            tag.method_10569("TPY", this.pos.method_10264());
            tag.method_10569("TPZ", this.pos.method_10260());
            tag.method_10569("Direction", this.barnDir.method_10146());
            tag.method_10569("HouseDirection", this.houseDir.method_10146());
        }

        public boolean method_14931(class_5281 structureWorldAccess, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 boundingBox, class_1923 chunkPos, class_2338 blockPos) {
            class_2350 across = this.barnDir.method_10170();
            int acrossI = 2;
            if (across.method_10171().equals((Object)class_2350.class_2352.field_11060)) {
                --acrossI;
            }
            class_2338 middle = this.pos.method_10079(this.barnDir, 16).method_10079(across, acrossI);
            this.generateCenter(structureWorldAccess, random, middle);
            this.generatePath(structureWorldAccess, random, middle, this.barnDir.method_10153());
            this.generatePath(structureWorldAccess, random, middle, this.houseDir.method_10153());
            return true;
        }

        private void generateBlock(class_5281 structureWorldAccess, class_2338 pos) {
            int y = structureWorldAccess.method_8624(class_2902.class_2903.field_13194, pos.method_10263(), pos.method_10260()) - 1;
            structureWorldAccess.method_8652(new class_2338(pos.method_10263(), y, pos.method_10260()), class_2246.field_10194.method_9564(), 3);
        }

        private void generateCenter(class_5281 structureWorldAccess, Random random, class_2338 middle) {
            int centerRadius = Math.floorDiv(7, 2);
            for (float x = (float)(-centerRadius - 4); x < (float)(centerRadius + 4); x += 1.0f) {
                for (float z = (float)(-centerRadius - 4); z < (float)(centerRadius + 4); z += 1.0f) {
                    float centerOffsetX = x + 0.5f;
                    float centerOffsetZ = z + 0.5f;
                    float magnitudeXZ = Math.abs(centerOffsetX) + Math.abs(centerOffsetZ);
                    float chance = 0.0f;
                    chance = 1.0f - Math.min((magnitudeXZ - (float)centerRadius) / 4.0f, 1.0f);
                    if (magnitudeXZ <= (float)centerRadius) {
                        chance = 1.0f;
                    }
                    if (!(random.nextFloat() <= chance)) continue;
                    this.generateBlock(structureWorldAccess, middle.method_10080((double)x, 0.0, (double)z));
                }
            }
        }

        private void generatePath(class_5281 structureWorldAccess, Random random, class_2338 middle, class_2350 way) {
            class_2350 wayAcross = way.method_10170();
            int halfWidth = 2;
            int halfRadius = halfWidth + 4;
            if (wayAcross.method_10171().equals((Object)class_2350.class_2352.field_11056)) {
                wayAcross = wayAcross.method_10153();
            }
            for (int across = -halfRadius + 1; across <= halfRadius; ++across) {
                float chance = 1.0f - (float)(Math.abs(across > 0 ? across : across - 1) - halfWidth) / 4.0f;
                if (across > -halfWidth && across <= halfWidth) {
                    chance = 1.0f;
                }
                for (int toward = 1; toward <= 16; ++toward) {
                    if (!(random.nextFloat() <= chance)) continue;
                    this.generateBlock(structureWorldAccess, middle.method_10079(wayAcross, across).method_10079(way, toward));
                }
            }
        }
    }

    public static class BarnPiece
    extends class_3470 {
        private final String template;
        private final class_2470 rotation;
        private final boolean flip;
        private final class_2680 chestReplacement;
        private final BarnType barnType;

        public BarnPiece(class_3485 structureManager, String template, class_2338 pos, class_2470 rotation, boolean flip, class_2680 chestReplacement, BarnType barnType) {
            super(StructurePieceType.BARN, 0);
            this.template = template;
            this.field_15432 = pos;
            this.rotation = rotation;
            this.flip = flip;
            this.chestReplacement = chestReplacement;
            this.barnType = barnType;
            this.initializeStructureData(structureManager);
        }

        public BarnPiece(class_3485 structureManager, class_2487 compoundTag) {
            super(StructurePieceType.BARN, compoundTag);
            this.template = compoundTag.method_10558("Template");
            this.rotation = class_2470.valueOf((String)compoundTag.method_10558("Rot"));
            this.flip = compoundTag.method_10577("Flip");
            this.chestReplacement = class_2512.method_10681((class_2487)compoundTag.method_10562("ChestReplacement"));
            this.barnType = BarnType.valueOf(compoundTag.method_10558("BarnType"));
            this.initializeStructureData(structureManager);
        }

        private void initializeStructureData(class_3485 structureManager) {
            class_3499 structure = structureManager.method_15091(new class_2960("corntopia", "barn/" + this.template));
            class_3492 placementData = new class_3492().method_16184((class_3491)class_3793.field_16718).method_16184((class_3491)new OffsetYStructureProcessor(-1)).method_15123(this.rotation).method_15125(this.flip ? class_2415.field_11300 : class_2415.field_11302).method_15125(this.flip ? class_2415.field_11301 : class_2415.field_11302);
            if (this.barnType.equals((Object)BarnType.BROKEN)) {
                float probability = 0.2f;
                placementData.method_16184((class_3491)new BrokenStructureProcessor(structure.method_15160(), (List<BrokenStructureProcessor.Rule>)ImmutableList.of((Object)new BrokenStructureProcessor.Rule(BuildingBlocks.BLOCKS.get("barn"), probability, class_2246.field_10124.method_9564()), (Object)new BrokenStructureProcessor.Rule(class_2246.field_10431, probability, class_2246.field_10124.method_9564()), (Object)new BrokenStructureProcessor.Rule(BuildingBlocks.BLOCKS.get("barn_roof"), probability, class_2246.field_10124.method_9564()), (Object)new BrokenStructureProcessor.Rule(BuildingBlocks.SLAB_BLOCKS.get("barn_roof"), probability, class_2246.field_10124.method_9564()), (Object)new BrokenStructureProcessor.Rule(BuildingBlocks.STAIRS_BLOCKS.get("barn_roof"), probability, class_2246.field_10124.method_9564()), (Object)new BrokenStructureProcessor.Rule(class_2246.field_10194, 0.33f, class_2246.field_10219.method_9564()), (Object)new BrokenStructureProcessor.Rule(class_2246.field_10194, 0.66f, class_2246.field_10253.method_9564()))));
            }
            this.method_15027(structure, this.field_15432, placementData);
        }

        protected void method_14943(class_2487 tag) {
            super.method_14943(tag);
            tag.method_10582("Template", this.template);
            tag.method_10582("Rot", this.rotation.name());
            tag.method_10556("Flip", this.flip);
            tag.method_10566("ChestReplacement", (class_2520)class_2512.method_10686((class_2680)this.chestReplacement));
            tag.method_10582("BarnType", this.barnType.name());
        }

        protected void method_15026(String metadata, class_2338 pos, class_5425 serverWorldAccess, Random random, class_3341 boundingBox) {
            class_2338 chestPos;
            switch (metadata) {
                case "chest": {
                    chestPos = pos.method_10087(2);
                    break;
                }
                case "chest2": {
                    chestPos = pos.method_10087(3);
                    break;
                }
                default: {
                    chestPos = null;
                }
            }
            if (chestPos != null && boundingBox.method_14662((class_2382)chestPos)) {
                if (random.nextFloat() < 0.9f) {
                    serverWorldAccess.method_8652(chestPos, this.chestReplacement, 3);
                } else if (this.barnType.equals((Object)BarnType.ABANDONED)) {
                    class_2621.method_11287((class_1922)serverWorldAccess, (Random)random, (class_2338)chestPos, (class_2960)LootTables.BARN_ABANDONED);
                } else if (this.barnType.equals((Object)BarnType.USED)) {
                    class_2621.method_11287((class_1922)serverWorldAccess, (Random)random, (class_2338)chestPos, (class_2960)LootTables.BARN_USED);
                }
            }
        }
    }

    static enum BarnType {
        USED,
        ABANDONED,
        BROKEN;

    }
}

