/*
 * Decompiled with CFR 0.152.
 */
package ca.cjloewen.corntopia.structure.processor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class BrokenStructureProcessor
extends class_3491 {
    public static final Codec<BrokenStructureProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("size").forGetter(brokenStructureProcessor -> brokenStructureProcessor.size), (App)Rule.CODEC.listOf().fieldOf("rules").forGetter(brokenStructureProcessor -> brokenStructureProcessor.rules)).apply((Applicative)instance, BrokenStructureProcessor::new));
    public static final class_3828<BrokenStructureProcessor> BROKEN = () -> CODEC;
    private final class_2338 size;
    private final ImmutableList<Rule> rules;

    public BrokenStructureProcessor(class_2338 size, List<Rule> rules) {
        this.size = size;
        this.rules = ImmutableList.copyOf(rules);
    }

    @Nullable
    public class_3499.class_3501 method_15110(class_4538 worldView, class_2338 pieceCorner, class_2338 structureCenter, class_3499.class_3501 offsetBlockInfo, class_3499.class_3501 blockInfo, class_3492 structurePlacementData) {
        Rule rule;
        Random random = new Random(class_3532.method_15389((class_2382)blockInfo.field_15597));
        UnmodifiableIterator ruleIter = this.rules.iterator();
        do {
            if (ruleIter.hasNext()) continue;
            return blockInfo;
        } while (!blockInfo.field_15596.method_27852((rule = (Rule)ruleIter.next()).targetBlock) || !this.test((double)offsetBlockInfo.field_15597.method_10263() / (double)this.size.method_10263(), (double)offsetBlockInfo.field_15597.method_10264() / (double)this.size.method_10264(), (double)offsetBlockInfo.field_15597.method_10260() / (double)this.size.method_10260(), rule.probabilityOffset, random));
        return new class_3499.class_3501(blockInfo.field_15597, rule.getOutput(), null);
    }

    private boolean test(double xPercentage, double yPercentage, double zPercentage, float probabilityOffset, Random random) {
        return random.nextDouble() < Math.min(Math.min(Math.sin(xPercentage * Math.PI), Math.sin(zPercentage * Math.PI)), yPercentage) + (double)probabilityOffset;
    }

    protected class_3828<?> method_16772() {
        return BROKEN;
    }

    public static class Rule {
        public static final Codec<Rule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2378.field_11146.fieldOf("target_block").forGetter(rule -> rule.targetBlock), (App)Codec.FLOAT.fieldOf("probability_offset").forGetter(rule -> Float.valueOf(rule.probabilityOffset)), (App)class_2680.field_24734.fieldOf("output_state").forGetter(rule -> rule.outputState)).apply((Applicative)instance, Rule::new));
        private final class_2248 targetBlock;
        private final float probabilityOffset;
        private final class_2680 outputState;

        public Rule(class_2248 targetBlock, float probability, class_2680 outputState) {
            this.targetBlock = targetBlock;
            this.probabilityOffset = probability;
            this.outputState = outputState;
        }

        public class_2248 getTarget() {
            return this.targetBlock;
        }

        public float getOffset() {
            return this.probabilityOffset;
        }

        public class_2680 getOutput() {
            return this.outputState;
        }
    }
}

