/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.dawn.api.creator;

import com.hugman.dawn.api.creator.Creator;
import com.hugman.dawn.api.util.BlockGetter;
import com.hugman.dawn.api.util.ModData;
import com.hugman.dawn.api.util.StringUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;

public class BlockCreator
extends Creator<class_2248> {
    protected final Render render;
    protected final class_1761 itemGroup;
    protected final int flammabilityBurn;
    protected final int flammabilitySpread;
    protected final boolean noItem;
    protected final int cookTime;
    protected final float compostingChance;

    private BlockCreator(ModData modData, String name, class_2248 block, Render render, class_1761 itemGroup, int flammabilityBurn, int flammabilitySpread, boolean noItem, int cookTime, float compostingChance) {
        super(modData, name, block);
        this.render = render;
        this.itemGroup = itemGroup;
        this.flammabilityBurn = flammabilityBurn;
        this.flammabilitySpread = flammabilitySpread;
        this.noItem = noItem;
        this.cookTime = cookTime;
        this.compostingChance = compostingChance;
    }

    @Override
    public void register() {
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)this.modData.id(this.name), (Object)((class_2248)this.value));
        FlammableBlockRegistry.getDefaultInstance().add((class_2248)this.value, this.flammabilityBurn, this.flammabilitySpread);
        if (!this.noItem) {
            class_1747 blockItem = (class_1747)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)class_2378.field_11146.method_10221((Object)((class_2248)this.value)), (Object)new class_1747((class_2248)this.value, new class_1792.class_1793().method_7892(this.itemGroup)));
            blockItem.method_7713(class_1792.field_8003, (class_1792)blockItem);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientRegister() {
        class_1921 renderF;
        if (this.render != null) {
            switch (this.render) {
                default: {
                    renderF = class_1921.method_23577();
                    break;
                }
                case CUTOUT: {
                    renderF = class_1921.method_23581();
                    break;
                }
                case CUTOUT_MIPPED: {
                    renderF = class_1921.method_23579();
                    break;
                }
                case TRANSLUCENT: {
                    renderF = class_1921.method_23583();
                    break;
                }
            }
        } else {
            renderF = class_1921.method_23577();
        }
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this.value, renderF);
    }

    @Override
    public void serverRegister(boolean isDedicated) {
        if (!this.noItem) {
            if (this.cookTime != 0) {
                FuelRegistry.INSTANCE.add((class_1935)this.value, (Object)this.cookTime);
            }
            if (this.compostingChance != 0.0f) {
                CompostingChanceRegistry.INSTANCE.add((class_1935)this.value, (Object)Float.valueOf(this.compostingChance));
            }
        }
    }

    public static class Builder
    implements Creator.Builder<class_2248> {
        private final String name;
        private final class_2248 block;
        protected Render render;
        protected class_1761 itemGroup;
        protected int flammabilityBurn;
        protected int flammabilitySpread;
        protected boolean noItem;
        protected int cookTime;
        protected float compostingChance;

        public Builder(String name, class_2248 block) {
            this.name = name;
            this.block = block;
        }

        public Builder(String prefix, BlockGetter getter, class_4970.class_2251 settings) {
            this(StringUtil.getShapedName(prefix, getter), getter.getBlock(settings));
            this.copy(getter);
        }

        public Builder render(Render render) {
            this.render = render;
            return this;
        }

        public Builder itemGroup(class_1761 itemGroup) {
            this.itemGroup = itemGroup;
            return this;
        }

        public Builder flammability(int flammability) {
            this.flammabilityBurn = flammability;
            this.flammabilitySpread = flammability;
            return this;
        }

        public Builder flammability(int burn, int spread) {
            this.flammabilityBurn = burn;
            this.flammabilitySpread = spread;
            return this;
        }

        public Builder cookTime(int cookTime) {
            this.cookTime = cookTime;
            return this;
        }

        public Builder compostingChance(float compostingChance) {
            this.compostingChance = compostingChance;
            return this;
        }

        public Builder noItem() {
            this.noItem = true;
            return this;
        }

        public Builder copy(BlockGetter getter) {
            this.itemGroup(getter.getItemGroup());
            this.render(getter.getRender());
            return this;
        }

        public BlockCreator build(ModData modData) {
            return new BlockCreator(modData, this.name, this.block, this.render, this.itemGroup, this.flammabilityBurn, this.flammabilitySpread, this.noItem, this.cookTime, this.compostingChance);
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Render {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRANSLUCENT;

    }
}

