/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.dawn.api.util;

import com.hugman.dawn.api.creator.BlockCreator;
import com.hugman.dawn.api.object.block.DoorBlock;
import com.hugman.dawn.api.object.block.MushroomPlantBlock;
import com.hugman.dawn.api.object.block.PlantPileBlock;
import com.hugman.dawn.api.object.block.PressurePlateBlock;
import com.hugman.dawn.api.object.block.StairsBlock;
import com.hugman.dawn.api.object.block.StoneButtonBlock;
import com.hugman.dawn.api.object.block.TrapdoorBlock;
import com.hugman.dawn.api.object.block.WoodButtonBlock;
import com.hugman.dawn.api.util.BlockGetter;
import com.hugman.dawn.api.util.BlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2381;
import net.minecraft.class_2397;
import net.minecraft.class_2440;
import net.minecraft.class_2482;
import net.minecraft.class_2544;
import net.minecraft.class_4970;

public enum DefaultBlockGetter implements BlockGetter
{
    CUBE("", class_1761.field_7931),
    PLANKS("planks", class_1761.field_7931),
    STAIRS("stairs", class_1761.field_7931),
    SLAB("slab", class_1761.field_7931),
    WALL("wall", class_1761.field_7928),
    STONE_BUTTON("button", class_1761.field_7914),
    WOOD_BUTTON("button", class_1761.field_7914),
    STONE_PRESSURE_PLATE("pressure_plate", class_1761.field_7914),
    WOOD_PRESSURE_PLATE("pressure_plate", class_1761.field_7914),
    TRAPDOOR("trapdoor", class_1761.field_7914, BlockCreator.Render.CUTOUT),
    DOOR("door", class_1761.field_7914, BlockCreator.Render.CUTOUT),
    FENCE("fence", class_1761.field_7928),
    FENCE_GATE("fence_gate", class_1761.field_7914),
    LEAVES("leaves", class_1761.field_7928, BlockCreator.Render.CUTOUT_MIPPED),
    LEAF_PILE("leaf_pile", class_1761.field_7928, BlockCreator.Render.CUTOUT_MIPPED),
    PLANT_PILE("pile", class_1761.field_7928, BlockCreator.Render.CUTOUT_MIPPED),
    MUSHROOM_BLOCK("mushroom_block", class_1761.field_7928),
    MUSHROOM("mushroom", class_1761.field_7928);

    private final String suffix;
    private final class_1761 itemGroup;
    private final BlockCreator.Render render;

    private DefaultBlockGetter(String suffix, class_1761 itemGroup, BlockCreator.Render render) {
        this.suffix = suffix;
        this.itemGroup = itemGroup;
        this.render = render;
    }

    private DefaultBlockGetter(String suffix, class_1761 itemGroup) {
        this(suffix, itemGroup, null);
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public class_1761 getItemGroup() {
        return this.itemGroup;
    }

    @Override
    public BlockCreator.Render getRender() {
        return this.render;
    }

    @Override
    public class_2248 getBlock(class_4970.class_2251 settings) {
        FabricBlockSettings newSettings = FabricBlockSettings.copyOf((class_4970.class_2251)settings);
        switch (this) {
            default: {
                return new class_2248((class_4970.class_2251)newSettings);
            }
            case SLAB: {
                return new class_2482((class_4970.class_2251)newSettings);
            }
            case STAIRS: {
                return new StairsBlock((class_4970.class_2251)newSettings);
            }
            case WALL: {
                return new class_2544((class_4970.class_2251)newSettings);
            }
            case STONE_PRESSURE_PLATE: {
                return new PressurePlateBlock(class_2440.class_2441.field_11362, (class_4970.class_2251)newSettings.requiresTool().noCollision().strength(0.5f));
            }
            case WOOD_PRESSURE_PLATE: {
                return new PressurePlateBlock(class_2440.class_2441.field_11361, (class_4970.class_2251)newSettings.noCollision().strength(0.5f));
            }
            case STONE_BUTTON: {
                return new StoneButtonBlock((class_4970.class_2251)newSettings.noCollision().strength(0.5f));
            }
            case WOOD_BUTTON: {
                return new WoodButtonBlock((class_4970.class_2251)newSettings.noCollision().strength(0.5f));
            }
            case TRAPDOOR: {
                return new TrapdoorBlock((class_4970.class_2251)newSettings.strength(3.0f).nonOpaque().allowsSpawning(BlockSettings::never));
            }
            case DOOR: {
                return new DoorBlock((class_4970.class_2251)newSettings.strength(3.0f).nonOpaque());
            }
            case FENCE: {
                return new class_2354((class_4970.class_2251)newSettings);
            }
            case FENCE_GATE: {
                return new class_2349((class_4970.class_2251)newSettings);
            }
            case LEAVES: {
                return new class_2397((class_4970.class_2251)newSettings);
            }
            case LEAF_PILE: 
            case PLANT_PILE: {
                return new PlantPileBlock((class_4970.class_2251)newSettings);
            }
            case MUSHROOM: {
                return new MushroomPlantBlock((class_4970.class_2251)newSettings);
            }
            case MUSHROOM_BLOCK: 
        }
        return new class_2381((class_4970.class_2251)newSettings);
    }
}

