/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffectType;
import org.orecruncher.environs.effects.JetEffect;
import org.orecruncher.environs.effects.emitters.FountainJet;
import org.orecruncher.lib.WorldUtils;

@OnlyIn(value=Dist.CLIENT)
public class FountainJetEffect
extends JetEffect {
    public FountainJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.FOUNTAIN;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return WorldUtils.isAirBlock(provider, pos.func_177984_a()) && super.canTrigger(provider, state, pos, random);
    }

    @Override
    public void doEffect(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        FountainJet effect = new FountainJet(5, provider, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5, state);
        this.addEffect(effect);
    }
}

