/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.emitters;

import java.util.Arrays;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.WaterfallSplashEffect;
import org.orecruncher.environs.effects.emitters.Jet;
import org.orecruncher.environs.effects.particles.Collections;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.environs.library.Constants;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.api.acoustics.Library;
import org.orecruncher.sndctrl.audio.AudioEngine;
import org.orecruncher.sndctrl.audio.LoopingSoundInstance;
import org.orecruncher.sndctrl.audio.SoundUtils;

@OnlyIn(value=Dist.CLIENT)
public class WaterSplashJet
extends Jet {
    private static final ResourceLocation[] waterfallAcoustics = new ResourceLocation[11];
    protected LoopingSoundInstance sound;
    protected int particleLimit;
    protected final double deltaY;

    public WaterSplashJet(int strength, IBlockReader world, BlockPos loc, double dY) {
        super(0, strength, world, (double)loc.func_177958_n() + 0.5, (double)loc.func_177956_o() + 0.5, (double)loc.func_177952_p() + 0.5, 4);
        this.deltaY = (double)loc.func_177956_o() + dY;
        this.setSpawnCount((int)((float)strength * 2.5f));
    }

    public void setSpawnCount(int limit) {
        this.particleLimit = MathStuff.clamp(limit, 5, 20);
    }

    public int getSpawnCount() {
        ParticleStatus state = GameUtils.getGameSettings().field_74362_aa;
        switch (state) {
            case MINIMAL: {
                return 0;
            }
            case ALL: {
                return this.particleLimit;
            }
        }
        return this.particleLimit / 2;
    }

    @Override
    public boolean shouldDie() {
        return this.particleAge % 10 == 0 && !WaterfallSplashEffect.isValidSpawnBlock(this.world, this.position);
    }

    @Override
    protected void soundUpdate() {
        if (!this.isAlive()) {
            return;
        }
        if (this.sound == null) {
            int idx = MathStuff.clamp(this.jetStrength, 0, waterfallAcoustics.length - 1);
            IAcoustic acoustic = Library.resolve(waterfallAcoustics[idx]);
            this.sound = new LoopingSoundInstance(acoustic.getFactory().createSoundAt(this.position), Constants.WATERFALL);
        }
        boolean inRange = SoundUtils.inRange(CommonState.getPlayerEyePosition(), this.sound, 4);
        boolean isActive = this.sound.getState().isActive();
        if (inRange && !isActive) {
            AudioEngine.play(this.sound);
        } else if (!inRange && isActive) {
            AudioEngine.stop(this.sound);
        }
    }

    @Override
    protected void cleanUp() {
        if (this.sound != null) {
            AudioEngine.stop(this.sound);
            this.sound = null;
        }
        super.cleanUp();
    }

    @Override
    protected void spawnJetParticle() {
        if (Collections.canFitWaterSpray()) {
            int splashCount = this.getSpawnCount();
            int j = 0;
            while ((float)j < (float)splashCount) {
                double zOffset;
                double xOffset = RANDOM.nextFloat() * 2.0f - 1.0f;
                if (!WorldUtils.isBlockSolid(this.world, new BlockPos(this.posX + xOffset, this.deltaY, this.posZ + (zOffset = (double)(RANDOM.nextFloat() * 2.0f - 1.0f))))) {
                    int motionStr = this.jetStrength + 3;
                    double motionX = xOffset * ((double)motionStr / 20.0);
                    double motionZ = zOffset * ((double)motionStr / 20.0);
                    double motionY = 0.1 + (double)(RANDOM.nextFloat() * (float)motionStr) / 20.0;
                    boolean added = Collections.addWaterSpray(this.world, this.posX + xOffset, this.deltaY, this.posZ + zOffset, motionX, motionY, motionZ);
                    if (!added) break;
                }
                ++j;
            }
        }
    }

    static {
        ResourceLocation defaultAcoustic = new ResourceLocation("environs", "waterfall/0");
        Arrays.fill(waterfallAcoustics, defaultAcoustic);
        WaterSplashJet.waterfallAcoustics[2] = WaterSplashJet.waterfallAcoustics[3] = new ResourceLocation("environs", "waterfall/1");
        WaterSplashJet.waterfallAcoustics[4] = new ResourceLocation("environs", "waterfall/2");
        WaterSplashJet.waterfallAcoustics[5] = WaterSplashJet.waterfallAcoustics[6] = new ResourceLocation("environs", "waterfall/3");
        WaterSplashJet.waterfallAcoustics[7] = WaterSplashJet.waterfallAcoustics[8] = new ResourceLocation("environs", "waterfall/4");
        WaterSplashJet.waterfallAcoustics[9] = WaterSplashJet.waterfallAcoustics[10] = new ResourceLocation("environs", "waterfall/5");
    }
}

