/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.particles;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.effects.particles.MoteFireFly;
import org.orecruncher.environs.effects.particles.MoteRainSplash;
import org.orecruncher.environs.effects.particles.MoteWaterRipple;
import org.orecruncher.environs.effects.particles.MoteWaterSpray;
import org.orecruncher.environs.effects.particles.RippleStyle;
import org.orecruncher.lib.particles.CollectionManager;
import org.orecruncher.lib.particles.IParticleCollection;
import org.orecruncher.lib.particles.ParticleRenderType;

@Mod.EventBusSubscriber(modid="environs", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class Collections {
    private static final IParticleRenderType RIPPLE_RENDER = new ParticleRenderType(new ResourceLocation("environs", "textures/particles/ripple.png")){

        @Override
        protected ResourceLocation getTexture() {
            return ((RippleStyle)((Object)Config.CLIENT.effects.waterRippleStyle.get())).getTexture();
        }

        @Override
        public void func_217600_a(@Nonnull BufferBuilder buffer, @Nonnull TextureManager textureManager) {
            super.func_217600_a(buffer, textureManager);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.alphaFunc((int)516, (float)0.003921569f);
        }
    };
    private static final IParticleRenderType SPRAY_RENDER = new ParticleRenderType(new ResourceLocation("environs", "textures/particles/rainsplash.png"));
    private static final IParticleRenderType FIREFLY_RENDER = IParticleRenderType.field_217603_c;
    private static final IParticleCollection theRipples = CollectionManager.create("Rain Ripples", RIPPLE_RENDER);
    private static final IParticleCollection theSprays = CollectionManager.create("Water Spray", SPRAY_RENDER);
    private static final IParticleCollection theFireFlies = CollectionManager.create("Fireflies", FIREFLY_RENDER);

    private Collections() {
    }

    public static void addWaterRipple(@Nonnull IBlockReader world, double x, double y, double z) {
        if (theRipples.canFit()) {
            MoteWaterRipple mote = new MoteWaterRipple(world, x, y, z);
            theRipples.add(mote);
        }
    }

    public static boolean addWaterSpray(@Nonnull IBlockReader world, double x, double y, double z, double dX, double dY, double dZ) {
        if (theSprays.canFit()) {
            MoteWaterSpray mote = new MoteWaterSpray(world, x, y, z, dX, dY, dZ);
            theSprays.add(mote);
            return true;
        }
        return false;
    }

    public static boolean canFitWaterSpray() {
        return theSprays.canFit();
    }

    public static void addRainSplash(@Nonnull IBlockReader world, double x, double y, double z) {
        if (theSprays.canFit()) {
            MoteRainSplash mote = new MoteRainSplash(world, x, y, z);
            theSprays.add(mote);
        }
    }

    public static void addFireFly(@Nonnull IBlockReader world, double x, double y, double z) {
        if (theFireFlies.canFit()) {
            MoteFireFly mote = new MoteFireFly(world, x, y, z);
            theFireFlies.add(mote);
        }
    }
}

