/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.particles;

import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.random.XorShiftRandom;

@OnlyIn(value=Dist.CLIENT)
public enum RippleStyle {
    CIRCLE("textures/particles/ripple.png"),
    DARK_CIRCLE("textures/particles/ripple1.png"),
    DARK_SQUARE("textures/particles/ripple2.png"),
    PIXELATED_CIRCLE("textures/particles/pixel_ripples.png"){
        private final int FRAMES = 7;
        private final float DELTA;
        private final int MAX_AGE;
        {
            ((Object)((Object)this)).getClass();
            this.DELTA = 1.0f / 7.0f;
            this.MAX_AGE = this.FRAMES * 2;
        }

        @Override
        public float getU1(int age) {
            return (float)(age / 2) * this.DELTA;
        }

        @Override
        public float getU2(int age) {
            return this.getU1(age) + this.DELTA;
        }

        @Override
        public boolean doScaling() {
            return false;
        }

        @Override
        public int getMaxAge() {
            return this.MAX_AGE;
        }
    };

    private final ResourceLocation resource;

    private RippleStyle(String texture) {
        this.resource = new ResourceLocation("environs", texture);
    }

    @Nonnull
    public ResourceLocation getTexture() {
        return this.resource;
    }

    public float getU1(int age) {
        return 0.0f;
    }

    public float getU2(int age) {
        return 1.0f;
    }

    public float getV1(int age) {
        return 0.0f;
    }

    public float getV2(int age) {
        return 1.0f;
    }

    public boolean doScaling() {
        return true;
    }

    public boolean doAlpha() {
        return true;
    }

    public int getMaxAge() {
        return 12 + XorShiftRandom.current().nextInt(8);
    }
}

