/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.handlers;

import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.Environs;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.api.sound.IFadableSoundInstance;
import org.orecruncher.sndctrl.audio.AudioEngine;
import org.orecruncher.sndctrl.audio.SoundState;

@OnlyIn(value=Dist.CLIENT)
public final class BackgroundAcousticEmitter {
    private static final int REPLACED_STANDOFF = 33;
    @Nonnull
    protected final IAcoustic acousticSource;
    @Nonnull
    protected final IFadableSoundInstance activeSound;
    protected int standoff = 0;
    protected boolean done = false;

    public BackgroundAcousticEmitter(@Nonnull IAcoustic acoustic) {
        this.acousticSource = acoustic;
        this.activeSound = acoustic.getFactory().createBackgroundSound();
    }

    @Nonnull
    public IAcoustic getSource() {
        return this.acousticSource;
    }

    public void tick() {
        if (this.activeSound.getState().isActive()) {
            if (this.isFading() && this.activeSound.getState() == SoundState.DELAYED) {
                AudioEngine.stop(this.activeSound);
            }
            return;
        }
        if (this.isFading()) {
            this.done = true;
            return;
        }
        if (!this.activeSound.getState().isActive()) {
            if (this.standoff > 0) {
                --this.standoff;
            } else {
                AudioEngine.play(this.activeSound);
                if (this.activeSound.getState() == SoundState.REPLACED) {
                    this.standoff = 33;
                }
            }
        }
    }

    public void setVolumeThrottle(float throttle) {
        this.activeSound.setFadeVolume(throttle);
    }

    public void fade() {
        Environs.LOGGER.debug("FADE: %s", this.activeSound.toString());
        this.activeSound.fade();
    }

    public boolean isFading() {
        return this.activeSound.isFading();
    }

    public void unfade() {
        Environs.LOGGER.debug("UNFADE: %s", this.activeSound.toString());
        this.activeSound.unfade();
    }

    public boolean isDonePlaying() {
        return this.done || this.activeSound.func_147667_k();
    }

    public void stop() {
        AudioEngine.stop(this.activeSound);
    }

    public String toString() {
        return this.activeSound.toString();
    }
}

