/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.library;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.library.BiomeAdapter;
import org.orecruncher.environs.library.BiomeInfo;
import org.orecruncher.environs.misc.IMixinBiomeData;
import org.orecruncher.lib.biomes.BiomeUtilities;

@OnlyIn(value=Dist.CLIENT)
public final class BiomeUtil {
    @Nonnull
    public static BiomeInfo getBiomeData(@Nonnull Biome biome) {
        BiomeInfo result = ((IMixinBiomeData)biome).getInfo();
        if (result == null) {
            Biome forge = BiomeUtilities.getClientBiome(biome);
            if (forge != null) {
                result = ((IMixinBiomeData)forge).getInfo();
            }
            if (result == null) {
                BiomeAdapter handler = new BiomeAdapter(biome);
                result = new BiomeInfo(handler);
            }
            ((IMixinBiomeData)biome).setInfo(result);
        }
        return result;
    }

    public static void setBiomeData(@Nonnull Biome biome, @Nullable BiomeInfo data) {
        ((IMixinBiomeData)biome).setInfo(data);
    }
}

