/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.library.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.Environs;
import org.orecruncher.environs.library.config.AcousticConfig;
import org.orecruncher.environs.library.config.EffectConfig;
import org.orecruncher.lib.validation.IValidator;
import org.orecruncher.lib.validation.ValidationException;
import org.orecruncher.lib.validation.ValidationHelpers;

@OnlyIn(value=Dist.CLIENT)
public class BlockConfig
implements IValidator<BlockConfig> {
    @SerializedName(value="blocks")
    public List<String> blocks = ImmutableList.of();
    @SerializedName(value="soundReset")
    public Boolean soundReset = null;
    @SerializedName(value="effectReset")
    public Boolean effectReset = null;
    @SerializedName(value="chance")
    public Integer chance = null;
    @SerializedName(value="acoustics")
    public List<AcousticConfig> acoustics = ImmutableList.of();
    @SerializedName(value="effects")
    public List<EffectConfig> effects = ImmutableList.of();

    @Override
    public void validate(@Nonnull BlockConfig obj) throws ValidationException {
        ValidationHelpers.hasElements("blocks", this.blocks, x$0 -> Environs.LOGGER.warn((String)x$0, new Object[0]));
        for (String s : this.blocks) {
            ValidationHelpers.notNullOrWhitespace("blocks", s, x$0 -> Environs.LOGGER.warn((String)x$0, new Object[0]));
            ValidationHelpers.mustBeLowerCase("blocks", s, x$0 -> Environs.LOGGER.warn((String)x$0, new Object[0]));
        }
        for (AcousticConfig ac : this.acoustics) {
            ac.validate(ac);
        }
        for (EffectConfig ec : this.effects) {
            ec.validate(ec);
        }
    }
}

