/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.shaders.aurora;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.shaders.ShaderPrograms;
import org.orecruncher.environs.shaders.aurora.AuroraBase;
import org.orecruncher.environs.shaders.aurora.AuroraRenderType;
import org.orecruncher.environs.shaders.aurora.AuroraUtils;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.shaders.ShaderCallContext;

@OnlyIn(value=Dist.CLIENT)
public class AuroraShaderBand
extends AuroraBase {
    private static final float V1 = 0.0f;
    private static final float V2 = 0.5f;
    protected ShaderPrograms program = ShaderPrograms.AURORA;
    protected Consumer<ShaderCallContext> callback = shaderCallContext -> {
        shaderCallContext.set("time", AuroraUtils.getTimeSeconds() * 0.75f);
        shaderCallContext.set("resolution", this.getAuroraWidth(), this.getAuroraHeight());
        shaderCallContext.set("topColor", this.getFadeColor());
        shaderCallContext.set("middleColor", this.getMiddleColor());
        shaderCallContext.set("bottomColor", this.getBaseColor());
        shaderCallContext.set("alpha", this.getAlpha());
    };
    protected final float auroraWidth = (float)this.band.getPanelCount() * this.band.getNodeWidth();
    protected final float panelTexWidth = this.band.getNodeWidth() / this.auroraWidth;

    public AuroraShaderBand(long seed) {
        super(seed);
    }

    @Override
    public void update() {
        super.update();
        this.band.update();
    }

    @Override
    protected float getAlpha() {
        return MathStuff.clamp((float)this.band.getAlphaLimit() / 255.0f * this.tracker.ageRatio() * 2.0f, 0.0f, 1.0f);
    }

    protected float getAuroraWidth() {
        return this.auroraWidth;
    }

    protected float getAuroraHeight() {
        return 180.0f;
    }

    protected void generateBand(@Nonnull IVertexBuilder builder, @Nonnull Matrix4f matrix) {
        Vector3f[] quad;
        int i = 0;
        while ((quad = this.band.getPanelQuad(i)) != null) {
            float u1 = (float)i * this.panelTexWidth;
            float u2 = u1 + this.panelTexWidth;
            builder.func_227888_a_(matrix, quad[0].func_195899_a(), quad[0].func_195900_b(), quad[0].func_195902_c()).func_225583_a_(u1, 0.0f).func_181675_d();
            builder.func_227888_a_(matrix, quad[1].func_195899_a(), quad[1].func_195900_b(), quad[1].func_195902_c()).func_225583_a_(u2, 0.0f).func_181675_d();
            builder.func_227888_a_(matrix, quad[2].func_195899_a(), quad[2].func_195900_b(), quad[2].func_195902_c()).func_225583_a_(u2, 0.5f).func_181675_d();
            builder.func_227888_a_(matrix, quad[3].func_195899_a(), quad[3].func_195900_b(), quad[3].func_195902_c()).func_225583_a_(u1, 0.5f).func_181675_d();
            ++i;
        }
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, float partialTick) {
        if (this.program == null) {
            return;
        }
        this.band.translate(partialTick);
        double tranY = this.getTranslationY(partialTick);
        double tranX = this.getTranslationX(partialTick);
        double tranZ = this.getTranslationZ(partialTick);
        Vector3d view = GameUtils.getMC().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
        RenderType type = AuroraRenderType.QUAD;
        IRenderTypeBuffer.Impl buffer = GameUtils.getMC().func_228019_au_().func_228487_b_();
        ShaderPrograms.MANAGER.useShader(this.program, this.callback);
        try {
            for (int b = 0; b < this.bandCount; ++b) {
                IVertexBuilder builder = buffer.getBuffer(type);
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(tranX, tranY, tranZ + (double)(this.offset * (float)b));
                this.generateBand(builder, matrixStack.func_227866_c_().func_227870_a_());
                matrixStack.func_227865_b_();
                RenderSystem.disableDepthTest();
                buffer.func_228462_a_(type);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.program = null;
        }
        ShaderPrograms.MANAGER.releaseShader();
        matrixStack.func_227865_b_();
    }

    @Override
    public String toString() {
        return "<SHADER> " + super.toString();
    }
}

