/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;

public final class MaterialUtils {
    private static final Reference2ObjectOpenHashMap<Material, String> materialMap = new Reference2ObjectOpenHashMap();
    private static final Map<String, Material> materialMapInv = new TreeMap<String, Material>(String.CASE_INSENSITIVE_ORDER);

    private MaterialUtils() {
    }

    @Nonnull
    public static Set<Material> getMaterials() {
        return materialMap.keySet();
    }

    @Nullable
    public static Material getMaterial(@Nonnull String name) {
        return materialMapInv.get(name);
    }

    @Nullable
    public static String getMaterialName(@Nonnull Material mat) {
        return (String)materialMap.get((Object)mat);
    }

    static {
        materialMap.defaultReturnValue((Object)"CUSTOM");
        materialMap.put((Object)Material.field_151579_a, (Object)"AIR");
        materialMap.put((Object)Material.field_189963_J, (Object)"STRUCTURE_VOID");
        materialMap.put((Object)Material.field_151567_E, (Object)"PORTAL");
        materialMap.put((Object)Material.field_151593_r, (Object)"CARPET");
        materialMap.put((Object)Material.field_151585_k, (Object)"PLANTS");
        materialMap.put((Object)Material.field_203243_f, (Object)"OCEAN_PLANT");
        materialMap.put((Object)Material.field_151582_l, (Object)"TALL_PLANTS");
        materialMap.put((Object)Material.field_242934_h, (Object)"NETHER_PLANTS");
        materialMap.put((Object)Material.field_204868_h, (Object)"SEA_GRASS");
        materialMap.put((Object)Material.field_151586_h, (Object)"WATER");
        materialMap.put((Object)Material.field_203244_i, (Object)"BUBBLE_COLUMN");
        materialMap.put((Object)Material.field_151587_i, (Object)"LAVA");
        materialMap.put((Object)Material.field_151597_y, (Object)"SNOW");
        materialMap.put((Object)Material.field_151581_o, (Object)"FIRE");
        materialMap.put((Object)Material.field_151594_q, (Object)"MISCELLANEOUS");
        materialMap.put((Object)Material.field_151569_G, (Object)"WEB");
        materialMap.put((Object)Material.field_151591_t, (Object)"REDSTONE_LIGHT");
        materialMap.put((Object)Material.field_151571_B, (Object)"CLAY");
        materialMap.put((Object)Material.field_151578_c, (Object)"EARTH");
        materialMap.put((Object)Material.field_151577_b, (Object)"ORGANIC");
        materialMap.put((Object)Material.field_151598_x, (Object)"PACKED_ICE");
        materialMap.put((Object)Material.field_151595_p, (Object)"SAND");
        materialMap.put((Object)Material.field_151583_m, (Object)"SPONGE");
        materialMap.put((Object)Material.field_215711_w, (Object)"SHULKER");
        materialMap.put((Object)Material.field_151575_d, (Object)"WOOD");
        materialMap.put((Object)Material.field_237214_y_, (Object)"NETHER_WOOD");
        materialMap.put((Object)Material.field_215712_y, (Object)"BAMBOO_SAPLING");
        materialMap.put((Object)Material.field_215713_z, (Object)"BAMBOO");
        materialMap.put((Object)Material.field_151580_n, (Object)"WOOL");
        materialMap.put((Object)Material.field_151590_u, (Object)"TNT");
        materialMap.put((Object)Material.field_151584_j, (Object)"LEAVES");
        materialMap.put((Object)Material.field_151592_s, (Object)"GLASS");
        materialMap.put((Object)Material.field_151588_w, (Object)"ICE");
        materialMap.put((Object)Material.field_151570_A, (Object)"CACTUS");
        materialMap.put((Object)Material.field_151576_e, (Object)"ROCK");
        materialMap.put((Object)Material.field_151573_f, (Object)"IRON");
        materialMap.put((Object)Material.field_151596_z, (Object)"SNOW_BLOCK");
        materialMap.put((Object)Material.field_151574_g, (Object)"ANVIL");
        materialMap.put((Object)Material.field_175972_I, (Object)"BARRIER");
        materialMap.put((Object)Material.field_76233_E, (Object)"PISTON");
        materialMap.put((Object)Material.field_151589_v, (Object)"CORAL");
        materialMap.put((Object)Material.field_151572_C, (Object)"GOURD");
        materialMap.put((Object)Material.field_151566_D, (Object)"DRAGON_EGG");
        materialMap.put((Object)Material.field_151568_F, (Object)"CAKE");
        for (Map.Entry kvp : materialMap.entrySet()) {
            materialMapInv.put((String)kvp.getValue(), (Material)kvp.getKey());
        }
    }
}

