/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.blockstate;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import org.orecruncher.lib.blockstate.BlockStateMatcher;

public final class BlockStateMatcherMap<T>
implements Map<BlockStateMatcher, T> {
    private final Map<BlockStateMatcher, T> map = new Object2ObjectOpenHashMap();
    @Nonnull
    private Supplier<T> defaultValue = () -> null;

    @Nullable
    public T get(@Nonnull BlockState state) {
        T result = this.map.get(BlockStateMatcher.create(state));
        if (result == null) {
            result = this.map.get(BlockStateMatcher.asGeneric(state));
        }
        if (result == null) {
            result = this.defaultValue.get();
        }
        return result;
    }

    public void setDefaultValue(@Nonnull Supplier<T> s) {
        this.defaultValue = s;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    @Nullable
    public T get(Object key) {
        return this.map.get(key);
    }

    @Override
    @Nullable
    public T put(@Nonnull BlockStateMatcher matcher, @Nonnull T val) {
        return this.map.put(matcher, val);
    }

    @Override
    @Nullable
    public T remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends BlockStateMatcher, ? extends T> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @Nonnull
    public Set<BlockStateMatcher> keySet() {
        return this.map.keySet();
    }

    @Override
    @Nonnull
    public Collection<T> values() {
        return this.map.values();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<BlockStateMatcher, T>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public void put(@Nonnull String blockName, @Nonnull T val) {
        BlockStateMatcher result = BlockStateMatcher.create(blockName);
        if (!result.isEmpty()) {
            this.put(result, val);
        }
    }

    @Override
    public void put(@Nonnull BlockState state, @Nonnull T val) {
        BlockStateMatcher result = BlockStateMatcher.create(state);
        if (!result.isEmpty()) {
            this.put(result, val);
        }
    }

    @Override
    public void put(@Nonnull Block block, @Nonnull T val) {
        BlockStateMatcher result = BlockStateMatcher.create(block);
        if (!result.isEmpty()) {
            this.put(result, val);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.map.entrySet().stream().map(Object::toString).collect(Collectors.joining("\n"))).toString();
    }
}

