/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.fml;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.loading.FMLPaths;
import org.orecruncher.lib.Lib;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    @Nonnull
    public static Path getConfigPath(@Nonnull String modId) {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve(Objects.requireNonNull(modId));
        if (Files.notExists(configPath, new LinkOption[0])) {
            try {
                Files.createDirectory(configPath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                Lib.LOGGER.error(ex, "Unable to create directory path %s", configPath.toString());
                configPath = FMLPaths.CONFIGDIR.get();
            }
        }
        return configPath;
    }
}

