/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.resource.ResourceAccessorExternal;
import org.orecruncher.lib.resource.ResourceAccessorJar;
import org.orecruncher.lib.resource.ResourceAccessorPack;
import org.orecruncher.lib.validation.Validators;

@OnlyIn(value=Dist.CLIENT)
public interface IResourceAccessor {
    public ResourceLocation location();

    default public String asString() {
        byte[] bytes = this.asBytes();
        return bytes != null ? new String(bytes, Charset.defaultCharset()) : null;
    }

    public byte[] asBytes();

    default public <T> T as(@Nonnull Class<T> clazz) {
        String content = this.asString();
        if (content != null) {
            try {
                Gson gson = new GsonBuilder().create();
                Object obj = gson.fromJson(content, clazz);
                Validators.validate(obj);
                return (T)obj;
            }
            catch (Throwable t) {
                Lib.LOGGER.error(t, "Unable to complete processing of %s", this.toString());
            }
        }
        return null;
    }

    default public boolean exists() {
        return this.asBytes() != null;
    }

    default public <T> T as(@Nonnull Type type) {
        String content = this.asString();
        if (content != null) {
            try {
                Gson gson = new GsonBuilder().create();
                Object obj = gson.fromJson(content, type);
                Validators.validate(obj, type);
                return (T)obj;
            }
            catch (Throwable t) {
                Lib.LOGGER.error(t, "Unable to complete processing of %s", this.toString());
            }
        }
        return null;
    }

    default public void logError(@Nonnull Throwable t) {
        if (t instanceof FileNotFoundException) {
            Lib.LOGGER.debug("Asset not found for %s", this.toString());
        } else {
            Lib.LOGGER.error(t, "Unable to process asset %s", this.toString());
        }
    }

    public static IResourceAccessor createJarResource(@Nonnull String rootContainer, @Nonnull ResourceLocation location) {
        return new ResourceAccessorJar(rootContainer, location);
    }

    public static IResourceAccessor createExternalResource(@Nonnull File root, @Nonnull ResourceLocation location) {
        return new ResourceAccessorExternal(root, location);
    }

    public static IResourceAccessor createPackResource(@Nonnull IResourcePack pack, @Nonnull ResourceLocation location, @Nonnull ResourceLocation actual) {
        return new ResourceAccessorPack(location, pack, actual);
    }

    public static void process(@Nonnull Collection<IResourceAccessor> accessors, @Nonnull Consumer<IResourceAccessor> consumer) {
        for (IResourceAccessor accessor : accessors) {
            Lib.LOGGER.info("Processing %s", accessor);
            try {
                consumer.accept(accessor);
            }
            catch (Throwable t) {
                Lib.LOGGER.error(t, "Unable to complete processing of %s", accessor);
            }
        }
    }
}

