/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.scripting.sets;

import javax.annotation.Nonnull;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.scripting.VariableSet;
import org.orecruncher.lib.scripting.sets.IWeatherVariables;
import org.orecruncher.lib.scripting.sets.LazyVariable;

@OnlyIn(value=Dist.CLIENT)
public class WeatherVariables
extends VariableSet<IWeatherVariables>
implements IWeatherVariables {
    private final LazyVariable<Float> temperature = new LazyVariable<Float>(() -> {
        if (GameUtils.isInGame()) {
            ClientWorld world = GameUtils.getWorld();
            BlockPos pos = GameUtils.getPlayer().func_233580_cy_();
            return Float.valueOf(WorldUtils.getTemperatureAt((World)world, pos));
        }
        return Float.valueOf(0.0f);
    });
    private boolean isRaining;
    private boolean isThundering;
    private float rainIntensity;
    private float thunderIndensity;

    public WeatherVariables() {
        super("weather");
    }

    @Override
    @Nonnull
    public IWeatherVariables getInterface() {
        return this;
    }

    @Override
    public void update() {
        if (GameUtils.isInGame()) {
            ClientWorld world = GameUtils.getWorld();
            this.rainIntensity = WorldUtils.getRainStrength((World)world, 1.0f);
            this.thunderIndensity = WorldUtils.getThunderStrength((World)world, 1.0f);
            this.isRaining = WorldUtils.isRaining((World)world);
            this.isThundering = WorldUtils.isThundering((World)world);
        } else {
            this.rainIntensity = 0.0f;
            this.thunderIndensity = 0.0f;
            this.isRaining = false;
            this.isThundering = false;
        }
        this.temperature.reset();
    }

    @Override
    public boolean isRaining() {
        return this.isRaining;
    }

    @Override
    public boolean isThundering() {
        return this.isThundering;
    }

    @Override
    public float getRainIntensity() {
        return this.rainIntensity;
    }

    @Override
    public float getThunderIntensity() {
        return this.thunderIndensity;
    }

    @Override
    public float getTemperature() {
        return this.temperature.get().floatValue();
    }
}

