/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.library;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.mobeffects.library.Constants;
import org.orecruncher.mobeffects.library.ItemLibrary;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.api.acoustics.IAcousticFactory;
import org.orecruncher.sndctrl.api.acoustics.Library;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.AudioEngine;
import org.orecruncher.sndctrl.audio.PlayerCenteredSoundInstance;
import org.orecruncher.sndctrl.audio.acoustic.NullAcoustic;
import org.orecruncher.sndctrl.library.Primitives;

@OnlyIn(value=Dist.CLIENT)
public class ItemData {
    private static final int ACOUSTIC_TYPE_SWING = 0;
    private static final int ACOUSTIC_TYPE_USE = 1;
    private static final int ACOUSTIC_TYPE_EQUIP = 2;
    private static final int ACOUSTIC_TYPE_ARMOR = 3;
    private static final int ACOUSTIC_TYPE_ARMOR_FOOT = 4;
    private static final float OTHER_PLAYER_VOLUME_SCALE = 0.75f;
    private final String name;
    private final ResourceLocation swing;
    private final ResourceLocation use;
    private final ResourceLocation equip;
    protected final IAcoustic[] acoustics = new IAcoustic[5];

    ItemData(@Nonnull String name, @Nonnull ResourceLocation sound) {
        this(name, sound, sound, sound);
    }

    ItemData(@Nonnull String name, @Nonnull ResourceLocation swing, @Nonnull ResourceLocation use, @Nonnull ResourceLocation equip) {
        this.name = name;
        this.swing = swing;
        this.use = use;
        this.equip = equip;
    }

    private IAcoustic resolveToolbarAcoustic(int type, @Nonnull ResourceLocation loc) {
        IAcoustic acoustic = this.acoustics[type];
        if (acoustic == null) {
            acoustic = Library.resolve(loc);
            if (acoustic == NullAcoustic.INSTANCE) {
                acoustic = Primitives.getSound(loc, Constants.TOOLBAR);
            }
            this.acoustics[type] = acoustic;
        }
        return acoustic;
    }

    public static ItemStack effectiveArmorItemStack(@Nonnull LivingEntity entity) {
        ItemStack chest = entity.func_184582_a(EquipmentSlotType.CHEST);
        ItemStack legs = entity.func_184582_a(EquipmentSlotType.LEGS);
        ItemData chestItemData = ItemLibrary.getItemData(chest);
        ItemData legsItemData = ItemLibrary.getItemData(legs);
        int chestPriority = chestItemData.isArmor() ? ((ArmorItemData)chestItemData).getPriority() : -1;
        int legPriority = legsItemData.isArmor() ? ((ArmorItemData)legsItemData).getPriority() : -1;
        return chestPriority > legPriority ? chest.func_77946_l() : legs.func_77946_l();
    }

    public static ItemStack footArmorItemStack(@Nonnull LivingEntity entity) {
        return entity.func_184582_a(EquipmentSlotType.FEET);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void playSwingSound() {
        this.playSwingSound(null);
    }

    public void playSwingSound(@Nullable BlockPos pos) {
        this.play(0, this.swing, pos);
    }

    public void playUseSound() {
        this.playUseSound(null);
    }

    public void playUseSound(@Nullable BlockPos pos) {
        this.play(1, this.use, pos);
    }

    public void playEquipSound() {
        this.playEquipSound(null);
    }

    public void playEquipSound(@Nullable BlockPos pos) {
        this.play(2, this.equip, pos);
    }

    public boolean isArmor() {
        return this instanceof ArmorItemData;
    }

    protected void play(int type, @Nonnull ResourceLocation loc, @Nullable BlockPos pos) {
        IAcoustic acoustic = this.resolveToolbarAcoustic(type, loc);
        IAcousticFactory factory = acoustic.getFactory(Constants.WALK);
        if (factory != null) {
            ISoundInstance sound;
            if (pos == null) {
                sound = new PlayerCenteredSoundInstance(factory.createSound(), Constants.TOOLBAR);
            } else {
                sound = factory.createSoundAt(pos);
                sound.scaleVolume(0.75f);
            }
            AudioEngine.play(sound);
        }
    }

    public static class ArmorItemData
    extends ItemData {
        private final ResourceLocation armor;
        private final ResourceLocation foot;
        private final int priority;

        ArmorItemData(@Nonnull String name, @Nonnull ResourceLocation item, @Nonnull ResourceLocation armor, @Nonnull ResourceLocation foot, int priority) {
            super(name, item);
            this.armor = armor;
            this.foot = foot;
            this.priority = priority;
        }

        @Nonnull
        public IAcoustic getArmorSound(@Nonnull ItemStack stack) {
            return this.resolveArmorAcoustic(3, this.armor, stack);
        }

        @Nonnull
        public IAcoustic getFootArmorSound(@Nonnull ItemStack stack) {
            return this.resolveArmorAcoustic(4, this.foot, stack);
        }

        public int getPriority() {
            return this.priority;
        }

        private IAcoustic resolveArmorAcoustic(int type, @Nonnull ResourceLocation loc, @Nonnull ItemStack stack) {
            IAcoustic acoustic = NullAcoustic.INSTANCE;
            Item item = stack.func_77973_b();
            if (item instanceof ArmorItem && (acoustic = this.acoustics[type]) == null) {
                acoustic = Library.resolve(loc);
                if (acoustic == NullAcoustic.INSTANCE) {
                    acoustic = Primitives.getArmorAccentAcoustic(((ArmorItem)item).func_200880_d());
                }
                this.acoustics[type] = acoustic;
            }
            return acoustic;
        }
    }
}

