/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.handlers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.math.BlockRayTrace;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.math.RayTraceIterator;
import org.orecruncher.mobeffects.library.Constants;
import org.orecruncher.sndctrl.audio.SoundUtils;
import org.orecruncher.sndctrl.audio.handlers.SourceContext;
import org.orecruncher.sndctrl.audio.handlers.WorldContext;
import org.orecruncher.sndctrl.audio.handlers.effects.LowPassData;
import org.orecruncher.sndctrl.audio.handlers.effects.SourcePropertyFloat;
import org.orecruncher.sndctrl.config.Config;
import org.orecruncher.sndctrl.library.AudioEffectLibrary;

@OnlyIn(value=Dist.CLIENT)
public final class SoundFXUtils {
    private static final int OCCLUSION_SEGMENTS = 5;
    private static final int REVERB_RAYS = 32;
    private static final int REVERB_RAY_BOUNCES = 4;
    private static final float MAX_REVERB_DISTANCE = 256.0f;
    private static final float RECIP_TOTAL_RAYS = 0.0078125f;
    private static final float RECIP_PRIMARY_RAYS = 0.03125f;
    private static final float ENERGY_COEFF = 0.0014648438f;
    private static final float ENERGY_CONST = 4.8828125E-4f;
    private static final Vector3d[] REVERB_RAY_NORMALS = new Vector3d[32];
    private static final Vector3d[] REVERB_RAY_PROJECTED = new Vector3d[32];
    private static final Vector3d[] SURFACE_DIRECTION_NORMALS = new Vector3d[Direction.values().length];
    private final SourceContext source;

    public SoundFXUtils(@Nonnull SourceContext source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculate(@Nonnull WorldContext ctx) {
        assert (ctx.player != null);
        assert (ctx.world != null);
        assert (this.source.getSound() != null);
        if (ctx.isNotValid() || !this.source.isEnabled() || !SoundUtils.inRange(ctx.playerEyePosition, this.source.getSound()) || this.source.getPosition().equals((Object)Vector3d.field_186680_a)) {
            this.clearSettings();
            return;
        }
        if (this.source.getCategory() == Constants.FOOTSTEPS) {
            boolean bl = false;
        }
        Vector3d soundPos = SoundFXUtils.offsetPositionIfSolid(ctx.world, this.source.getPosition(), ctx.playerEyePosition);
        float absorptionCoeff = 3.0f;
        float airAbsorptionFactor = SoundFXUtils.calculateWeatherAbsorption(ctx, soundPos, ctx.playerEyePosition);
        float occlusionAccumulation = this.calculateOcclusion(ctx, soundPos, ctx.playerEyePosition);
        float sendCoeff = -occlusionAccumulation * 3.0f;
        float directCutoff = (float)MathStuff.exp(sendCoeff);
        directCutoff *= 1.0f - ctx.auralDampening;
        float sendGain0 = 0.0f;
        float sendGain1 = 0.0f;
        float sendGain2 = 0.0f;
        float sendGain3 = 0.0f;
        float[] bounceRatio = new float[4];
        float sharedAirspace = 0.0f;
        BlockRayTrace traceContext = new BlockRayTrace((IBlockReader)ctx.world, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY);
        block3: for (int i = 0; i < 32; ++i) {
            Vector3d origin = soundPos;
            Vector3d target = origin.func_178787_e(REVERB_RAY_PROJECTED[i]);
            BlockRayTraceResult rayHit = traceContext.trace(origin, target);
            if (SoundFXUtils.isMiss(rayHit)) continue;
            BlockPos lastHitBlock = rayHit.func_216350_a();
            Vector3d lastHitPos = rayHit.func_216347_e();
            Vector3d lastHitNormal = SoundFXUtils.surfaceNormal(rayHit.func_216354_b());
            Vector3d lastRayDir = REVERB_RAY_NORMALS[i];
            double totalRayDistance = origin.func_72438_d(rayHit.func_216347_e());
            for (int j = 0; j < 4; ++j) {
                float blockReflectivity = AudioEffectLibrary.getReflectivity(ctx.world.func_180495_p(lastHitBlock));
                float energyTowardsPlayer = blockReflectivity * 0.0014648438f + 4.8828125E-4f;
                Vector3d newRayDir = MathStuff.reflection(lastRayDir, lastHitNormal);
                origin = MathStuff.addScaled(lastHitPos, newRayDir, 0.01f);
                rayHit = traceContext.trace(origin, target = MathStuff.addScaled(origin, newRayDir, 256.0));
                if (SoundFXUtils.isMiss(rayHit)) {
                    totalRayDistance += lastHitPos.func_72438_d(ctx.playerEyePosition);
                } else {
                    int n = j;
                    bounceRatio[n] = bounceRatio[n] + blockReflectivity;
                    totalRayDistance += lastHitPos.func_72438_d(rayHit.func_216347_e());
                    lastHitPos = rayHit.func_216347_e();
                    lastHitNormal = SoundFXUtils.surfaceNormal(rayHit.func_216354_b());
                    lastRayDir = newRayDir;
                    lastHitBlock = rayHit.func_216350_a();
                    Vector3d finalRayStart = MathStuff.addScaled(lastHitPos, lastHitNormal, 0.01f);
                    BlockRayTraceResult finalRayHit = traceContext.trace(finalRayStart, ctx.playerEyePosition);
                    if (SoundFXUtils.isMiss(finalRayHit)) {
                        sharedAirspace += 1.0f;
                    }
                }
                assert (totalRayDistance >= 0.0);
                float reflectionDelay = (float)totalRayDistance * 0.12f * blockReflectivity;
                float cross0 = 1.0f - MathStuff.clamp1(Math.abs(reflectionDelay - 0.0f));
                float cross1 = 1.0f - MathStuff.clamp1(Math.abs(reflectionDelay - 1.0f));
                float cross2 = 1.0f - MathStuff.clamp1(Math.abs(reflectionDelay - 2.0f));
                float cross3 = MathStuff.clamp1(reflectionDelay - 2.0f);
                sendGain0 += cross0 * energyTowardsPlayer * 6.4f;
                sendGain1 += cross1 * energyTowardsPlayer * 12.8f;
                sendGain2 += cross2 * energyTowardsPlayer * 12.8f;
                sendGain3 += cross3 * energyTowardsPlayer * 12.8f;
                if (SoundFXUtils.isMiss(rayHit)) continue block3;
            }
        }
        bounceRatio[0] = bounceRatio[0] / 32.0f;
        bounceRatio[1] = bounceRatio[1] / 32.0f;
        bounceRatio[2] = bounceRatio[2] / 32.0f;
        bounceRatio[3] = bounceRatio[3] / 32.0f;
        float sharedAirspaceWeight0 = MathStuff.clamp1((sharedAirspace *= 0.5f) / 20.0f);
        float sharedAirspaceWeight1 = MathStuff.clamp1(sharedAirspace / 15.0f);
        float sharedAirspaceWeight2 = MathStuff.clamp1(sharedAirspace / 10.0f);
        float sharedAirspaceWeight3 = MathStuff.clamp1(sharedAirspace / 10.0f);
        float exp1 = (float)MathStuff.exp(sendCoeff);
        float exp2 = (float)MathStuff.exp(sendCoeff * 1.5f);
        float sendCutoff0 = exp1 * (1.0f - sharedAirspaceWeight0) + sharedAirspaceWeight0;
        float sendCutoff1 = exp1 * (1.0f - sharedAirspaceWeight1) + sharedAirspaceWeight1;
        float sendCutoff2 = exp2 * (1.0f - sharedAirspaceWeight2) + sharedAirspaceWeight2;
        float sendCutoff3 = exp2 * (1.0f - sharedAirspaceWeight3) + sharedAirspaceWeight3;
        float averageSharedAirspace = (sharedAirspaceWeight0 + sharedAirspaceWeight1 + sharedAirspaceWeight2 + sharedAirspaceWeight3) * 0.25f;
        directCutoff = Math.max((float)Math.sqrt(averageSharedAirspace) * 0.2f, directCutoff);
        float directGain = (float)MathStuff.pow(directCutoff, 0.1);
        sendGain1 *= bounceRatio[1];
        sendGain2 *= (float)MathStuff.pow(bounceRatio[2], 3.0);
        sendGain3 *= (float)MathStuff.pow(bounceRatio[3], 4.0);
        sendGain0 = MathStuff.clamp1(sendGain0);
        sendGain1 = MathStuff.clamp1(sendGain1);
        sendGain2 = MathStuff.clamp1(sendGain2 * 1.05f - 0.05f);
        sendGain3 = MathStuff.clamp1(sendGain3 * 1.05f - 0.05f);
        sendGain0 *= (float)MathStuff.pow(sendCutoff0, 0.1);
        sendGain1 *= (float)MathStuff.pow(sendCutoff1, 0.1);
        sendGain2 *= (float)MathStuff.pow(sendCutoff2, 0.1);
        sendGain3 *= (float)MathStuff.pow(sendCutoff3, 0.1);
        if (ctx.player.func_70090_H()) {
            sendCutoff0 *= 0.4f;
            sendCutoff1 *= 0.4f;
            sendCutoff2 *= 0.4f;
            sendCutoff3 *= 0.4f;
        }
        LowPassData lp0 = this.source.getLowPass0();
        LowPassData lp1 = this.source.getLowPass1();
        LowPassData lp2 = this.source.getLowPass2();
        LowPassData lp3 = this.source.getLowPass3();
        LowPassData direct = this.source.getDirect();
        SourcePropertyFloat prop = this.source.getAirAbsorb();
        Object object = this.source.sync();
        synchronized (object) {
            lp0.gain = sendGain0;
            lp0.gainHF = sendCutoff0;
            lp0.setProcess(true);
            lp1.gain = sendGain1;
            lp1.gainHF = sendCutoff1;
            lp1.setProcess(true);
            lp2.gain = sendGain2;
            lp2.gainHF = sendCutoff2;
            lp2.setProcess(true);
            lp3.gain = sendGain3;
            lp3.gainHF = sendCutoff3;
            lp3.setProcess(true);
            direct.gain = directGain;
            direct.gainHF = directCutoff;
            direct.setProcess(true);
            prop.setValue(airAbsorptionFactor);
            prop.setProcess(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSettings() {
        Object object = this.source.sync();
        synchronized (object) {
            this.source.getLowPass0().setProcess(false);
            this.source.getLowPass1().setProcess(false);
            this.source.getLowPass2().setProcess(false);
            this.source.getLowPass3().setProcess(false);
            this.source.getDirect().setProcess(false);
            this.source.getAirAbsorb().setProcess(false);
        }
    }

    private float calculateOcclusion(@Nonnull WorldContext ctx, @Nonnull Vector3d origin, @Nonnull Vector3d target) {
        assert (ctx.world != null);
        assert (ctx.player != null);
        if (!((Boolean)Config.CLIENT.sound.enableOcclusionCalcs.get()).booleanValue()) {
            return 0.0f;
        }
        if (!this.source.getCategory().doOcclusion()) {
            return 0.0f;
        }
        float factor = 0.0f;
        if (((Boolean)Config.CLIENT.sound.enableOcclusionCalcs.get()).booleanValue()) {
            Vector3d lastHit = origin;
            BlockState lastState = ctx.world.func_180495_p(new BlockPos(lastHit.func_82615_a(), lastHit.func_82617_b(), lastHit.func_82616_c()));
            BlockRayTrace traceContext = new BlockRayTrace((IBlockReader)ctx.world, origin, target, RayTraceContext.BlockMode.VISUAL, RayTraceContext.FluidMode.SOURCE_ONLY);
            RayTraceIterator itr = new RayTraceIterator(traceContext);
            for (int i = 0; i < 5 && itr.hasNext(); ++i) {
                BlockRayTraceResult result = (BlockRayTraceResult)itr.next();
                float occlusion = AudioEffectLibrary.getOcclusion(lastState);
                double distance = lastHit.func_72438_d(result.func_216347_e());
                factor = (float)((double)factor + (double)occlusion * distance);
                lastHit = result.func_216347_e();
                lastState = ctx.world.func_180495_p(result.func_216350_a());
            }
        }
        return factor;
    }

    private static float calculateWeatherAbsorption(@Nonnull WorldContext ctx, @Nonnull Vector3d pt1, @Nonnull Vector3d pt2) {
        assert (ctx.world != null);
        if (!ctx.isPrecipitating) {
            return 1.0f;
        }
        BlockPos low = new BlockPos(pt1);
        BlockPos mid = new BlockPos(MathStuff.addScaled(pt1, pt2, 0.5));
        BlockPos high = new BlockPos(pt2);
        Biome.RainType rt1 = WorldUtils.getCurrentPrecipitationAt(ctx.world, low);
        Biome.RainType rt2 = WorldUtils.getCurrentPrecipitationAt(ctx.world, mid);
        Biome.RainType rt3 = WorldUtils.getCurrentPrecipitationAt(ctx.world, high);
        float factor = SoundFXUtils.calcFactor(rt1, 0.25f);
        factor += SoundFXUtils.calcFactor(rt2, 0.5f);
        factor += SoundFXUtils.calcFactor(rt3, 0.25f);
        return factor *= ctx.precipitationStrength;
    }

    @Nonnull
    private static Vector3d surfaceNormal(@Nonnull Direction d) {
        return SURFACE_DIRECTION_NORMALS[d.ordinal()];
    }

    private static Vector3d offsetPositionIfSolid(@Nonnull IWorldReader world, @Nonnull Vector3d origin, @Nonnull Vector3d target) {
        if (!WorldUtils.isAirBlock((IBlockReader)world, new BlockPos(origin))) {
            return MathStuff.addScaled(origin, MathStuff.normalize(origin, target), 0.876f);
        }
        return origin;
    }

    private static float calcFactor(@Nonnull Biome.RainType type, float base) {
        return type == Biome.RainType.NONE ? base : base * (type == Biome.RainType.SNOW ? 5.0f : 2.0f);
    }

    private static boolean isMiss(@Nullable BlockRayTraceResult result) {
        return result == null || result.func_216346_c() == RayTraceResult.Type.MISS;
    }

    static {
        for (Direction d : Direction.values()) {
            Vector3i v = d.func_176730_m();
            SoundFXUtils.SURFACE_DIRECTION_NORMALS[d.ordinal()] = new Vector3d((double)v.func_177958_n(), (double)v.func_177956_o(), (double)v.func_177952_p());
        }
        for (int i = 0; i < 32; ++i) {
            double longitude = MathStuff.ANGLE * (double)i;
            double latitude = Math.asin((double)i / 32.0 * 2.0 - 1.0);
            SoundFXUtils.REVERB_RAY_NORMALS[i] = new Vector3d(Math.cos(latitude) * Math.cos(longitude), Math.cos(latitude) * Math.sin(longitude), Math.sin(latitude)).func_72432_b();
            SoundFXUtils.REVERB_RAY_PROJECTED[i] = REVERB_RAY_NORMALS[i].func_186678_a(256.0);
        }
    }
}

