/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.easy_emerald.tools.base;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TreeAxeBase
extends AxeItem {
    public static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_196662_n, Blocks.field_196664_o, Blocks.field_196666_p, Blocks.field_196668_q, Blocks.field_196670_r, Blocks.field_196672_s, Blocks.field_150342_X, Blocks.field_196626_Q, Blocks.field_196629_R, Blocks.field_196631_S, Blocks.field_196634_T, Blocks.field_196637_U, Blocks.field_196639_V, Blocks.field_196617_K, Blocks.field_196618_L, Blocks.field_196619_M, Blocks.field_196620_N, Blocks.field_196621_O, Blocks.field_196623_P, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_196625_cS, Blocks.field_196628_cT, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_222420_lI, Blocks.field_196689_eF, Blocks.field_196691_eG, Blocks.field_196693_eH, Blocks.field_196695_eI, Blocks.field_196699_eK, Blocks.field_196697_eJ, Blocks.field_196663_cq, Blocks.field_196665_cr, Blocks.field_196667_cs, Blocks.field_196669_ct, Blocks.field_196673_cv, Blocks.field_196671_cu});
    public static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_151572_C, (Object)Material.field_151570_A);
    public static final int LOG_BREAK_DELAY = 1;
    public static final Random random = new Random();

    public TreeAxeBase(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        PlayerEntity player;
        stack.func_96631_a(3, random, null);
        if (entityLiving instanceof PlayerEntity && !this.attemptFellTree(world, pos, player = (PlayerEntity)entityLiving)) {
            TreeAxeBase.attemptBreakNeighbors(world, pos, player, EFFECTIVE_ON, EFFECTIVE_MATERIALS, false);
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }

    private boolean attemptFellTree(final World world, BlockPos pos, final PlayerEntity player) {
        final ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        candidates.add(pos);
        int leaves = 0;
        for (int i = 0; i < candidates.size(); ++i) {
            if (logs.size() > 200) {
                return false;
            }
            BlockPos candidate = (BlockPos)candidates.get(i);
            Block block = world.func_180495_p(candidate).func_177230_c();
            if (BlockTags.field_206952_E.func_230235_a_((Object)block)) {
                ++leaves;
                continue;
            }
            if (logs.size() != 0 && !BlockTags.field_200031_h.func_230235_a_((Object)block)) continue;
            logs.add(candidate);
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos neighbor = candidate.func_177982_a(x, y, z);
                        if (candidates.contains(neighbor)) continue;
                        candidates.add(neighbor);
                    }
                }
            }
        }
        if (logs.size() == 0) {
            return false;
        }
        if ((double)leaves >= (double)logs.size() / 6.0) {
            MinecraftForge.EVENT_BUS.register(new Object(){
                int fortuneLevel;
                int silkLevel;
                int delay;
                int i;
                {
                    this.fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
                    this.silkLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca());
                    this.delay = 1;
                    this.i = 0;
                }

                @SubscribeEvent
                public void onTick(TickEvent.WorldTickEvent event) {
                    if (this.delay-- > 0) {
                        return;
                    }
                    this.delay = 1;
                    if (this.i < logs.size()) {
                        BlockPos log = (BlockPos)logs.get(this.i);
                        TreeAxeBase.attemptBreak(world, log, player, EFFECTIVE_ON, EFFECTIVE_MATERIALS, this.fortuneLevel, this.silkLevel, false);
                        ++this.i;
                    } else {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public static void attemptBreakNeighbors(World world, BlockPos pos, PlayerEntity player, Set<Block> effectiveOn, Set<Material> effectiveMaterials, boolean checkHarvestLevel) {
        world.func_175656_a(pos, Blocks.field_150359_w.func_176223_P());
        RayTraceResult trace = TreeAxeBase.calcRayTrace(world, player, RayTraceContext.FluidMode.ANY);
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        if (trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
            Direction face = blockTrace.func_216354_b();
            int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
            int silkLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca());
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a == 0 && b == 0) continue;
                    BlockPos target = null;
                    if (face == Direction.UP || face == Direction.DOWN) {
                        target = pos.func_177982_a(a, 0, b);
                    }
                    if (face == Direction.NORTH || face == Direction.SOUTH) {
                        target = pos.func_177982_a(a, b, 0);
                    }
                    if (face == Direction.EAST || face == Direction.WEST) {
                        target = pos.func_177982_a(0, a, b);
                    }
                    TreeAxeBase.attemptBreak(world, target, player, effectiveOn, effectiveMaterials, fortuneLevel, silkLevel, checkHarvestLevel);
                }
            }
        }
    }

    public static void attemptBreak(World world, BlockPos pos, PlayerEntity player, Set<Block> effectiveOn, Set<Material> effectiveMaterials, int fortuneLevel, int silkLevel, boolean checkHarvestLevel) {
        BlockState state = world.func_180495_p(pos);
        boolean validHarvest = !checkHarvestLevel || player.func_184614_ca().func_150998_b(state);
        boolean isEffective = effectiveOn.contains(state.func_177230_c()) || effectiveMaterials.contains(state.func_185904_a());
        boolean witherImmune = BlockTags.field_219755_X.func_230235_a_((Object)state.func_177230_c());
        if (validHarvest && isEffective && !witherImmune) {
            world.func_175655_b(pos, false);
            Block.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
            int exp = state.getExpDrop((IWorldReader)world, pos, fortuneLevel, silkLevel);
            if (exp > 0) {
                state.func_177230_c().func_180637_b((ServerWorld)world, pos, exp);
            }
        }
    }

    public static RayTraceResult calcRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }
}

