/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.init;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(modid="elevatorid", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final CommonGeneral GENERAL = new CommonGeneral(BUILDER);
    public static final ForgeConfigSpec SPEC = BUILDER.build();

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        LogManager.getLogger().debug(Logging.FORGEMOD, "Loaded elevator config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        LogManager.getLogger().debug(Logging.FORGEMOD, "Elevator config just got changed on the file system!");
    }

    public static class CommonGeneral {
        public final ForgeConfigSpec.BooleanValue sameColor;
        public final ForgeConfigSpec.BooleanValue precisionTarget;
        public final ForgeConfigSpec.BooleanValue mobSpawn;
        public final ForgeConfigSpec.BooleanValue resetPitchNormal;
        public final ForgeConfigSpec.BooleanValue resetPitchDirectional;
        public final ForgeConfigSpec.IntValue range;
        public final ForgeConfigSpec.BooleanValue useXP;
        public final ForgeConfigSpec.IntValue XPPointsAmount;

        CommonGeneral(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.sameColor = builder.worldRestart().comment("Should elevators have the same color in order to teleport ?").define("sameColor", false);
            this.range = builder.worldRestart().comment("Elevator range").defineInRange("range", 256, 3, 256);
            this.precisionTarget = builder.comment("Realign players to the center of elevator ?").define("precisionTarget", true);
            this.mobSpawn = builder.comment("Can mobs spawn on elevators ?").define("mobSpawn", false);
            this.resetPitchNormal = builder.comment("Reset pitch to 0 when teleporting to normal elevators ?").define("resetPitchNormal", false);
            this.resetPitchDirectional = builder.comment("Reset pitch to 0 when teleporting to directional elevators ?").define("resetPitchDirectional", true);
            this.useXP = builder.comment("Should teleporting require XP ?").define("useXP", false);
            this.XPPointsAmount = builder.comment(new String[]{"Amount of XP points to use when useXP is enabled", "Note this is NOT experience levels"}).defineInRange("XPPointsAmount", 1, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

