/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.init.ModSounds;
import xyz.vsngamer.elevatorid.network.TeleportRequest;

public class TeleportHandler {
    static void handle(TeleportRequest message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            double toZ;
            double toX;
            float pitch;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null || !player.m_6084_()) {
                return;
            }
            ServerLevel world = player.m_9236_();
            BlockPos from = message.getFrom();
            BlockPos to = message.getTo();
            if (!world.m_46749_(from) || !world.m_46749_(to)) {
                return;
            }
            double distanceSq = player.m_20238_(new Vec3((double)from.m_123341_(), (double)from.m_123342_(), (double)from.m_123343_()).m_82520_(0.0, 1.0, 0.0));
            if (distanceSq > 4.0) {
                return;
            }
            if (from.m_123341_() != to.m_123341_() || from.m_123343_() != to.m_123343_()) {
                return;
            }
            BlockState fromState = world.m_8055_(from);
            BlockState toState = world.m_8055_(to);
            if (!TeleportHandler.isElevator(fromState) || !TeleportHandler.isElevator(toState)) {
                return;
            }
            if (!TeleportHandler.validateTarget((BlockGetter)world, to)) {
                return;
            }
            float yaw = (Boolean)toState.m_61143_((Property)ElevatorBlock.DIRECTIONAL) != false ? ((Direction)toState.m_61143_((Property)ElevatorBlock.f_54117_)).m_122435_() : player.m_146908_();
            float f = pitch = (Boolean)toState.m_61143_((Property)ElevatorBlock.DIRECTIONAL) != false && (Boolean)ModConfig.GENERAL.resetPitchDirectional.get() != false || (Boolean)toState.m_61143_((Property)ElevatorBlock.DIRECTIONAL) == false && (Boolean)ModConfig.GENERAL.resetPitchNormal.get() != false ? 0.0f : player.m_146909_();
            if (((Boolean)ModConfig.GENERAL.precisionTarget.get()).booleanValue()) {
                toX = (double)to.m_123341_() + 0.5;
                toZ = (double)to.m_123343_() + 0.5;
            } else {
                toX = player.m_20185_();
                toZ = player.m_20189_();
            }
            if (((Boolean)ModConfig.GENERAL.useXP.get()).booleanValue() && !player.m_7500_()) {
                if (TeleportHandler.getPlayerExperienceProgress((Player)player) - (Integer)ModConfig.GENERAL.XPPointsAmount.get() >= 0 || player.f_36078_ > 0) {
                    player.m_6756_(-((Integer)ModConfig.GENERAL.XPPointsAmount.get()).intValue());
                } else {
                    player.m_6352_((Component)new TranslatableComponent("elevatorid.message.missing_xp").m_130940_(ChatFormatting.RED), player.m_142081_());
                    return;
                }
            }
            double blockYOffset = toState.m_60816_((BlockGetter)world, to).m_83297_(Direction.Axis.Y);
            player.m_8999_(world, toX, (double)to.m_123342_() + (blockYOffset == Double.NEGATIVE_INFINITY ? 1.0 : blockYOffset), toZ, yaw, pitch);
            player.m_20256_(player.m_20184_().m_82559_(new Vec3(1.0, 0.0, 1.0)));
            world.m_5594_(null, to, ModSounds.TELEPORT, SoundSource.BLOCKS, 1.0f, 1.0f);
        });
        ctx.get().setPacketHandled(true);
    }

    private static int getPlayerExperienceProgress(Player player) {
        return Math.round(player.f_36080_ * (float)player.m_36323_());
    }

    public static boolean validateTarget(BlockGetter world, BlockPos target) {
        return TeleportHandler.validateTarget(world.m_8055_(target.m_6630_(1))) && TeleportHandler.validateTarget(world.m_8055_(target.m_6630_(2)));
    }

    private static boolean validateTarget(BlockState blockState) {
        return !blockState.m_60767_().m_76333_();
    }

    public static boolean isElevator(BlockState blockState) {
        return blockState.m_60734_() instanceof ElevatorBlock;
    }
}

