/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.client.render.ElevatorBakedModel;
import xyz.vsngamer.elevatorid.init.Registry;
import xyz.vsngamer.elevatorid.tile.ElevatorContainer;

public class ElevatorTileEntity
extends BlockEntity
implements MenuProvider {
    private BlockState heldState;

    public ElevatorTileEntity(BlockPos pos, BlockState state) {
        super(Registry.ELEVATOR_TILE_ENTITY, pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        BlockState held_id = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("held_id"));
        this.heldState = ElevatorTileEntity.isValidState(held_id) ? held_id : null;
    }

    @Nonnull
    public CompoundTag m_6945_(@Nonnull CompoundTag compound) {
        super.m_6945_(compound);
        if (this.heldState != null) {
            compound.m_128365_("held_id", (Tag)NbtUtils.m_129202_((BlockState)this.heldState));
        }
        return compound;
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ElevatorBakedModel.HELD_STATE, (Object)this.heldState).build();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.updateClient();
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), 1, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nonnull
    public Component m_5446_() {
        return new TranslatableComponent("screen.elevatorid.elevator");
    }

    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new ElevatorContainer(id, this.f_58858_, player);
    }

    public void setHeldState(BlockState state) {
        this.heldState = state;
        this.markUpdated();
    }

    private void markUpdated() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 11);
        }
    }

    public BlockState getHeldState() {
        return this.heldState;
    }

    private void updateClient() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.requestModelDataUpdate();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 11);
            this.f_58857_.m_7726_().m_7827_().m_142202_(this.m_58899_());
        }
    }

    public boolean setCamoAndUpdate(BlockState newState) {
        if (this.heldState == newState) {
            return false;
        }
        if (!ElevatorTileEntity.isValidState(newState)) {
            return false;
        }
        this.setHeldState(newState);
        if (this.m_58904_() != null) {
            this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public static boolean isValidState(BlockState state) {
        if (state == null) {
            return true;
        }
        if (state.m_60734_() == Blocks.f_50016_) {
            return false;
        }
        if (state.m_155947_()) {
            return false;
        }
        if (state.m_60734_() instanceof ElevatorBlock) {
            return false;
        }
        if (state.m_60799_() != RenderShape.MODEL) {
            return false;
        }
        return state.m_60767_().m_76333_();
    }

    public static BlockEntityType<ElevatorTileEntity> getType(Block ... validBlocks) {
        BlockEntityType type = BlockEntityType.Builder.m_155273_(ElevatorTileEntity::new, (Block[])validBlocks).m_58966_(null);
        type.setRegistryName("elevator_tile");
        return type;
    }
}

