/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.TickPriority;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fmllegacy.hooks.BasicEventHooks;
import net.minecraftforge.registries.ForgeRegistries;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.StandardEntityBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.TooltipDisplay;
import wile.engineersdecor.libmc.ui.Guis;

public class EdCraftingTable {
    public static boolean with_assist = true;
    public static boolean with_assist_direct_history_refab = false;
    public static boolean with_crafting_slot_mouse_scrolling = true;
    public static boolean with_outslot_defined_refab = true;

    public static void on_config(boolean without_crafting_assist, boolean with_assist_immediate_history_refab, boolean without_crafting_slot_mouse_scrolling) {
        with_assist = !without_crafting_assist;
        with_assist_direct_history_refab = with_assist_immediate_history_refab;
        with_crafting_slot_mouse_scrolling = !without_crafting_slot_mouse_scrolling;
        with_outslot_defined_refab = with_assist;
        CraftingHistory.max_history_size(32);
        ModConfig.log("Config crafting table: assist:" + with_assist + ", direct-refab:" + with_assist_direct_history_refab + ", scrolling:" + with_crafting_slot_mouse_scrolling);
    }

    private static class CraftingHistory {
        public static final int RESULT_STACK_INDEX = 0;
        public static final int INPUT_STACKS_BEGIN = 1;
        public static final List<ItemStack> NOTHING = new ArrayList<ItemStack>();
        private static int max_history_size_ = 5;
        private final Level world;
        private final List<String> history_ = new ArrayList<String>();
        private String stash_ = "";
        private int current_ = -1;
        private List<ItemStack> current_stacks_ = new ArrayList<ItemStack>();
        private CraftingRecipe current_recipe_ = null;

        public CraftingHistory(Level world) {
            this.world = world;
        }

        public static int max_history_size() {
            return max_history_size_;
        }

        public static int max_history_size(int newsize) {
            max_history_size_ = Mth.m_14045_((int)newsize, (int)0, (int)32);
            return max_history_size_;
        }

        public void read(CompoundTag nbt) {
            try {
                this.clear();
                String s = nbt.m_128461_("elements");
                if (s != null && s.length() > 0) {
                    String[] ls;
                    for (String e : ls = s.split("[|]")) {
                        this.history_.add(e.toLowerCase().trim());
                    }
                }
                this.current_ = !nbt.m_128441_("current") ? -1 : Mth.m_14045_((int)nbt.m_128451_("current"), (int)-1, (int)(this.history_.size() - 1));
                this.stash_ = nbt.m_128461_("stash");
                this.update_current();
            }
            catch (Throwable ex) {
                ModEngineersDecor.logger().error("Exception reading crafting table history NBT, resetting, exception is:" + ex.getMessage());
                this.clear();
            }
        }

        public CompoundTag write() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("current", this.current_);
            nbt.m_128359_("elements", String.join((CharSequence)"|", this.history_));
            if (!this.stash_.isEmpty()) {
                nbt.m_128359_("stash", this.stash_);
            }
            return nbt;
        }

        public void clear() {
            this.reset_current();
            this.history_.clear();
        }

        public void reset_current() {
            this.current_ = -1;
            this.stash_ = "";
            this.current_stacks_ = NOTHING;
            this.current_recipe_ = null;
        }

        void update_current() {
            if (!this.stash_.isEmpty()) {
                Tuple<CraftingRecipe, List<ItemStack>> data = this.str2stacks(this.stash_);
                if (data != null) {
                    this.current_recipe_ = (CraftingRecipe)data.m_14418_();
                    this.current_stacks_ = (List)data.m_14419_();
                }
            } else if (this.current_ < 0 || this.current_ >= this.history_.size()) {
                this.reset_current();
            } else {
                Tuple<CraftingRecipe, List<ItemStack>> data = this.str2stacks(this.history_.get(this.current_));
                if (data == null) {
                    this.reset_current();
                    return;
                }
                this.current_recipe_ = (CraftingRecipe)data.m_14418_();
                this.current_stacks_ = (List)data.m_14419_();
            }
        }

        public void stash(List<ItemStack> grid_stacks, CraftingRecipe recipe) {
            if (grid_stacks.size() == 9) {
                ArrayList<ItemStack> result_and_stacks = new ArrayList<ItemStack>();
                result_and_stacks.add(recipe.m_8043_());
                result_and_stacks.addAll(grid_stacks);
                this.stash_ = this.stacks2str(result_and_stacks, recipe);
                this.current_stacks_ = result_and_stacks;
            } else {
                this.stash_ = this.stacks2str(grid_stacks, recipe);
                this.current_stacks_ = grid_stacks;
            }
            this.current_ = -1;
            this.current_recipe_ = recipe;
        }

        public int find(ItemStack result) {
            for (int i = 0; i < this.history_.size(); ++i) {
                Tuple<CraftingRecipe, List<ItemStack>> data = this.str2stacks(this.history_.get(i));
                if (data == null || !((CraftingRecipe)data.m_14418_()).m_8043_().m_41656_(result)) continue;
                return i;
            }
            return -1;
        }

        public void add(List<ItemStack> grid_stacks, CraftingRecipe recipe) {
            if (!with_assist) {
                this.clear();
                return;
            }
            this.stash_ = "";
            String s = this.stacks2str(grid_stacks, recipe);
            if (s.isEmpty()) {
                return;
            }
            String recipe_filter = recipe.m_6423_() + ";";
            this.history_.removeIf(e -> e.equals(s));
            this.history_.removeIf(e -> e.startsWith(recipe_filter));
            this.history_.add(s);
            while (this.history_.size() > CraftingHistory.max_history_size()) {
                this.history_.remove(0);
            }
            if (this.current_ >= this.history_.size()) {
                this.reset_current();
            }
        }

        public String stacks2str(List<ItemStack> grid_stacks, CraftingRecipe recipe) {
            if (grid_stacks == null || recipe == null) {
                return "";
            }
            int num_stacks = grid_stacks.size();
            if (num_stacks < 9 || num_stacks > 10) {
                return "";
            }
            ArrayList<String> items = new ArrayList<String>();
            items.add(recipe.m_6423_().toString());
            if (num_stacks < 10) {
                items.add(recipe.m_8043_().m_41720_().getRegistryName().toString());
            }
            for (ItemStack st : grid_stacks) {
                if (st.m_41619_()) {
                    items.add("");
                    continue;
                }
                ResourceLocation rl = st.m_41720_().getRegistryName();
                items.add(rl.m_135827_().equals("minecraft") ? rl.m_135815_() : rl.toString());
            }
            return String.join((CharSequence)";", items);
        }

        @Nullable
        public Tuple<CraftingRecipe, List<ItemStack>> str2stacks(String entry) {
            if (this.world == null || entry == null || entry.isEmpty()) {
                return null;
            }
            try {
                ArrayList<String> item_regnames = new ArrayList<String>(Arrays.asList(entry.split("[;]")));
                if (item_regnames == null || item_regnames.size() < 2 || item_regnames.size() > 11) {
                    return null;
                }
                while (item_regnames.size() < 11) {
                    item_regnames.add("");
                }
                String recipe_name = item_regnames.remove(0);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (String regname : item_regnames) {
                    ItemStack stack = ItemStack.f_41583_;
                    if (!regname.isEmpty()) {
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(regname));
                        stack = item == null || item == Items.f_41852_ ? ItemStack.f_41583_ : new ItemStack((ItemLike)item, 1);
                    }
                    stacks.add(stack);
                }
                if (stacks.size() != 10 || ((ItemStack)stacks.get(0)).m_41619_()) {
                    return null;
                }
                Recipe recipe = this.world.m_7465_().m_44043_(new ResourceLocation(recipe_name)).orElse(null);
                if (!(recipe instanceof CraftingRecipe)) {
                    return null;
                }
                return new Tuple((Object)((CraftingRecipe)recipe), stacks);
            }
            catch (Throwable ex) {
                ModEngineersDecor.logger().error("History stack building failed: " + ex.getMessage());
                return null;
            }
        }

        public List<ItemStack> current() {
            return this.current_stacks_;
        }

        public CraftingRecipe current_recipe() {
            return this.current_recipe_;
        }

        public void next() {
            this.stash_ = "";
            this.current_ = this.history_.isEmpty() ? -1 : (++this.current_ >= this.history_.size() ? -1 : this.current_);
            this.update_current();
        }

        public void prev() {
            this.stash_ = "";
            this.current_ = this.history_.isEmpty() ? -1 : (--this.current_ < -1 ? this.history_.size() - 1 : this.current_);
            this.update_current();
        }

        public void reset_selection() {
            this.current_ = -1;
            this.stash_ = "";
            this.update_current();
        }

        public void selection(int index) {
            this.current_ = index < 0 || index >= this.history_.size() ? -1 : index;
            this.update_current();
        }

        public int selection() {
            return this.current_;
        }

        public int size() {
            return this.history_.size();
        }

        public String toString() {
            String rec = this.current_recipe_ == null ? "none" : this.current_recipe_.m_6423_().toString();
            StringBuilder s = new StringBuilder("{ current:" + this.current_ + ", recipe:'" + rec + "', elements:[ ");
            for (int i = 0; i < this.history_.size(); ++i) {
                s.append("{i:").append(i).append(", e:[").append(this.history_.get(i)).append("], stash: '").append(this.stash_).append("'}");
            }
            return s.toString();
        }
    }

    public static class CraftingTableGrid
    extends CraftingContainer {
        protected final AbstractContainerMenu uicontainer;
        protected final Container inventory;

        public CraftingTableGrid(AbstractContainerMenu container_, Container block_inventory) {
            super(container_, 3, 3);
            this.uicontainer = container_;
            this.inventory = block_inventory;
        }

        public int m_6643_() {
            return 9;
        }

        public void m_5856_(Player player) {
            this.inventory.m_5856_(player);
        }

        public void m_5785_(Player player) {
            this.inventory.m_5785_(player);
        }

        public void m_6596_() {
            this.inventory.m_6596_();
        }

        public void m_6836_(int index, ItemStack stack) {
            this.inventory.m_6836_(index, stack);
            this.uicontainer.m_6199_((Container)this);
        }

        public ItemStack m_8020_(int index) {
            return this.inventory.m_8020_(index);
        }

        public ItemStack m_7407_(int index, int count) {
            ItemStack stack = this.inventory.m_7407_(index, count);
            if (!stack.m_41619_()) {
                this.uicontainer.m_6199_((Container)this);
            }
            return stack;
        }
    }

    public static class CraftingGridSlot
    extends Slot {
        public CraftingGridSlot(Container inv, int index, int x, int y) {
            super(inv, index, x, y);
        }
    }

    public static class CraftingOutputSlot
    extends Slot {
        private final CraftingTableUiContainer uicontainer;
        private final Player player;
        private final CraftingContainer craftMatrix;
        private int amountCrafted;

        public CraftingOutputSlot(CraftingTableUiContainer uicontainer, Player player, CraftingContainer craftingInventory, Container resultInventory, int slotIndex, int xPosition, int yPosition) {
            super(resultInventory, slotIndex, xPosition, yPosition);
            this.craftMatrix = craftingInventory;
            this.uicontainer = uicontainer;
            this.player = player;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public ItemStack m_6201_(int amount) {
            if (this.m_6657_()) {
                this.amountCrafted += Math.min(amount, this.m_7993_().m_41613_());
            }
            return super.m_6201_(amount);
        }

        protected void m_7169_(ItemStack stack, int amount) {
            this.amountCrafted += amount;
            this.m_5845_(stack);
        }

        protected void m_6405_(int numItemsCrafted) {
            this.amountCrafted += numItemsCrafted;
        }

        protected void m_5845_(ItemStack stack) {
            if (with_assist && this.player.f_19853_ != null && !this.player.f_19853_.m_5776_() && !stack.m_41619_()) {
                Recipe<?> recipe = ((CraftOutputInventory)this.f_40218_).m_7928_();
                ArrayList<ItemStack> grid = new ArrayList<ItemStack>();
                grid.add(stack);
                for (int i = 0; i < 9; ++i) {
                    grid.add(this.uicontainer.inventory_.m_8020_(i));
                }
                if (recipe instanceof CraftingRecipe) {
                    this.uicontainer.history().add(grid, (CraftingRecipe)recipe);
                    this.uicontainer.history().reset_current();
                }
            }
            if (this.amountCrafted > 0) {
                stack.m_41678_(this.player.f_19853_, this.player, this.amountCrafted);
                BasicEventHooks.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, (Container)this.craftMatrix);
            }
            if (this.uicontainer instanceof RecipeHolder) {
                ((RecipeHolder)this.uicontainer).m_8015_(this.player);
            }
            this.amountCrafted = 0;
        }

        public void m_142406_(Player taking_player, ItemStack stack) {
            this.m_5845_(stack);
            ForgeHooks.setCraftingPlayer((Player)taking_player);
            NonNullList stacks = taking_player.f_19853_.m_7465_().m_44069_(RecipeType.f_44107_, (Container)this.craftMatrix, taking_player.f_19853_);
            ForgeHooks.setCraftingPlayer(null);
            for (int i = 0; i < stacks.size(); ++i) {
                ItemStack itemstack = this.craftMatrix.m_8020_(i);
                ItemStack itemstack1 = (ItemStack)stacks.get(i);
                if (!itemstack.m_41619_()) {
                    this.craftMatrix.m_7407_(i, 1);
                    itemstack = this.craftMatrix.m_8020_(i);
                }
                if (itemstack1.m_41619_()) continue;
                if (itemstack.m_41619_()) {
                    this.craftMatrix.m_6836_(i, itemstack1);
                    continue;
                }
                if (ItemStack.m_41746_((ItemStack)itemstack, (ItemStack)itemstack1) && ItemStack.m_41658_((ItemStack)itemstack, (ItemStack)itemstack1)) {
                    itemstack1.m_41769_(itemstack.m_41613_());
                    this.craftMatrix.m_6836_(i, itemstack1);
                    continue;
                }
                if (this.player.m_150109_().m_36054_(itemstack1)) continue;
                this.player.m_36176_(itemstack1, false);
            }
            this.uicontainer.onCraftMatrixChanged();
        }
    }

    public static class CraftOutputInventory
    extends ResultContainer
    implements Container,
    RecipeHolder {
        private final Container result_inv_;
        private Recipe<?> recipe_used_;

        public CraftOutputInventory(Container inventory) {
            this.result_inv_ = inventory;
        }

        public int m_6643_() {
            return 1;
        }

        public boolean m_7983_() {
            return this.result_inv_.m_8020_(0).m_41619_();
        }

        public ItemStack m_8020_(int index) {
            return this.result_inv_.m_8020_(0);
        }

        public ItemStack m_7407_(int index, int count) {
            return this.result_inv_.m_8016_(0);
        }

        public ItemStack m_8016_(int index) {
            return this.result_inv_.m_8016_(0);
        }

        public void m_6836_(int index, ItemStack stack) {
            this.result_inv_.m_6836_(0, stack);
        }

        public void m_6596_() {
            this.result_inv_.m_6596_();
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
            this.result_inv_.m_6836_(0, ItemStack.f_41583_);
        }

        public void m_6029_(@Nullable Recipe<?> recipe) {
            this.recipe_used_ = recipe;
        }

        @Nullable
        public Recipe<?> m_7928_() {
            return this.recipe_used_;
        }
    }

    public static enum PlacementResult {
        UNCHANGED,
        INCOMPLETE,
        PLACED;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CraftingTableGui
    extends Guis.ContainerGui<CraftingTableUiContainer> {
        protected final ArrayList<Button> buttons = new ArrayList();
        protected final boolean[] history_slot_tooltip = new boolean[]{false, false, false, false, false, false, false, false, false, false};

        public CraftingTableGui(CraftingTableUiContainer uicontainer, Inventory playerInventory, Component title) {
            super(uicontainer, playerInventory, title, "textures/gui/metal_crafting_table_gui.png", 176, 188);
        }

        @Override
        public void m_7856_() {
            super.m_7856_();
            int x0 = this.f_97735_;
            int y0 = this.f_97736_;
            this.buttons.clear();
            if (with_assist) {
                this.buttons.add((Button)this.m_142416_((GuiEventListener)new ImageButton(x0 + 158, y0 + 30, 12, 12, 194, 44, 12, this.getBackgroundImage(), bt -> this.action("next"))));
                this.buttons.add((Button)this.m_142416_((GuiEventListener)new ImageButton(x0 + 158, y0 + 16, 12, 12, 180, 30, 12, this.getBackgroundImage(), bt -> this.action("prev"))));
                this.buttons.add((Button)this.m_142416_((GuiEventListener)new ImageButton(x0 + 158, y0 + 44, 12, 12, 194, 8, 12, this.getBackgroundImage(), bt -> this.action("clear"))));
                this.buttons.add((Button)this.m_142416_((GuiEventListener)new ImageButton(x0 + 116, y0 + 10, 20, 10, 183, 95, 12, this.getBackgroundImage(), bt -> this.action("next-recipe"))));
            }
            ArrayList<TooltipDisplay.TipRange> tooltips = new ArrayList<TooltipDisplay.TipRange>();
            String prefix = ModContent.CRAFTING_TABLE.m_7705_() + ".tooltips.";
            String[] translation_keys = new String[]{"next", "prev", "clear", "nextcollisionrecipe", "fromstorage", "tostorage", "fromplayer", "toplayer"};
            for (int i = 0; i < this.buttons.size() && i < translation_keys.length; ++i) {
                Button bt2 = this.buttons.get(i);
                tooltips.add(new TooltipDisplay.TipRange(bt2.f_93620_, bt2.f_93621_, bt2.m_5711_(), bt2.m_93694_(), (Component)Auxiliaries.localizable(prefix + translation_keys[i])));
            }
            this.tooltip_.init(tooltips);
        }

        @Override
        public void m_6305_(PoseStack mx, int mouseX, int mouseY, float partialTicks) {
            if (with_assist) {
                boolean is_collision;
                this.buttons.get((int)3).f_93624_ = is_collision = ((CraftingTableUiContainer)this.m_6262_()).has_recipe_collision();
                this.buttons.get((int)3).f_93623_ = is_collision;
            }
            super.m_6305_(mx, mouseX, mouseY, partialTicks);
        }

        protected void renderHoveredToolTip(PoseStack mx, int mouseX, int mouseY) {
            if (!this.player_.m_150109_().f_35974_.isEmpty()) {
                return;
            }
            Slot slot = this.getSlotUnderMouse();
            if (slot == null) {
                return;
            }
            if (!slot.m_7993_().m_41619_()) {
                this.m_6057_(mx, slot.m_7993_(), mouseX, mouseY);
                return;
            }
            if (with_assist) {
                int hist_index = -1;
                if (slot instanceof CraftingOutputSlot) {
                    hist_index = 0;
                } else if (slot.f_40218_ instanceof CraftOutputInventory) {
                    hist_index = slot.getSlotIndex() + 1;
                }
                if (hist_index < 0 || hist_index >= this.history_slot_tooltip.length) {
                    return;
                }
                if (!this.history_slot_tooltip[hist_index]) {
                    return;
                }
                ItemStack hist_stack = ((CraftingTableUiContainer)this.m_6262_()).history().current().get(hist_index);
                if (!hist_stack.m_41619_()) {
                    this.m_6057_(mx, hist_stack, mouseX, mouseY);
                }
            }
        }

        @Override
        protected void renderBgWidgets(PoseStack mx, float partialTicks, int mouseX, int mouseY) {
            if (with_assist) {
                Arrays.fill(this.history_slot_tooltip, false);
                List<ItemStack> crafting_template = ((CraftingTableUiContainer)this.m_6262_()).history().current();
                if (crafting_template == null || crafting_template.isEmpty()) {
                    return;
                }
                int i = 0;
                for (Tuple e : ((CraftingTableUiContainer)this.m_6262_()).CRAFTING_SLOT_COORDINATES) {
                    if (i == 0) continue;
                    if (((CraftingTableUiContainer)this.m_6262_()).m_38853_(i).m_6657_() && !((CraftingTableUiContainer)this.m_6262_()).m_38853_(i).m_7993_().m_41656_(crafting_template.get(i))) {
                        return;
                    }
                    ++i;
                }
                i = 0;
                for (Tuple e : ((CraftingTableUiContainer)this.m_6262_()).CRAFTING_SLOT_COORDINATES) {
                    ItemStack stack = crafting_template.get(i);
                    if (!stack.m_41619_()) {
                        if (!((CraftingTableUiContainer)this.m_6262_()).m_38853_(i).m_6657_()) {
                            this.history_slot_tooltip[i] = true;
                        }
                        if (i == 0 && ((CraftingTableUiContainer)this.m_6262_()).m_38853_(i).m_7993_().m_41656_(crafting_template.get(i))) continue;
                        this.renderItemTemplate(mx, stack, (Integer)e.m_14418_(), (Integer)e.m_14419_());
                    }
                    ++i;
                }
            }
        }

        protected void action(String message) {
            this.action(message, new CompoundTag());
        }

        protected void action(String message, CompoundTag nbt) {
            ((CraftingTableUiContainer)this.m_6262_()).onGuiAction(message, nbt);
            this.tooltip_.resetTimer();
        }

        protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
            this.tooltip_.resetTimer();
            if (type == ClickType.PICKUP) {
                boolean place_refab;
                boolean bl = place_refab = slot instanceof CraftingOutputSlot && !slot.m_6657_();
                if (place_refab && with_assist_direct_history_refab) {
                    this.on_history_item_placement();
                }
                super.m_6597_(slot, slotId, mouseButton, type);
                if (place_refab && !with_assist_direct_history_refab) {
                    this.on_history_item_placement();
                }
                return;
            }
            if (type == ClickType.QUICK_MOVE && slotId > 0 && slot.m_6657_() && with_assist) {
                List<ItemStack> history = ((CraftingTableUiContainer)this.m_6262_()).history().current();
                boolean palce_in_crafting_grid = false;
                if (slotId > 9) {
                    boolean bl = palce_in_crafting_grid = !history.isEmpty();
                    if (!palce_in_crafting_grid) {
                        for (int i = 0; i < 9; ++i) {
                            if (Inventories.areItemStacksDifferent(((CraftingTableUiContainer)this.m_6262_()).m_38853_(i).m_7993_(), slot.m_7993_())) continue;
                            palce_in_crafting_grid = true;
                            break;
                        }
                    }
                }
                if (palce_in_crafting_grid) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128405_("containerslot", slotId);
                    if (Auxiliaries.isCtrlDown()) {
                        nbt.m_128379_("move-all", true);
                    }
                    this.action("place-stack", nbt);
                    return;
                }
                if (Auxiliaries.isCtrlDown()) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128405_("containerslot", slotId);
                    this.action("move-stacks", nbt);
                    return;
                }
                if (slotId > 0 && slotId <= 9) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128405_("containerslot", slotId);
                    this.action("move-stack", nbt);
                    return;
                }
            }
            super.m_6597_(slot, slotId, mouseButton, type);
        }

        public boolean m_6050_(double mouseX, double mouseY, double wheel_inc) {
            this.tooltip_.resetTimer();
            Slot resultSlot = this.getSlotUnderMouse();
            if (!with_crafting_slot_mouse_scrolling || !(resultSlot instanceof CraftingOutputSlot)) {
                return this.m_94729_(mouseX, mouseY).filter(evl -> evl.m_6050_(mouseX, mouseY, wheel_inc)).isPresent();
            }
            int count = resultSlot.m_7993_().m_41613_();
            int limit = (Auxiliaries.isShiftDown() ? 2 : 1) * (Auxiliaries.isCtrlDown() ? 4 : 1);
            if (wheel_inc > 0.1) {
                if (count > 0) {
                    if (count < resultSlot.m_7993_().m_41741_() && count < resultSlot.m_6641_()) {
                        CompoundTag nbt = new CompoundTag();
                        if (limit > 1) {
                            nbt.m_128405_("limit", limit);
                        }
                        this.action("inc-crafting-stacks", nbt);
                    }
                } else if (!((CraftingTableUiContainer)this.m_6262_()).history().current().isEmpty()) {
                    this.action("place-refab");
                }
            } else if (wheel_inc < -0.1 && count > 0) {
                CompoundTag nbt = new CompoundTag();
                if (limit > 1) {
                    nbt.m_128405_("limit", limit);
                }
                this.action("dec-crafting-stacks", nbt);
            }
            return true;
        }

        private void on_history_item_placement() {
            if (((CraftingTableUiContainer)this.m_6262_()).history().current().isEmpty()) {
                return;
            }
            Slot resultSlot = this.getSlotUnderMouse();
            if (!(resultSlot instanceof CraftingOutputSlot)) {
                return;
            }
            this.action("place-refab");
        }
    }

    public static class CraftingTableUiContainer
    extends AbstractContainerMenu
    implements Networking.INetworkSynchronisableContainer {
        protected static final String BUTTON_NEXT = "next";
        protected static final String BUTTON_PREV = "prev";
        protected static final String BUTTON_CLEAR_GRID = "clear";
        protected static final String BUTTON_NEXT_COLLISION_RECIPE = "next-recipe";
        protected static final String ACTION_PLACE_CURRENT_HISTORY_SEL = "place-refab";
        protected static final String ACTION_PLACE_SHIFTCLICKED_STACK = "place-stack";
        protected static final String ACTION_MOVE_ALL_STACKS = "move-stacks";
        protected static final String ACTION_MOVE_STACK = "move-stack";
        protected static final String ACTION_INCREASE_CRAFTING_STACKS = "inc-crafting-stacks";
        protected static final String ACTION_DECREASE_CRAFTING_STACKS = "dec-crafting-stacks";
        public static final int CRAFTING_SLOTS_BEGIN = 0;
        public static final int CRAFTING_SLOTS_SIZE = 9;
        public static final int NUM_OF_STORAGE_SLOTS = 18;
        public static final int NUM_OF_STORAGE_ROWS = 2;
        public final ImmutableList<Tuple<Integer, Integer>> CRAFTING_SLOT_COORDINATES;
        private final Player player_;
        private final Container inventory_;
        private final ContainerLevelAccess wpc_;
        private final CraftingHistory history_;
        private final CraftingTableGrid matrix_;
        private final CraftOutputInventory result_;
        private final CraftingOutputSlot crafting_output_slot_;
        private boolean has_recipe_collision_;
        private boolean crafting_matrix_changed_now_;
        private final Inventories.InventoryRange crafting_grid_range_;
        private final Inventories.InventoryRange crafting_result_range_;
        private final Inventories.InventoryRange block_storage_range_;
        private final Inventories.InventoryRange player_storage_range_;
        private final Inventories.InventoryRange player_hotbar_range_;
        private final Inventories.InventoryRange player_inventory_range_;
        @Nullable
        private final CraftingTableTileEntity te_;

        public CraftingTableUiContainer(int cid, Inventory pinv) {
            this(cid, pinv, (Container)new SimpleContainer(28), ContainerLevelAccess.f_39287_);
        }

        private CraftingTableUiContainer(int cid, Inventory pinv, Container block_inventory, ContainerLevelAccess wpc) {
            super(ModContent.CT_TREATED_WOOD_CRAFTING_TABLE, cid);
            int x;
            int y;
            this.wpc_ = wpc;
            this.player_ = pinv.f_35978_;
            this.inventory_ = block_inventory;
            this.inventory_.m_5856_(this.player_);
            Level world = this.player_.f_19853_;
            this.te_ = this.inventory_ instanceof Inventories.StorageInventory && ((Inventories.StorageInventory)this.inventory_).getTileEntity() instanceof CraftingTableTileEntity ? (CraftingTableTileEntity)((Inventories.StorageInventory)this.inventory_).getTileEntity() : null;
            this.crafting_grid_range_ = new Inventories.InventoryRange(this.inventory_, 0, 9, 3);
            this.block_storage_range_ = new Inventories.InventoryRange(this.inventory_, 9, 18, 2);
            this.crafting_result_range_ = new Inventories.InventoryRange(this.inventory_, 27, 1, 1);
            this.player_storage_range_ = Inventories.InventoryRange.fromPlayerStorage(this.player_);
            this.player_hotbar_range_ = Inventories.InventoryRange.fromPlayerHotbar(this.player_);
            this.player_inventory_range_ = Inventories.InventoryRange.fromPlayerInventory(this.player_);
            this.matrix_ = new CraftingTableGrid(this, this.inventory_);
            this.result_ = new CraftOutputInventory(this.crafting_result_range_);
            this.history_ = new CraftingHistory(world);
            this.crafting_output_slot_ = new CraftingOutputSlot(this, pinv.f_35978_, this.matrix_, this.result_, 0, 118, 27);
            this.m_38897_(this.crafting_output_slot_);
            ArrayList<Tuple> slotpositions = new ArrayList<Tuple>();
            slotpositions.add(new Tuple((Object)118, (Object)27));
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 3; ++x) {
                    int xpos = 44 + x * 18;
                    int ypos = 9 + y * 18;
                    this.m_38897_(new CraftingGridSlot((Container)this.matrix_, x + y * 3, xpos, ypos));
                    slotpositions.add(new Tuple((Object)xpos, (Object)ypos));
                }
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)pinv, x + y * 9 + 9, 8 + x * 18, 110 + y * 18));
                }
            }
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)pinv, x2, 8 + x2 * 18, 168));
            }
            for (y = 0; y < 2; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot(this.inventory_, 9 + x + y * 9, 8 + x * 18, 65 + y * 18));
                }
            }
            if (!this.player_.f_19853_.m_5776_() && this.te_ != null) {
                this.history_.read(this.te_.history.m_6426_());
            }
            this.CRAFTING_SLOT_COORDINATES = ImmutableList.copyOf(slotpositions);
            this.onCraftMatrixChanged();
        }

        public boolean m_6875_(Player player) {
            return this.inventory_.m_6542_(player);
        }

        public void onCraftMatrixChanged() {
            this.m_6199_((Container)this.matrix_);
        }

        public void m_6199_(Container inv) {
            this.wpc_.m_39292_((world, pos) -> {
                if (world.m_5776_()) {
                    return;
                }
                try {
                    this.crafting_matrix_changed_now_ = true;
                    ServerPlayer player = (ServerPlayer)this.player_;
                    ItemStack stack = ItemStack.f_41583_;
                    List recipes = world.m_142572_().m_129894_().m_44056_(RecipeType.f_44107_, (Container)this.matrix_, world);
                    this.has_recipe_collision_ = false;
                    if (recipes.size() > 0) {
                        CraftingRecipe recipe = (CraftingRecipe)recipes.get(0);
                        Recipe<?> currently_used = this.result_.m_7928_();
                        boolean bl = this.has_recipe_collision_ = recipes.size() > 1;
                        if (recipes.size() > 1 && currently_used instanceof CraftingRecipe && recipes.contains(currently_used)) {
                            recipe = (CraftingRecipe)currently_used;
                        }
                        if (this.result_.m_40135_((Level)world, player, (Recipe)recipe)) {
                            this.m_38946_();
                            stack = recipe.m_5874_((Container)this.matrix_);
                        }
                    }
                    this.result_.m_6836_(0, stack);
                    this.m_38946_();
                }
                catch (Throwable exc) {
                    ModEngineersDecor.logger().error("Recipe failed:", exc);
                }
            });
        }

        public void m_6877_(Player player) {
            this.inventory_.m_5785_(player);
        }

        public boolean m_5882_(ItemStack stack, Slot slot) {
            return slot.f_40218_ != this.result_ && super.m_5882_(stack, slot);
        }

        public ItemStack m_7648_(Player player, int index) {
            Slot slot = (Slot)this.f_38839_.get(index);
            if (slot == null || !slot.m_6657_()) {
                return ItemStack.f_41583_;
            }
            ItemStack slotstack = slot.m_7993_();
            ItemStack stack = slotstack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(slotstack, 10, 64, false)) {
                    return ItemStack.f_41583_;
                }
                this.wpc_.m_39292_((world, pos) -> slotstack.m_41720_().m_7836_(slotstack, world, player));
                slot.m_40234_(slotstack, stack);
            } else if (index >= 10 && index < 46 ? !this.m_38903_(slotstack, 46, 64, false) : (index >= 46 && index < 64 ? !this.m_38903_(slotstack, 10, 46, false) : !this.m_38903_(slotstack, 10, 46, false))) {
                return ItemStack.f_41583_;
            }
            if (slotstack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (index != 0 && slotstack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotstack);
            return stack;
        }

        public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
            this.crafting_matrix_changed_now_ = false;
            super.m_150399_(slotId, button, clickType, player);
            if (with_outslot_defined_refab && slotId == 0 && clickType == ClickType.PICKUP && !this.crafting_matrix_changed_now_ && !player.f_19853_.m_5776_() && this.crafting_grid_empty()) {
                ItemStack dragged = player.f_36095_.m_142621_();
                if (dragged != null && !dragged.m_41619_()) {
                    this.try_result_stack_refab(dragged, player.f_19853_);
                } else if (!this.history().current().isEmpty()) {
                    this.try_result_stack_refab(this.history().current_recipe().m_8043_(), player.f_19853_);
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message, CompoundTag nbt) {
            nbt.m_128359_("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundTag nbt) {
            if (nbt.m_128441_("history")) {
                this.history_.read(nbt.m_128469_("history"));
            }
            if (nbt.m_128441_("hascollision")) {
                this.has_recipe_collision_ = nbt.m_128471_("hascollision");
            }
            if (nbt.m_128441_("inventory")) {
                Inventories.readNbtStacks(nbt, "inventory", this.inventory_);
                this.m_6199_((Container)this.matrix_);
            }
        }

        @Override
        public void onClientPacketReceived(int windowId, Player player, CompoundTag nbt) {
            boolean changed = false;
            boolean player_inventory_changed = false;
            if (with_assist && nbt.m_128441_("action")) {
                switch (nbt.m_128461_("action")) {
                    case "next": {
                        this.history_.next();
                        if (this.crafting_grid_range_.move(this.block_storage_range_)) {
                            changed = true;
                        }
                        if (this.crafting_grid_range_.move(this.player_inventory_range_)) {
                            changed = true;
                            player_inventory_changed = true;
                        }
                        this.sync();
                        break;
                    }
                    case "prev": {
                        this.history_.prev();
                        if (this.crafting_grid_range_.move(this.block_storage_range_)) {
                            changed = true;
                        }
                        if (this.crafting_grid_range_.move(this.player_inventory_range_)) {
                            changed = true;
                            player_inventory_changed = true;
                        }
                        this.sync();
                        break;
                    }
                    case "clear": {
                        this.history_.reset_selection();
                        this.sync();
                        if (this.crafting_grid_range_.move(this.block_storage_range_)) {
                            changed = true;
                        }
                        if (!this.crafting_grid_range_.move(this.player_inventory_range_)) break;
                        changed = true;
                        player_inventory_changed = true;
                        break;
                    }
                    case "place-refab": {
                        if (this.place_stacks(new Inventories.InventoryRange[]{this.block_storage_range_, this.player_storage_range_, this.player_hotbar_range_}, this.refab_crafting_stacks()) == PlacementResult.UNCHANGED) break;
                        changed = true;
                        break;
                    }
                    case "place-stack": {
                        ItemStack stack;
                        int container_slot_id = nbt.m_128451_("containerslot");
                        if (container_slot_id < 10 || container_slot_id > 64) break;
                        if (container_slot_id >= 46) {
                            PlacementResult stat = this.distribute_stack(this.block_storage_range_, container_slot_id - 46);
                            if (stat == PlacementResult.UNCHANGED) break;
                            changed = true;
                            break;
                        }
                        int player_slot = container_slot_id >= 37 ? container_slot_id - 37 : container_slot_id - 10 + 9;
                        ItemStack reference_stack = player.m_150109_().m_8020_(player_slot).m_41777_();
                        if (reference_stack.m_41619_() || this.distribute_stack((Container)player.m_150109_(), player_slot) == PlacementResult.UNCHANGED) break;
                        player_inventory_changed = true;
                        changed = true;
                        if (!nbt.m_128441_("move-all")) break;
                        for (int i = 0; !(i >= player.m_150109_().m_6643_() || Inventories.areItemStacksIdentical(reference_stack, stack = player.m_150109_().m_8020_(i)) && this.distribute_stack((Container)player.m_150109_(), i) == PlacementResult.UNCHANGED); ++i) {
                        }
                        break;
                    }
                    case "move-stack": {
                        int container_slot_id = nbt.m_128451_("containerslot");
                        if (container_slot_id < 1 || container_slot_id >= 64 || container_slot_id >= 10) break;
                        ItemStack remaining = Inventories.insert(new Inventories.InventoryRange[]{this.block_storage_range_, this.player_storage_range_, this.player_hotbar_range_}, this.inventory_.m_8020_(container_slot_id - 1));
                        player_inventory_changed = remaining.m_41613_() != this.inventory_.m_8020_(container_slot_id - 1).m_41613_();
                        changed = player_inventory_changed;
                        this.inventory_.m_6836_(container_slot_id - 1, remaining);
                        break;
                    }
                    case "move-stacks": {
                        Inventories.InventoryRange[] to_ranges;
                        int from_slot;
                        Container from_inventory;
                        int container_slot_id = nbt.m_128451_("containerslot");
                        if (container_slot_id < 1 || container_slot_id >= 64) break;
                        if (container_slot_id < 10) {
                            if (this.crafting_grid_range_.move(this.player_inventory_range_, true)) {
                                this.crafting_grid_range_.move(this.player_inventory_range_, false, false, true);
                                changed = true;
                                player_inventory_changed = true;
                            }
                            if (this.crafting_grid_range_.move(this.block_storage_range_)) {
                                changed = true;
                            }
                            if (!this.crafting_grid_range_.move(this.player_inventory_range_, true)) break;
                            changed = true;
                            player_inventory_changed = true;
                            break;
                        }
                        if (container_slot_id >= 46) {
                            from_inventory = this.inventory_;
                            from_slot = container_slot_id - 46 + 9;
                            to_ranges = new Inventories.InventoryRange[]{this.player_storage_range_, this.player_hotbar_range_};
                        } else {
                            from_inventory = player.m_150109_();
                            from_slot = container_slot_id >= 37 ? container_slot_id - 37 : container_slot_id - 10 + 9;
                            to_ranges = new Inventories.InventoryRange[]{this.block_storage_range_};
                        }
                        ItemStack reference_stack = from_inventory.m_8020_(from_slot).m_41777_();
                        if (reference_stack.m_41619_()) break;
                        boolean abort = false;
                        for (int i = 0; i < from_inventory.m_6643_() && !abort; ++i) {
                            ItemStack stack = from_inventory.m_8020_(i);
                            if (Inventories.areItemStacksDifferent(reference_stack, stack)) continue;
                            ItemStack remaining = Inventories.insert(to_ranges, from_inventory.m_8020_(i));
                            player_inventory_changed = remaining.m_41613_() != from_inventory.m_8020_(i).m_41613_();
                            changed = player_inventory_changed;
                            from_inventory.m_6836_(i, remaining);
                        }
                        break;
                    }
                    case "next-recipe": {
                        this.select_next_collision_recipe(this.inventory_);
                        break;
                    }
                    case "dec-crafting-stacks": {
                        changed = player_inventory_changed = this.decrease_grid_stacks(new Inventories.InventoryRange[]{this.block_storage_range_, this.player_storage_range_, this.player_hotbar_range_}, Mth.m_14045_((int)nbt.m_128451_("limit"), (int)1, (int)8));
                        break;
                    }
                    case "inc-crafting-stacks": {
                        changed = player_inventory_changed = this.increase_grid_stacks(new Inventories.InventoryRange[]{this.block_storage_range_, this.player_storage_range_, this.player_hotbar_range_}, Mth.m_14045_((int)nbt.m_128451_("limit"), (int)1, (int)8));
                    }
                }
            }
            if (changed) {
                this.inventory_.m_6596_();
            }
            if (player_inventory_changed) {
                player.m_150109_().m_6596_();
            }
            if (changed || player_inventory_changed) {
                this.onCraftMatrixChanged();
                this.m_38946_();
            }
        }

        public CraftingHistory history() {
            return this.history_;
        }

        private void sync() {
            this.wpc_.m_39292_((world, pos) -> {
                if (world.m_5776_()) {
                    return;
                }
                this.inventory_.m_6596_();
                CompoundTag nbt = new CompoundTag();
                if (this.te_ != null) {
                    nbt.m_128365_("inventory", (Tag)this.te_.mainInventory().save(false));
                }
                if (with_assist) {
                    CompoundTag hist_nbt = this.history_.write();
                    if (this.te_ != null) {
                        this.te_.history = hist_nbt.m_6426_();
                    }
                    nbt.m_128365_("history", (Tag)hist_nbt);
                    nbt.m_128379_("hascollision", this.has_recipe_collision_);
                }
                Networking.PacketContainerSyncServerToClient.sendToListeners(world, this, nbt);
            });
        }

        public boolean has_recipe_collision() {
            return this.has_recipe_collision_;
        }

        public void select_next_collision_recipe(Container inv) {
            this.wpc_.m_39292_((world, pos) -> {
                if (world.f_46443_) {
                    return;
                }
                try {
                    ServerPlayer player = (ServerPlayer)this.player_;
                    List matching_recipes = world.m_142572_().m_129894_().m_44056_(RecipeType.f_44107_, (Container)this.matrix_, world);
                    if (matching_recipes.size() < 2) {
                        return;
                    }
                    Recipe currently_used = this.result_.m_7928_();
                    List usable_recipes = matching_recipes.stream().filter(r -> this.result_.m_40135_((Level)world, player, (Recipe)r)).sorted(Comparator.comparingInt(a -> a.m_6423_().hashCode())).collect(Collectors.toList());
                    for (int i = 0; i < usable_recipes.size(); ++i) {
                        if (usable_recipes.get(i) != currently_used) continue;
                        if (++i >= usable_recipes.size()) {
                            i = 0;
                        }
                        currently_used = (Recipe)usable_recipes.get(i);
                        ItemStack stack = ((CraftingRecipe)currently_used).m_5874_((Container)this.matrix_);
                        this.result_.m_6836_(0, stack);
                        this.result_.m_6029_(currently_used);
                        break;
                    }
                    this.onCraftMatrixChanged();
                }
                catch (Throwable exc) {
                    ModEngineersDecor.logger().error("Recipe failed:", exc);
                }
            });
        }

        @Nullable
        private CraftingRecipe find_first_recipe_for(Level world, ItemStack stack) {
            return world.m_142572_().m_129894_().m_44051_().stream().filter(r -> r.m_6671_() == RecipeType.f_44107_ && r.m_8043_().m_41656_(stack)).findFirst().orElse(null);
        }

        private Optional<ItemStack> search_inventory(ItemStack match_stack) {
            Inventories.InventoryRange[] search_ranges;
            for (Inventories.InventoryRange range : search_ranges = new Inventories.InventoryRange[]{this.block_storage_range_, this.player_storage_range_, this.player_hotbar_range_}) {
                for (int i = 0; i < range.m_6643_(); ++i) {
                    if (!Inventories.areItemStacksIdentical(range.m_8020_(i), match_stack)) continue;
                    return Optional.of(match_stack);
                }
            }
            return Optional.empty();
        }

        private Optional<ItemStack> search_inventory(ItemStack[] match_stacks) {
            for (ItemStack match_stack : match_stacks) {
                Optional<ItemStack> stack = this.search_inventory(match_stack);
                if (!stack.isPresent()) continue;
                return stack;
            }
            return Optional.empty();
        }

        private ArrayList<ItemStack> placement_stacks(CraftingRecipe recipe) {
            ArrayList<ItemStack> grid;
            block13: {
                block12: {
                    int w;
                    Level world = this.player_.f_19853_;
                    grid = new ArrayList<ItemStack>();
                    if (recipe.m_7527_().size() > 9) {
                        return grid;
                    }
                    if (!(recipe instanceof ShapedRecipe)) break block12;
                    int endw = ((ShapedRecipe)recipe).m_44220_();
                    int endh = ((ShapedRecipe)recipe).m_44221_();
                    int ingredient_index = 0;
                    for (int i = 3 - endh; i > 0; --i) {
                        for (w = 0; w < 3; ++w) {
                            grid.add(ItemStack.f_41583_);
                        }
                    }
                    for (int h = 3 - endh; h < 3; ++h) {
                        for (w = 0; w < 3; ++w) {
                            if (w >= endw || ingredient_index >= recipe.m_7527_().size()) {
                                grid.add(ItemStack.f_41583_);
                                continue;
                            }
                            ItemStack[] match_stacks = ((Ingredient)recipe.m_7527_().get(ingredient_index++)).m_43908_();
                            if (match_stacks.length == 0) {
                                grid.add(ItemStack.f_41583_);
                                continue;
                            }
                            ItemStack preferred = this.search_inventory(match_stacks).orElse(match_stacks[0]);
                            if (preferred.m_41619_()) {
                                grid.add(ItemStack.f_41583_);
                                continue;
                            }
                            grid.add(preferred);
                        }
                    }
                    break block13;
                }
                if (!(recipe instanceof ShapelessRecipe)) break block13;
                for (int ingredient_index = 0; ingredient_index < recipe.m_7527_().size(); ++ingredient_index) {
                    ItemStack[] match_stacks = ((Ingredient)recipe.m_7527_().get(ingredient_index)).m_43908_();
                    if (match_stacks.length == 0) {
                        grid.add(ItemStack.f_41583_);
                        continue;
                    }
                    ItemStack preferred = this.search_inventory(match_stacks).orElse(match_stacks[0]);
                    if (preferred.m_41619_()) {
                        grid.add(ItemStack.f_41583_);
                        continue;
                    }
                    grid.add(preferred);
                }
                while (grid.size() < 9) {
                    grid.add(ItemStack.f_41583_);
                }
            }
            return grid;
        }

        private boolean adapt_recipe_placement(CraftingRecipe recipe, List<ItemStack> grid_stacks) {
            boolean changed = false;
            NonNullList ingredients = recipe.m_7527_();
            for (int stack_index = 0; stack_index < grid_stacks.size(); ++stack_index) {
                ItemStack to_replace;
                ItemStack replacement = to_replace = grid_stacks.get(stack_index);
                if (to_replace.m_41619_() || this.search_inventory(to_replace).isPresent()) continue;
                for (int ingredient_index = 0; ingredient_index < recipe.m_7527_().size(); ++ingredient_index) {
                    ItemStack[] match_stacks = ((Ingredient)recipe.m_7527_().get(ingredient_index)).m_43908_();
                    if (!Arrays.stream(match_stacks).anyMatch(s -> Inventories.areItemStacksIdentical(s, to_replace))) continue;
                    replacement = this.search_inventory(match_stacks).orElse(to_replace);
                    changed = true;
                    break;
                }
                grid_stacks.set(stack_index, replacement);
            }
            return changed;
        }

        private void try_result_stack_refab(ItemStack output_stack, Level world) {
            CraftingRecipe recipe;
            int history_index = this.history().find(output_stack);
            if (history_index >= 0) {
                this.history().selection(history_index);
                recipe = this.history().current_recipe();
                List<ItemStack> grid_stacks = this.history().current().subList(1, this.history().current().size());
                if (this.adapt_recipe_placement(recipe, grid_stacks)) {
                    this.history().stash(grid_stacks, recipe);
                    recipe = this.history().current_recipe();
                }
            } else {
                recipe = this.find_first_recipe_for(world, output_stack);
                if (recipe != null) {
                    ArrayList<ItemStack> stacks = this.placement_stacks(recipe);
                    if (stacks.isEmpty()) {
                        recipe = null;
                    } else {
                        this.history().stash(stacks, recipe);
                        recipe = this.history().current_recipe();
                    }
                }
            }
            if (recipe != null) {
                this.sync();
                this.onCraftMatrixChanged();
            }
        }

        private boolean crafting_grid_empty() {
            for (int i = 0; i < 10; ++i) {
                if (!this.m_38853_(i).m_6657_()) continue;
                return false;
            }
            return true;
        }

        private boolean itemstack_recipe_match(ItemStack grid_stack, ItemStack history_stack) {
            if (this.history_.current_recipe() != null) {
                NonNullList ingredients = this.history_.current_recipe().m_7527_();
                for (Ingredient ingredient : ingredients) {
                    boolean grid_match = false;
                    boolean dist_match = false;
                    for (ItemStack match : ingredient.m_43908_()) {
                        if (match.m_41726_(grid_stack)) {
                            dist_match = true;
                        }
                        if (match.m_41726_(history_stack)) {
                            grid_match = true;
                        }
                        if (!dist_match || !grid_match) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private List<ItemStack> refab_crafting_stacks() {
            int i;
            ArrayList<ItemStack> slots = new ArrayList<ItemStack>();
            List<ItemStack> tocraft = this.history_.current();
            int[] stack_sizes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
            if (tocraft.isEmpty()) {
                return slots;
            }
            for (int i2 = 0; i2 < 9 && i2 + 1 < tocraft.size(); ++i2) {
                ItemStack needed = tocraft.get(i2 + 1);
                ItemStack palced = this.inventory_.m_8020_(i2 + 0);
                if (needed.m_41619_() && !palced.m_41619_()) {
                    return slots;
                }
                if (!palced.m_41619_() && !this.itemstack_recipe_match(needed, palced)) {
                    return slots;
                }
                if (needed.m_41619_()) continue;
                stack_sizes[i2] = palced.m_41613_();
            }
            int min_placed = 64;
            int max_placed = 0;
            for (int i3 = 0; i3 < 9; ++i3) {
                if (stack_sizes[i3] < 0) continue;
                min_placed = Math.min(min_placed, stack_sizes[i3]);
                max_placed = Math.max(max_placed, stack_sizes[i3]);
            }
            int fillup_size = max_placed <= min_placed ? min_placed + 1 : max_placed;
            for (i = 0; i < 9; ++i) {
                if (stack_sizes[i] < 0 || fillup_size <= this.inventory_.m_8020_(i + 0).m_41741_()) continue;
                return slots;
            }
            for (i = 0; i < 9; ++i) {
                if (stack_sizes[i] < 0) {
                    slots.add(ItemStack.f_41583_);
                    continue;
                }
                ItemStack st = this.inventory_.m_8020_(i + 0).m_41777_();
                if (st.m_41619_()) {
                    st = tocraft.get(i + 1).m_41777_();
                    st.m_41764_(Math.min(st.m_41741_(), fillup_size));
                } else {
                    st.m_41764_(Mth.m_14045_((int)(fillup_size - st.m_41613_()), (int)0, (int)st.m_41741_()));
                }
                slots.add(st);
            }
            return slots;
        }

        private List<ItemStack> incr_crafting_grid_stacks(int count) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                ItemStack palced = this.crafting_grid_range_.m_8020_(i).m_41777_();
                if (!palced.m_41619_()) {
                    palced.m_41764_(count);
                }
                stacks.add(palced);
            }
            return stacks;
        }

        private PlacementResult place_stacks(Inventories.InventoryRange[] ranges, List<ItemStack> to_fill) {
            if (this.history_.current_recipe() != null) {
                this.result_.m_6029_((Recipe<?>)this.history_.current_recipe());
            }
            boolean slots_changed = false;
            if (!to_fill.isEmpty()) {
                block0: for (Inventories.InventoryRange slot_range : ranges) {
                    for (int it_guard = 63; it_guard >= 0; --it_guard) {
                        boolean slots_updated = false;
                        for (int i = 0; i < 9; ++i) {
                            ItemStack grid_stack;
                            if (to_fill.get(i).m_41619_() || (grid_stack = this.crafting_grid_range_.m_8020_(i).m_41777_()).m_41613_() >= grid_stack.m_41741_()) continue;
                            ItemStack req_stack = to_fill.get(i).m_41777_();
                            req_stack.m_41764_(1);
                            ItemStack mv_stack = slot_range.extract(req_stack);
                            if (mv_stack.m_41619_()) continue;
                            to_fill.get(i).m_41774_(1);
                            if (grid_stack.m_41619_()) {
                                grid_stack = mv_stack.m_41777_();
                            } else {
                                grid_stack.m_41769_(mv_stack.m_41613_());
                            }
                            this.crafting_grid_range_.m_6836_(i, grid_stack);
                            slots_changed = true;
                            slots_updated = true;
                        }
                        if (!slots_updated) continue block0;
                    }
                }
            }
            boolean missing_item = false;
            for (ItemStack st : to_fill) {
                if (st.m_41619_()) continue;
                missing_item = true;
                break;
            }
            if (!slots_changed) {
                return PlacementResult.UNCHANGED;
            }
            if (missing_item) {
                return PlacementResult.INCOMPLETE;
            }
            return PlacementResult.PLACED;
        }

        private PlacementResult distribute_stack(Container inventory, int slot_index) {
            ItemStack to_distribute;
            List<ItemStack> to_refab = this.refab_crafting_stacks();
            if (this.history_.current_recipe() != null) {
                this.result_.m_6029_((Recipe<?>)this.history_.current_recipe());
            }
            if ((to_distribute = inventory.m_8020_(slot_index).m_41777_()).m_41619_()) {
                return PlacementResult.UNCHANGED;
            }
            int[] matching_grid_stack_sizes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
            int max_matching_stack_size = -1;
            int min_matching_stack_size = 65;
            int total_num_missing_stacks = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack refab_stack;
                ItemStack grid_stack = this.crafting_grid_range_.m_8020_(i);
                ItemStack itemStack = refab_stack = to_refab.isEmpty() ? ItemStack.f_41583_ : to_refab.get(i).m_41777_();
                if (!grid_stack.m_41619_() && Inventories.areItemStacksIdentical(grid_stack, to_distribute)) {
                    matching_grid_stack_sizes[i] = grid_stack.m_41613_();
                    total_num_missing_stacks += grid_stack.m_41741_() - grid_stack.m_41613_();
                    if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                        max_matching_stack_size = matching_grid_stack_sizes[i];
                    }
                    if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                    min_matching_stack_size = matching_grid_stack_sizes[i];
                    continue;
                }
                if (!refab_stack.m_41619_() && Inventories.areItemStacksIdentical(refab_stack, to_distribute)) {
                    matching_grid_stack_sizes[i] = 0;
                    total_num_missing_stacks += grid_stack.m_41741_();
                    if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                        max_matching_stack_size = matching_grid_stack_sizes[i];
                    }
                    if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                    min_matching_stack_size = matching_grid_stack_sizes[i];
                    continue;
                }
                if (!grid_stack.m_41619_() || refab_stack.m_41619_() || !this.itemstack_recipe_match(to_distribute, refab_stack)) continue;
                matching_grid_stack_sizes[i] = 0;
                total_num_missing_stacks += grid_stack.m_41741_();
                if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                    max_matching_stack_size = matching_grid_stack_sizes[i];
                }
                if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                min_matching_stack_size = matching_grid_stack_sizes[i];
            }
            if (min_matching_stack_size < 0) {
                return PlacementResult.UNCHANGED;
            }
            int stack_limit_size = Math.min(to_distribute.m_41741_(), this.crafting_grid_range_.m_6893_());
            if (min_matching_stack_size >= stack_limit_size) {
                return PlacementResult.UNCHANGED;
            }
            int n_to_distribute = to_distribute.m_41613_();
            for (int it_guard = 63; it_guard >= 0 && n_to_distribute > 0; --it_guard) {
                for (int i = 0; i < 9 && n_to_distribute > 0; ++i) {
                    if (matching_grid_stack_sizes[i] != min_matching_stack_size) continue;
                    int n = i;
                    matching_grid_stack_sizes[n] = matching_grid_stack_sizes[n] + 1;
                    --n_to_distribute;
                }
                if (min_matching_stack_size < max_matching_stack_size) {
                    ++min_matching_stack_size;
                } else {
                    max_matching_stack_size = ++min_matching_stack_size;
                }
                if (min_matching_stack_size >= stack_limit_size) break;
            }
            if (n_to_distribute == to_distribute.m_41613_()) {
                return PlacementResult.UNCHANGED;
            }
            if (n_to_distribute <= 0) {
                inventory.m_6836_(slot_index, ItemStack.f_41583_);
            } else {
                to_distribute.m_41764_(n_to_distribute);
                inventory.m_6836_(slot_index, to_distribute);
            }
            for (int i = 0; i < 9; ++i) {
                if (matching_grid_stack_sizes[i] < 0) continue;
                ItemStack grid_stack = this.crafting_grid_range_.m_8020_(i).m_41777_();
                if (grid_stack.m_41619_()) {
                    grid_stack = to_distribute.m_41777_();
                }
                grid_stack.m_41764_(matching_grid_stack_sizes[i]);
                this.crafting_grid_range_.m_6836_(i, grid_stack);
            }
            return PlacementResult.PLACED;
        }

        private boolean decrease_grid_stacks(Inventories.InventoryRange[] ranges, int limit) {
            boolean changed = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.crafting_grid_range_.m_8020_(i).m_41777_();
                if (stack.m_41619_()) continue;
                for (Inventories.InventoryRange range : ranges) {
                    ItemStack remaining = range.insert(stack, false, limit, false, false);
                    if (remaining.m_41613_() < stack.m_41613_()) {
                        changed = true;
                    }
                    boolean stop = remaining.m_41613_() <= Math.max(0, stack.m_41613_() - limit);
                    stack = remaining;
                    if (stop) break;
                }
                this.crafting_grid_range_.m_6836_(i, stack.m_41619_() ? ItemStack.f_41583_ : stack);
            }
            return changed;
        }

        private boolean increase_grid_stacks(Inventories.InventoryRange[] ranges, int limit) {
            return this.place_stacks(ranges, this.incr_crafting_grid_stacks(limit)) != PlacementResult.UNCHANGED;
        }
    }

    public static class CraftingTableTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements MenuProvider,
    Nameable,
    Networking.IPacketTileNotifyReceiver {
        public static final int NUM_OF_STORAGE_SLOTS = 18;
        public static final int NUM_OF_STORAGE_ROWS = 2;
        public static final int NUM_OF_SLOTS = 28;
        public static final int CRAFTING_RESULT_SLOT = 27;
        protected Inventories.StorageInventory inventory_;
        protected CompoundTag history = new CompoundTag();

        public CraftingTableTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_CRAFTING_TABLE, pos, state);
            this.inventory_ = new Inventories.StorageInventory(this, 28, 1);
            this.inventory_.setCloseAction(player -> {
                if (this.m_58904_() instanceof Level) {
                    this.scheduleSync();
                    this.m_58904_().m_7260_(this.m_58899_(), state, state, 19);
                }
            });
            this.inventory_.setSlotChangeAction((slot_index, stack) -> {
                if (slot_index < 9) {
                    this.scheduleSync();
                }
            });
        }

        public void reset() {
            this.inventory_.m_6211_();
        }

        public void readnbt(CompoundTag nbt) {
            this.reset();
            this.inventory_.load(nbt);
            this.history = nbt.m_128469_("history");
        }

        private void writenbt(CompoundTag nbt) {
            this.inventory_.save(nbt);
            if (!this.history.m_128456_()) {
                nbt.m_128365_("history", (Tag)this.history);
            }
        }

        public Inventories.StorageInventory mainInventory() {
            return this.inventory_;
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        public CompoundTag m_6945_(CompoundTag nbt) {
            super.m_6945_(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public CompoundTag m_5995_() {
            CompoundTag nbt = super.m_5995_();
            this.writenbt(nbt);
            return nbt;
        }

        @Nullable
        public ClientboundBlockEntityDataPacket m_7033_() {
            return new ClientboundBlockEntityDataPacket(this.f_58858_, 1, this.m_5995_());
        }

        public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
            this.readnbt(pkt.m_131708_());
            super.onDataPacket(net, pkt);
        }

        public void handleUpdateTag(CompoundTag tag) {
            this.m_142466_(tag);
        }

        @OnlyIn(value=Dist.CLIENT)
        public double getViewDistance() {
            return 400.0;
        }

        public Component m_7755_() {
            Block block = this.m_58900_().m_60734_();
            return new TextComponent(block != null ? block.m_7705_() : "Treated wood crafting table");
        }

        public boolean m_8077_() {
            return false;
        }

        public Component m_7770_() {
            return this.m_7755_();
        }

        public Component m_5446_() {
            return super.m_5446_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new CraftingTableUiContainer(id, inventory, this.inventory_, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
        }

        @Override
        public void onServerPacketReceived(CompoundTag nbt) {
            this.readnbt(nbt);
        }

        public void sync() {
            if (this.m_58904_().m_5776_()) {
                return;
            }
            CompoundTag nbt = new CompoundTag();
            this.writenbt(nbt);
            Networking.PacketTileNotifyServerToClient.sendToPlayers(this, nbt);
        }

        public void scheduleSync() {
            if (this.f_58857_.m_5776_()) {
                return;
            }
            Block crafting_table_block = this.m_58900_().m_60734_();
            if (!(crafting_table_block instanceof CraftingTableBlock)) {
                return;
            }
            if (this.f_58857_.m_6219_().m_5916_(this.m_58899_(), (Object)crafting_table_block)) {
                return;
            }
            this.f_58857_.m_6219_().m_7663_(this.m_58899_(), (Object)crafting_table_block, 10, TickPriority.LOW);
        }
    }

    public static final class CraftingTableBlock
    extends StandardBlocks.HorizontalWaterLoggable
    implements StandardEntityBlocks.IStandardEntityBlock<CraftingTableTileEntity> {
        public CraftingTableBlock(long config, BlockBehaviour.Properties builder, AABB[] unrotatedAABBs) {
            super(config, builder, unrotatedAABBs);
        }

        @Override
        @Nullable
        public BlockEntityType<CraftingTableTileEntity> getBlockEntityType() {
            return ModContent.TET_CRAFTING_TABLE;
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            return this.useOpenGui(state, world, pos, player);
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.f_46443_) {
                return;
            }
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("inventory")) {
                return;
            }
            CompoundTag inventory_nbt = stack.m_41783_().m_128469_("inventory");
            if (inventory_nbt.m_128456_()) {
                return;
            }
            BlockEntity blockEntity = world.m_7702_(pos);
            if (!(blockEntity instanceof CraftingTableTileEntity)) {
                return;
            }
            CraftingTableTileEntity te = (CraftingTableTileEntity)blockEntity;
            te.readnbt(inventory_nbt);
            te.m_6596_();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.f_46443_) {
                return stacks;
            }
            if (!(te instanceof CraftingTableTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((ItemLike)this, 1);
                CompoundTag inventory_nbt = new CompoundTag();
                ((CraftingTableTileEntity)te).mainInventory().save(inventory_nbt, false);
                if (!inventory_nbt.m_128456_()) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128365_("inventory", (Tag)inventory_nbt);
                    stack.m_41751_(nbt);
                }
                ((CraftingTableTileEntity)te).mainInventory().m_6211_();
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((CraftingTableTileEntity)te).mainInventory()) {
                    if (stack.m_41619_()) continue;
                    stacks.add(stack);
                }
                ((CraftingTableTileEntity)te).reset();
            }
            return stacks;
        }

        public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof CraftingTableTileEntity)) {
                return;
            }
            ((CraftingTableTileEntity)te).sync();
        }
    }
}

