/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.EdStraightPoleBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Inventories;

public class EdHorizontalSupportBlock
extends StandardBlocks.WaterLoggable {
    public static final BooleanProperty EASTWEST = BooleanProperty.m_61465_((String)"eastwest");
    public static final BooleanProperty LEFTBEAM = BooleanProperty.m_61465_((String)"leftbeam");
    public static final BooleanProperty RIGHTBEAM = BooleanProperty.m_61465_((String)"rightbeam");
    public static final IntegerProperty DOWNCONNECT = IntegerProperty.m_61631_((String)"downconnect", (int)0, (int)2);
    protected final Map<BlockState, VoxelShape> AABBs;

    public EdHorizontalSupportBlock(long config, BlockBehaviour.Properties builder, AABB mainBeamAABB, AABB eastBeamAABB, AABB thinDownBeamAABB, AABB thickDownBeamAABB) {
        super(config | 0x10L, builder);
        HashMap<BlockState, VoxelShape> aabbs = new HashMap<BlockState, VoxelShape>();
        Iterator iterator = EASTWEST.m_6908_().iterator();
        while (iterator.hasNext()) {
            boolean eastwest = (Boolean)iterator.next();
            Iterator iterator2 = LEFTBEAM.m_6908_().iterator();
            while (iterator2.hasNext()) {
                boolean leftbeam = (Boolean)iterator2.next();
                Iterator iterator3 = RIGHTBEAM.m_6908_().iterator();
                while (iterator3.hasNext()) {
                    boolean rightbeam = (Boolean)iterator3.next();
                    Iterator iterator4 = DOWNCONNECT.m_6908_().iterator();
                    while (iterator4.hasNext()) {
                        int downconnect = (Integer)iterator4.next();
                        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf(eastwest))).m_61124_((Property)LEFTBEAM, (Comparable)Boolean.valueOf(leftbeam))).m_61124_((Property)RIGHTBEAM, (Comparable)Boolean.valueOf(rightbeam))).m_61124_((Property)DOWNCONNECT, (Comparable)Integer.valueOf(downconnect));
                        VoxelShape shape = Shapes.m_83064_((AABB)Auxiliaries.getRotatedAABB(mainBeamAABB, eastwest ? Direction.EAST : Direction.NORTH, true));
                        if (rightbeam) {
                            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)Auxiliaries.getRotatedAABB(eastBeamAABB, eastwest ? Direction.EAST : Direction.NORTH, true)), (BooleanOp)BooleanOp.f_82695_);
                        }
                        if (leftbeam) {
                            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)Auxiliaries.getRotatedAABB(eastBeamAABB, eastwest ? Direction.WEST : Direction.SOUTH, true)), (BooleanOp)BooleanOp.f_82695_);
                        }
                        if (downconnect == 1) {
                            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)thinDownBeamAABB), (BooleanOp)BooleanOp.f_82695_);
                        }
                        if (downconnect == 2) {
                            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)thickDownBeamAABB), (BooleanOp)BooleanOp.f_82695_);
                        }
                        aabbs.put((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), shape);
                        aabbs.put((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), shape);
                    }
                }
            }
        }
        this.AABBs = aabbs;
    }

    @Override
    public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
        return StandardBlocks.IStandardBlock.RenderTypeHint.CUTOUT;
    }

    @Override
    public boolean m_5568_() {
        return false;
    }

    public boolean canCreatureSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
        return this.AABBs.get(state);
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.m_5940_(state, world, pos, selectionContext);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{EASTWEST, RIGHTBEAM, LEFTBEAM, DOWNCONNECT});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.temp_block_update_until_better((BlockState)super.m_5573_(context).m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf(context.m_8125_().m_122434_() == Direction.Axis.X)), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    private BlockState temp_block_update_until_better(BlockState state, LevelAccessor world, BlockPos pos) {
        boolean ew = (Boolean)state.m_61143_((Property)EASTWEST);
        BlockState rstate = world.m_8055_(!ew ? pos.m_142126_() : pos.m_142128_());
        BlockState lstate = world.m_8055_(!ew ? pos.m_142125_() : pos.m_142127_());
        BlockState dstate = world.m_8055_(pos.m_7495_());
        int down_connector = 0;
        Block block = dstate.m_60734_();
        if (block instanceof EdStraightPoleBlock) {
            EdStraightPoleBlock pole = (EdStraightPoleBlock)block;
            Direction dfacing = (Direction)dstate.m_61143_((Property)EdStraightPoleBlock.FACING);
            if (dfacing.m_122434_() == Direction.Axis.Y) {
                if (pole == ModContent.THICK_STEEL_POLE || pole == ModContent.THICK_STEEL_POLE_HEAD && dfacing == Direction.UP) {
                    down_connector = 2;
                } else if (pole == ModContent.THIN_STEEL_POLE || pole == ModContent.THIN_STEEL_POLE_HEAD && dfacing == Direction.UP) {
                    down_connector = 1;
                }
            }
        }
        return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)RIGHTBEAM, (Comparable)Boolean.valueOf(rstate.m_60734_() == this && (Boolean)rstate.m_61143_((Property)EASTWEST) != ew))).m_61124_((Property)LEFTBEAM, (Comparable)Boolean.valueOf(lstate.m_60734_() == this && (Boolean)lstate.m_61143_((Property)EASTWEST) != ew))).m_61124_((Property)DOWNCONNECT, (Comparable)Integer.valueOf(down_connector));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return this.temp_block_update_until_better(state, world, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DirectionalPlaceContext ctx;
        ItemStack held_stack = player.m_21120_(hand);
        if (held_stack.m_41619_() || held_stack.m_41720_() != this.m_5456_()) {
            return InteractionResult.PASS;
        }
        if (!hit.m_82434_().m_122434_().m_122478_()) {
            return InteractionResult.PASS;
        }
        Direction placement_direction = player.m_6350_();
        BlockPos adjacent_pos = pos.m_142300_(placement_direction);
        BlockState adjacent = world.m_8055_(adjacent_pos);
        if (!adjacent.m_60629_((BlockPlaceContext)(ctx = new DirectionalPlaceContext(world, adjacent_pos, placement_direction, player.m_21120_(hand), placement_direction.m_122424_())))) {
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        BlockState new_state = this.m_5573_((BlockPlaceContext)ctx);
        if (new_state == null) {
            return InteractionResult.FAIL;
        }
        if (!world.m_7731_(adjacent_pos, new_state, 3)) {
            return InteractionResult.FAIL;
        }
        world.m_5594_(player, pos, SoundEvents.f_12065_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!player.m_7500_()) {
            held_stack.m_41774_(1);
            Inventories.setItemInPlayerHand(player, hand, held_stack);
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return rot == Rotation.CLOCKWISE_180 ? state : (BlockState)state.m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)EASTWEST) == false));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state;
    }
}

