/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.StandardEntityBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.RsSignals;
import wile.engineersdecor.libmc.ui.Guis;

public class EdLabeledCrate {
    private static boolean with_gui_mouse_handling = true;
    private static final HashSet<Item> unstorable_containers = new HashSet();

    public static void on_config(boolean without_gui_mouse_handling) {
        with_gui_mouse_handling = !without_gui_mouse_handling;
        unstorable_containers.clear();
        unstorable_containers.add(ModContent.LABELED_CRATE.m_5456_());
        unstorable_containers.add(Items.f_42265_);
        ModConfig.log("Config crate: unstorable:" + unstorable_containers.stream().map(e -> e.getRegistryName().toString()).collect(Collectors.joining(",")));
    }

    public static class LabeledCrateBlock
    extends StandardBlocks.Horizontal
    implements StandardEntityBlocks.IStandardEntityBlock<LabeledCrateTileEntity> {
        public LabeledCrateBlock(long config, BlockBehaviour.Properties builder, AABB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        @Nullable
        public BlockEntityType<LabeledCrateTileEntity> getBlockEntityType() {
            return ModContent.TET_LABELED_CRATE;
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
            int n;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (!(blockEntity instanceof LabeledCrateTileEntity)) {
                n = 0;
            } else {
                LabeledCrateTileEntity te = (LabeledCrateTileEntity)blockEntity;
                n = RsSignals.fromContainer(te.main_inventory_);
            }
            return n;
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            CompoundTag te_nbt;
            if (world.f_46443_ || !stack.m_41782_()) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof LabeledCrateTileEntity)) {
                return;
            }
            CompoundTag nbt = stack.m_41783_();
            if (nbt.m_128441_("tedata") && !(te_nbt = nbt.m_128469_("tedata")).m_128456_()) {
                ((LabeledCrateTileEntity)te).readnbt(te_nbt);
            }
            ((LabeledCrateTileEntity)te).setCustomName(Auxiliaries.getItemLabel(stack));
            te.m_6596_();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.m_5776_()) {
                return stacks;
            }
            if (!(te instanceof LabeledCrateTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((ItemLike)this, 1);
                CompoundTag te_nbt = ((LabeledCrateTileEntity)te).getnbt();
                CompoundTag nbt = new CompoundTag();
                if (!te_nbt.m_128456_()) {
                    nbt.m_128365_("tedata", (Tag)te_nbt);
                }
                if (!nbt.m_128456_()) {
                    stack.m_41751_(nbt);
                }
                Auxiliaries.setItemLabel(stack, ((LabeledCrateTileEntity)te).m_7770_());
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((LabeledCrateTileEntity)te).main_inventory_) {
                    stacks.add(stack);
                }
                ((LabeledCrateTileEntity)te).getnbt();
            }
            return stacks;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            return this.useOpenGui(state, world, pos, player);
        }

        @Override
        public PushReaction m_5537_(BlockState state) {
            return PushReaction.BLOCK;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
            String[] lines;
            CompoundTag nbt;
            if (!Auxiliaries.Tooltip.extendedTipCondition() || Auxiliaries.Tooltip.helpCondition()) {
                super.m_5871_(stack, world, tooltip, flag);
                return;
            }
            ItemStack frameStack = ItemStack.f_41583_;
            int num_used_slots = 0;
            int total_items = 0;
            Object stats = "";
            if (stack.m_41782_() && stack.m_41783_().m_128441_("tedata") && (nbt = stack.m_41783_().m_128469_("tedata")).m_128441_("Items")) {
                NonNullList<ItemStack> all_items = Inventories.readNbtStacks(nbt, "Items", 55);
                frameStack = (ItemStack)all_items.get(54);
                all_items.set(54, (Object)ItemStack.f_41583_);
                HashMap<Item, Integer> item_map = new HashMap<Item, Integer>();
                for (Object e2 : all_items) {
                    if (e2.m_41619_()) continue;
                    item_map.put(e2.m_41720_(), item_map.getOrDefault(e2.m_41720_(), 0) + e2.m_41613_());
                    ++num_used_slots;
                    total_items += e2.m_41613_();
                }
                ArrayList<Tuple> itmes = new ArrayList<Tuple>();
                for (Map.Entry e3 : item_map.entrySet()) {
                    itmes.add(new Tuple((Object)((Item)e3.getKey()).m_5524_(), (Object)((Integer)e3.getValue())));
                }
                itmes.sort((a, b) -> (Integer)b.m_14419_() - (Integer)a.m_14419_());
                boolean dotdotdot = false;
                if (itmes.size() > 8) {
                    itmes.subList(8, itmes.size()).clear();
                    dotdotdot = true;
                }
                stats = itmes.stream().map(e -> Auxiliaries.localize((String)e.m_14418_(), new Object[0])).collect(Collectors.joining(", "));
                if (dotdotdot) {
                    stats = (String)stats + "...";
                }
            }
            int num_free_slots = 54 - num_used_slots;
            for (String line : lines = Auxiliaries.localize(this.m_7705_() + ".tip", frameStack.m_41619_() ? new TextComponent("-/-") : new TranslatableComponent(frameStack.m_41778_()), num_used_slots, num_free_slots, total_items, stats).split("\n")) {
                tooltip.add((Component)new TextComponent(line.trim()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LabeledCrateGui
    extends Guis.ContainerGui<LabeledCrateContainer> {
        public LabeledCrateGui(LabeledCrateContainer container, Inventory player_inventory, Component title) {
            super(container, player_inventory, title, "textures/gui/labeled_crate_gui.png", 213, 206);
            this.f_97728_ = 23;
            this.f_97729_ = -10;
        }

        @Override
        protected void m_7027_(PoseStack mx, int x, int y) {
            this.f_96547_.m_92889_(mx, this.f_96539_, (float)this.f_97728_ + 1.0f, (float)this.f_97729_ + 1.0f, 0x303030);
            this.f_96547_.m_92889_(mx, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x707070);
        }

        protected void action(String message) {
            this.action(message, new CompoundTag());
        }

        protected void action(String message, CompoundTag nbt) {
            ((LabeledCrateContainer)this.m_6262_()).onGuiAction(message, nbt);
        }

        protected void m_6597_(Slot slot, int slotId, int button, ClickType type) {
            if (!with_gui_mouse_handling) {
                super.m_6597_(slot, slotId, button, type);
            } else if (type == ClickType.QUICK_MOVE && slot != null && slot.m_6657_() && Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("slot", slotId);
                this.action("quick-move-all", nbt);
            } else {
                super.m_6597_(slot, slotId, button, type);
            }
        }

        public boolean m_6050_(double mouseX, double mouseY, double wheel_inc) {
            if (!with_gui_mouse_handling) {
                return super.m_6050_(mouseX, mouseY, wheel_inc);
            }
            Slot slot = this.getSlotUnderMouse();
            if (slot == null || !slot.m_6657_()) {
                return true;
            }
            int count = slot.m_7993_().m_41613_();
            int limit = (Auxiliaries.isShiftDown() ? 2 : 1) * (Auxiliaries.isCtrlDown() ? 4 : 1);
            if (wheel_inc > 0.1) {
                if (count > 0 && count < slot.m_7993_().m_41741_() && count < slot.m_6641_()) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128405_("slot", slot.f_40219_);
                    if (limit > 1) {
                        nbt.m_128405_("limit", limit);
                    }
                    this.action("increase-stack", nbt);
                }
            } else if (wheel_inc < -0.1 && count > 0) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("slot", slot.f_40219_);
                if (limit > 1) {
                    nbt.m_128405_("limit", limit);
                }
                this.action("decrease-stack", nbt);
            }
            return true;
        }
    }

    public static class LabeledCrateContainer
    extends AbstractContainerMenu
    implements Networking.INetworkSynchronisableContainer {
        protected static final String QUICK_MOVE_ALL = "quick-move-all";
        protected static final String INCREASE_STACK = "increase-stack";
        protected static final String DECREASE_STACK = "decrease-stack";
        private static final int PLAYER_INV_START_SLOTNO = 55;
        private static final int NUM_OF_CONTAINER_SLOTS = 91;
        protected static final int STORAGE_SLOT_BEGIN = 0;
        protected static final int STORAGE_SLOT_END = 54;
        protected static final int PLAYER_SLOT_BEGIN = 55;
        protected static final int PLAYER_SLOT_END = 91;
        protected final Player player_;
        protected final Container inventory_;
        protected final ContainerLevelAccess wpc_;
        private final ContainerData fields_;
        private final Inventories.InventoryRange player_inventory_range_;
        private final Inventories.InventoryRange block_storage_range_;
        private final Inventories.InventoryRange frame_slot_range_;

        public int field(int index) {
            return this.fields_.m_6413_(index);
        }

        public Player player() {
            return this.player_;
        }

        public Container inventory() {
            return this.inventory_;
        }

        public Level world() {
            return this.player_.f_19853_;
        }

        public LabeledCrateContainer(int cid, Inventory player_inventory) {
            this(cid, player_inventory, (Container)new SimpleContainer(55), ContainerLevelAccess.f_39287_, (ContainerData)new SimpleContainerData(1));
        }

        private LabeledCrateContainer(int cid, Inventory player_inventory, Container block_inventory, ContainerLevelAccess wpc, ContainerData fields) {
            super(ModContent.CT_LABELED_CRATE, cid);
            int x;
            int y;
            this.player_ = player_inventory.f_35978_;
            this.inventory_ = block_inventory;
            this.wpc_ = wpc;
            this.wpc_.m_39292_((w, p) -> this.inventory_.m_5856_(this.player_));
            this.fields_ = fields;
            this.block_storage_range_ = new Inventories.InventoryRange(this.inventory_, 0, 54);
            this.player_inventory_range_ = new Inventories.InventoryRange((Container)player_inventory, 0, 36);
            this.frame_slot_range_ = new Inventories.InventoryRange(this.inventory_, 54, 1);
            int i = -1;
            for (y = 0; y < 6; ++y) {
                for (x = 0; x < 9; ++x) {
                    int xpos = 28 + x * 18;
                    int ypos = 10 + y * 18;
                    this.m_38897_(new StorageSlot(this.inventory_, ++i, xpos, ypos));
                }
            }
            this.m_38897_(new Slot(this.frame_slot_range_, 0, 191, 100){

                public int m_6641_() {
                    return 1;
                }
            });
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)player_inventory, x2, 28 + x2 * 18, 183));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)player_inventory, x + y * 9 + 9, 28 + x * 18, 125 + y * 18));
                }
            }
        }

        public boolean m_6875_(Player player) {
            return this.inventory_.m_6542_(player);
        }

        public boolean m_5882_(ItemStack stack, Slot slot) {
            return slot.m_6641_() > 1;
        }

        public void m_6877_(Player player) {
            super.m_6877_(player);
            this.inventory_.m_5785_(player);
        }

        public ItemStack m_7648_(Player player, int index) {
            Slot slot = this.m_38853_(index);
            if (slot == null || !slot.m_6657_()) {
                return ItemStack.f_41583_;
            }
            ItemStack slot_stack = slot.m_7993_();
            ItemStack transferred = slot_stack.m_41777_();
            if (index >= 0 && index < 55) {
                if (!this.m_38903_(slot_stack, 55, 91, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 55 && index <= 91) {
                if (!this.m_38903_(slot_stack, 0, 54, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slot_stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slot_stack.m_41613_() == transferred.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message, CompoundTag nbt) {
            nbt.m_128359_("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundTag nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, Player player, CompoundTag nbt) {
            if (!nbt.m_128441_("action")) {
                return;
            }
            boolean changed = false;
            int slotId = nbt.m_128441_("slot") ? nbt.m_128451_("slot") : -1;
            switch (nbt.m_128461_("action")) {
                case "quick-move-all": {
                    if (slotId >= 0 && slotId < 54 && this.m_38853_(slotId).m_6657_()) {
                        changed = this.block_storage_range_.move(this.m_38853_(slotId).getSlotIndex(), this.player_inventory_range_, true, false, true, true);
                        break;
                    }
                    if (slotId < 55 || slotId >= 91 || !this.m_38853_(slotId).m_6657_()) break;
                    changed = this.player_inventory_range_.move(this.m_38853_(slotId).getSlotIndex(), this.block_storage_range_, true, false, false, true);
                    break;
                }
                case "increase-stack": {
                    break;
                }
            }
            if (changed) {
                this.inventory_.m_6596_();
                player.m_150109_().m_6596_();
                this.m_38946_();
            }
        }

        protected static class StorageSlot
        extends Slot {
            StorageSlot(Container inventory, int index, int x, int y) {
                super(inventory, index, x, y);
            }

            public int m_6641_() {
                return 64;
            }

            public boolean m_5857_(ItemStack stack) {
                return !LabeledCrateTileEntity.inacceptable(stack);
            }
        }
    }

    public static class LabeledCrateTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements MenuProvider,
    Nameable,
    Networking.IPacketTileNotifyReceiver {
        public static final int NUM_OF_FIELDS = 1;
        public static final int NUM_OF_SLOTS = 55;
        public static final int NUM_OF_STORAGE_SLOTS = 54;
        public static final int NUM_OF_STORAGE_ROWS = 6;
        public static final int ITEMFRAME_SLOTNO = 54;
        private final Inventories.StorageInventory main_inventory_ = new Inventories.StorageInventory(this, 55, 1);
        private final Inventories.InventoryRange storage_range_ = new Inventories.InventoryRange(this.main_inventory_, 0, 54, 6);
        private final LazyOptional<IItemHandler> item_handler_;
        @Nullable
        private Component custom_name_;
        protected final ContainerData fields = new ContainerData(){

            public int m_6499_() {
                return 1;
            }

            public int m_6413_(int id) {
                switch (id) {
                    default: 
                }
                return 0;
            }

            public void m_8050_(int id, int value) {
                switch (id) {
                    default: 
                }
            }
        };

        public LabeledCrateTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_LABELED_CRATE, pos, state);
            this.main_inventory_.setCloseAction(player -> Networking.PacketTileNotifyServerToClient.sendToPlayers(this, this.writenbt(new CompoundTag())));
            this.main_inventory_.setSlotChangeAction((index, stack) -> {
                if (index == 54) {
                    Networking.PacketTileNotifyServerToClient.sendToPlayers(this, this.writenbt(new CompoundTag()));
                }
            });
            this.item_handler_ = Inventories.MappedItemHandler.createGenericHandler(this.storage_range_, (slot, stack) -> slot != 54, (slot, stack) -> slot != 54, IntStream.range(0, 54).boxed().collect(Collectors.toList()));
        }

        public CompoundTag getnbt() {
            return this.writenbt(new CompoundTag());
        }

        public CompoundTag readnbt(CompoundTag nbt) {
            if (nbt.m_128425_("name", 8)) {
                this.custom_name_ = Auxiliaries.unserializeTextComponent(nbt.m_128461_("name"));
            }
            this.main_inventory_.load(nbt);
            return nbt;
        }

        protected CompoundTag writenbt(CompoundTag nbt) {
            if (this.custom_name_ != null) {
                nbt.m_128359_("name", Auxiliaries.serializeTextComponent(this.custom_name_));
            }
            if (!this.main_inventory_.m_7983_()) {
                this.main_inventory_.save(nbt);
            }
            return nbt;
        }

        public ItemStack getItemFrameStack() {
            return this.main_inventory_.m_8020_(54);
        }

        protected static boolean inacceptable(ItemStack stack) {
            return stack.m_41782_() && !stack.m_41783_().m_128456_() && unstorable_containers.contains(stack.m_41720_());
        }

        @Override
        public void onServerPacketReceived(CompoundTag nbt) {
            this.readnbt(nbt);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        public CompoundTag m_6945_(CompoundTag nbt) {
            super.m_6945_(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public void m_7651_() {
            super.m_7651_();
            this.item_handler_.invalidate();
        }

        public CompoundTag m_5995_() {
            CompoundTag nbt = super.m_5995_();
            this.writenbt(nbt);
            return nbt;
        }

        @Nullable
        public ClientboundBlockEntityDataPacket m_7033_() {
            return new ClientboundBlockEntityDataPacket(this.f_58858_, 1, this.m_5995_());
        }

        public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
            this.readnbt(pkt.m_131708_());
            super.onDataPacket(net, pkt);
        }

        public void handleUpdateTag(CompoundTag tag) {
            this.m_142466_(tag);
        }

        @OnlyIn(value=Dist.CLIENT)
        public double getViewDistance() {
            return 1600.0;
        }

        public Component m_7755_() {
            if (this.custom_name_ != null) {
                return this.custom_name_;
            }
            Block block = this.m_58900_().m_60734_();
            if (block != null) {
                return new TranslatableComponent(block.m_7705_());
            }
            return new TextComponent("Labeled Crate");
        }

        @Nullable
        public Component m_7770_() {
            return this.custom_name_;
        }

        public boolean m_8077_() {
            return this.custom_name_ != null;
        }

        public void setCustomName(Component name) {
            this.custom_name_ = name;
        }

        public Component m_5446_() {
            return super.m_5446_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new LabeledCrateContainer(id, inventory, this.main_inventory_, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_), this.fields);
        }
    }
}

