/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.StandardEntityBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Fluidics;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Overlay;
import wile.engineersdecor.libmc.detail.RfEnergy;

public class EdMilker {
    public static final int BUCKET_SIZE = 1000;
    public static final int TICK_INTERVAL = 80;
    public static final int PROCESSING_TICK_INTERVAL = 20;
    public static final int TANK_CAPACITY = 12000;
    public static final int MAX_MILKING_TANK_LEVEL = 11500;
    public static final int FILLED_INDICATION_THRESHOLD = 1000;
    public static final int MAX_ENERGY_BUFFER = 16000;
    public static final int MAX_ENERGY_TRANSFER = 512;
    public static final int DEFAULT_ENERGY_CONSUMPTION = 0;
    public static final int DEFAULT_MILKING_DELAY_PER_COW = 4000;
    private static final FluidStack NO_MILK_FLUID;
    private static FluidStack milk_fluid_;
    private static final HashMap<ItemStack, ItemStack> milk_containers_;
    private static int energy_consumption_;
    private static long min_milking_delay_per_cow_ticks_;

    public static void on_config(int energy_consumption_per_tick, int min_milking_delay_per_cow) {
        Fluid milk;
        energy_consumption_ = Mth.m_14045_((int)energy_consumption_per_tick, (int)0, (int)1024);
        min_milking_delay_per_cow_ticks_ = Mth.m_14045_((int)min_milking_delay_per_cow, (int)1000, (int)24000);
        ResourceLocation milk_rl = ForgeRegistries.FLUIDS.getKeys().stream().filter(rl -> rl.m_135815_().equals("milk")).findFirst().orElse(null);
        if (milk_rl != null && (milk = (Fluid)ForgeRegistries.FLUIDS.getValue(milk_rl)) != null) {
            milk_fluid_ = new FluidStack(milk, 1000);
        }
        milk_containers_.put(new ItemStack((ItemLike)Items.f_42446_), new ItemStack((ItemLike)Items.f_42455_));
        ModConfig.log("Config milker: energy consumption:" + energy_consumption_ + "rf/t" + (milk_fluid_ == NO_MILK_FLUID ? "[no milk fluid registered]" : " [milk fluid available]"));
    }

    static {
        milk_fluid_ = NO_MILK_FLUID = new FluidStack((Fluid)Fluids.f_76193_, 0);
        milk_containers_ = new HashMap();
        energy_consumption_ = 0;
        min_milking_delay_per_cow_ticks_ = 4000L;
    }

    public static class SingleMoveGoal
    extends MoveToBlockGoal {
        private static final HashMap<Integer, SingleMoveGoal> tracked_entities_ = new HashMap();
        private static final int motion_timeout = 400;
        private boolean aborted_;
        private boolean in_position_;
        private boolean was_aborted_;
        private Vec3 target_pos_;
        private TargetPositionInValidCheck abort_condition_;
        private StrollEvent on_target_position_reached_;
        private StrollEvent on_aborted_;

        private static void log(String s) {
        }

        public SingleMoveGoal(PathfinderMob creature, Vec3 pos, double speed, TargetPositionInValidCheck abort_condition, @Nullable StrollEvent on_position_reached, @Nullable StrollEvent on_aborted) {
            super(creature, speed, 32, 32);
            this.abort_condition_ = abort_condition;
            this.on_target_position_reached_ = on_position_reached;
            this.on_aborted_ = on_aborted;
            this.f_25602_ = new BlockPos(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            this.f_25601_ = 0;
            this.f_25600_ = 0;
            this.aborted_ = false;
            this.was_aborted_ = false;
            this.target_pos_ = pos;
        }

        public static void startFor(PathfinderMob entity, BlockPos target_pos, int priority, double speed, TargetPositionInValidCheck abort_condition) {
            SingleMoveGoal.startFor(entity, new Vec3((double)target_pos.m_123341_(), (double)target_pos.m_123342_(), (double)target_pos.m_123343_()), priority, speed, abort_condition, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean startFor(PathfinderMob entity, Vec3 target_pos, int priority, double speed, TargetPositionInValidCheck abort_condition, @Nullable StrollEvent on_position_reached, @Nullable StrollEvent on_aborted) {
            HashMap<Integer, SingleMoveGoal> hashMap = tracked_entities_;
            synchronized (hashMap) {
                SingleMoveGoal goal = tracked_entities_.getOrDefault(entity.m_142049_(), null);
                if (goal != null) {
                    if (!goal.aborted()) {
                        return false;
                    }
                    entity.f_21345_.m_25363_((Goal)goal);
                }
                SingleMoveGoal.log("::start(" + entity.m_142049_() + ")");
                goal = new SingleMoveGoal(entity, target_pos, speed, abort_condition, on_position_reached, on_aborted);
                tracked_entities_.put(entity.m_142049_(), goal);
                entity.f_21345_.m_25352_(priority, (Goal)goal);
                return true;
            }
        }

        public static boolean isActiveFor(PathfinderMob entity) {
            return entity != null && entity.f_21345_.m_25386_().anyMatch(g -> g.m_26015_() instanceof SingleMoveGoal && !((SingleMoveGoal)g.m_26015_()).aborted());
        }

        public static void abortFor(PathfinderMob entity) {
            Level world;
            SingleMoveGoal.log("::abort(" + entity.m_142049_() + ")");
            if (entity.m_6084_()) {
                entity.f_21345_.m_25386_().filter(g -> g.m_26015_() instanceof SingleMoveGoal).forEach(g -> ((SingleMoveGoal)g.m_26015_()).abort());
            }
            if ((world = entity.m_20193_()) != null) {
                List to_remove = tracked_entities_.keySet().stream().filter(i -> world.m_6815_(i.intValue()) == null).collect(Collectors.toList());
                Iterator iterator = to_remove.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    tracked_entities_.remove(id);
                }
            }
        }

        public Vec3 getTargetPosition() {
            return this.target_pos_;
        }

        public PathfinderMob getCreature() {
            return this.f_25598_;
        }

        public synchronized void abort() {
            this.aborted_ = true;
        }

        public synchronized boolean aborted() {
            return this.aborted_;
        }

        public synchronized void initialize(Vec3 target_pos, double speed, TargetPositionInValidCheck abort_condition, @Nullable StrollEvent on_position_reached, @Nullable StrollEvent on_aborted) {
            this.abort_condition_ = abort_condition;
            this.on_target_position_reached_ = on_position_reached;
            this.on_aborted_ = on_aborted;
            this.f_25602_ = new BlockPos(target_pos.m_7096_(), target_pos.m_7098_(), target_pos.m_7094_());
            this.f_25601_ = 0;
            this.f_25600_ = 0;
            this.aborted_ = false;
            this.was_aborted_ = false;
            this.target_pos_ = new Vec3(target_pos.m_7096_(), target_pos.m_7098_(), target_pos.m_7094_());
        }

        public void m_8041_() {
            this.f_25600_ = 0;
            this.f_25601_ = 0;
        }

        public double m_8052_() {
            return 0.7;
        }

        public boolean m_8064_() {
            return !this.aborted() && (this.f_25601_ & 7) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean m_8036_() {
            if (this.aborted_) {
                if (!this.was_aborted_ && this.on_aborted_ != null) {
                    this.on_aborted_.apply(this, (LevelReader)this.f_25598_.f_19853_, this.target_pos_);
                }
                this.was_aborted_ = true;
                return false;
            }
            if (!this.m_6465_((LevelReader)this.f_25598_.f_19853_, this.f_25602_)) {
                SingleMoveGoal singleMoveGoal = this;
                synchronized (singleMoveGoal) {
                    this.aborted_ = true;
                }
                return false;
            }
            if (--this.f_25600_ > 0) {
                return false;
            }
            this.f_25600_ = 10;
            return true;
        }

        public void m_8056_() {
            this.f_25601_ = 0;
            if (!this.f_25598_.m_21573_().m_26519_(this.target_pos_.m_7096_(), this.target_pos_.m_7098_(), this.target_pos_.m_7094_(), this.f_25599_)) {
                this.abort();
                SingleMoveGoal.log("startExecuting() -> abort, no path");
            } else {
                SingleMoveGoal.log("startExecuting() -> started");
            }
        }

        public boolean m_8045_() {
            if (this.aborted()) {
                SingleMoveGoal.log("shouldContinueExecuting() -> already aborted");
                return false;
            }
            if (this.f_25598_.m_21573_().m_26571_()) {
                if (!this.f_25598_.m_21573_().m_26536_(this.f_25598_.m_21573_().m_26524_(this.target_pos_.m_7096_(), this.target_pos_.m_7098_(), this.target_pos_.m_7094_(), 0), this.f_25599_)) {
                    SingleMoveGoal.log("shouldContinueExecuting() -> abort, no path");
                    this.abort();
                    return false;
                }
                return true;
            }
            if (this.f_25601_ > 400) {
                SingleMoveGoal.log("shouldContinueExecuting() -> abort, timeout");
                this.abort();
                return false;
            }
            if (!this.m_6465_((LevelReader)this.f_25598_.f_19853_, this.f_25602_)) {
                SingleMoveGoal.log("shouldContinueExecuting() -> abort, !shouldMoveTo()");
                this.abort();
                return false;
            }
            SingleMoveGoal.log("shouldContinueExecuting() -> yes");
            return true;
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            if (this.abort_condition_.test(this, world, pos)) {
                SingleMoveGoal.log("shouldMoveTo() -> abort_condition");
                return false;
            }
            return true;
        }

        public void m_8037_() {
            BlockPos testpos = new BlockPos(this.target_pos_.m_7096_(), this.f_25598_.m_20182_().m_7098_(), this.target_pos_.m_7094_());
            if (!testpos.m_123306_((Position)this.f_25598_.m_20182_(), this.m_8052_())) {
                if (++this.f_25601_ > 400) {
                    SingleMoveGoal.log("tick() -> abort, timeoutCounter");
                    this.abort();
                    return;
                }
                if (this.m_8064_() && !this.f_25598_.m_21573_().m_26519_(this.target_pos_.m_7096_(), this.target_pos_.m_7098_(), this.target_pos_.m_7094_(), this.f_25599_)) {
                    SingleMoveGoal.log("tick() -> abort, !tryMoveToXYZ()");
                    this.abort();
                }
            } else {
                SingleMoveGoal.log("tick() -> abort, in position)");
                this.in_position_ = true;
                this.abort();
                if (this.on_target_position_reached_ != null) {
                    this.on_target_position_reached_.apply(this, (LevelReader)this.f_25598_.f_19853_, this.target_pos_);
                }
            }
        }

        @FunctionalInterface
        public static interface TargetPositionInValidCheck {
            public boolean test(SingleMoveGoal var1, LevelReader var2, BlockPos var3);
        }

        @FunctionalInterface
        public static interface StrollEvent {
            public void apply(SingleMoveGoal var1, LevelReader var2, Vec3 var3);
        }
    }

    public static class MilkerTileEntity
    extends StandardEntityBlocks.StandardBlockEntity {
        private static final Direction[] FLUID_TRANSFER_DIRECTRIONS = new Direction[]{Direction.DOWN, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH};
        private int tick_timer_;
        private UUID tracked_cow_ = null;
        private MilkingState state_ = MilkingState.IDLE;
        private int state_timeout_ = 0;
        private int state_timer_ = 0;
        private BlockPos tracked_cow_original_position_ = null;
        private final RfEnergy.Battery battery_;
        private final LazyOptional<IEnergyStorage> energy_handler_;
        private final Fluidics.Tank tank_ = new Fluidics.Tank(12000, 0, 1000, fs -> this.has_milk_fluid() && fs.isFluidEqual(milk_fluid_));
        private final LazyOptional<IFluidHandler> fluid_handler_ = this.tank_.createFluidHandler();
        private static final HashMap<Integer, Long> tracked_cows_ = new HashMap();

        public MilkerTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_SMALL_MILKING_MACHINE, pos, state);
            this.battery_ = new RfEnergy.Battery(16000, 512, 0);
            this.energy_handler_ = this.battery_.createEnergyHandler();
            this.reset();
        }

        public void reset() {
            this.tank_.clear();
            this.battery_.clear();
            this.tick_timer_ = 0;
            this.tracked_cow_ = null;
            this.state_ = MilkingState.IDLE;
            this.state_timeout_ = 0;
        }

        public CompoundTag destroy_getnbt() {
            UUID cowuid = this.tracked_cow_;
            CompoundTag nbt = new CompoundTag();
            this.writenbt(nbt, false);
            this.reset();
            if (cowuid == null) {
                return nbt;
            }
            this.f_58857_.m_6443_(Cow.class, new AABB(this.f_58858_).m_82377_(16.0, 16.0, 16.0), e -> e.m_142081_().equals(cowuid)).forEach(e -> e.m_21557_(false));
            return nbt;
        }

        public void readnbt(CompoundTag nbt, boolean update_packet) {
            this.battery_.load(nbt);
            this.tank_.load(nbt);
        }

        protected void writenbt(CompoundTag nbt, boolean update_packet) {
            this.tank_.save(nbt);
            if (!this.battery_.isEmpty()) {
                this.battery_.save(nbt);
            }
        }

        private IFluidHandler fluid_handler() {
            return (IFluidHandler)this.fluid_handler_.orElse(null);
        }

        private int fluid_level() {
            return this.tank_.getFluidAmount();
        }

        private FluidStack drain(int amount) {
            return this.tank_.drain(amount);
        }

        public void state_message(Player player) {
            TextComponent rf = energy_consumption_ <= 0 ? new TextComponent("") : Auxiliaries.localizable("block.engineersdecor.small_milking_machine.status.rf", this.battery_.getEnergyStored());
            Overlay.show(player, (Component)Auxiliaries.localizable("block.engineersdecor.small_milking_machine.status", this.tank_.getFluidAmount(), rf));
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt, false);
        }

        public CompoundTag m_6945_(CompoundTag nbt) {
            super.m_6945_(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public void m_7651_() {
            super.m_7651_();
            this.energy_handler_.invalidate();
            this.fluid_handler_.invalidate();
        }

        private boolean has_milk_fluid() {
            return !NO_MILK_FLUID.isFluidEqual(milk_fluid_);
        }

        private void log(String s) {
        }

        private static ItemStack milk_filled_container_item(ItemStack stack) {
            return milk_containers_.entrySet().stream().filter(e -> Inventories.areItemStacksIdentical((ItemStack)e.getKey(), stack)).map(Map.Entry::getValue).findFirst().orElse(ItemStack.f_41583_);
        }

        private boolean fill_adjacent_inventory_item_containers(Direction block_facing) {
            IItemHandler src = Inventories.itemhandler(this.f_58857_, this.f_58858_.m_142300_(block_facing), block_facing.m_122424_());
            IItemHandler dst = Inventories.itemhandler(this.f_58857_, this.f_58858_.m_7495_(), Direction.UP);
            if (src == null) {
                src = dst;
            } else if (dst == null) {
                dst = src;
            }
            if (src == null || dst == null) {
                return false;
            }
            boolean dirty = false;
            while (this.tank_.getFluidAmount() >= 1000) {
                boolean inserted = false;
                for (Map.Entry<ItemStack, ItemStack> e : milk_containers_.entrySet()) {
                    if (Inventories.extract(src, e.getKey(), 1, true).m_41619_() || !Inventories.insert(dst, e.getValue().m_41777_(), false).m_41619_()) continue;
                    Inventories.extract(src, e.getKey(), 1, false);
                    this.tank_.drain(1000);
                    inserted = true;
                    dirty = true;
                    break;
                }
                if (inserted) continue;
                break;
            }
            return dirty;
        }

        private boolean fill_adjacent_tank() {
            if (this.fluid_level() <= 0 || !this.has_milk_fluid()) {
                return false;
            }
            FluidStack fs = new FluidStack(milk_fluid_, Math.max(this.fluid_level(), 1000));
            for (Direction dir : Direction.values()) {
                int amount = Fluidics.fill(this.m_58904_(), this.m_58899_().m_142300_(dir), dir.m_122424_(), fs);
                if (amount <= 0) continue;
                this.tank_.drain(amount);
                return true;
            }
            return false;
        }

        private void release_cow(Cow cow) {
            this.log("release cow");
            if (cow != null) {
                cow.m_21557_(false);
                SingleMoveGoal.abortFor((PathfinderMob)cow);
                tracked_cows_.remove(cow.m_142049_());
                Iterator iterator = tracked_cows_.keySet().stream().filter(i -> cow.m_20193_().m_6815_(i.intValue()) == null).collect(Collectors.toList()).iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    tracked_cows_.remove(id);
                }
            }
            this.tracked_cow_ = null;
            this.state_ = MilkingState.IDLE;
            this.tick_timer_ = 80;
        }

        private boolean milking_process() {
            long t;
            if (this.tracked_cow_ == null && this.fluid_level() >= 11500) {
                return false;
            }
            Direction facing = ((Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)MilkerBlock.HORIZONTAL_FACING)).m_122424_();
            Vec3 target_pos = Vec3.m_82528_((Vec3i)this.m_58899_().m_142300_(facing)).m_82520_(0.5, 0.0, 0.5);
            Cow cow = null;
            AABB aabb = new AABB(this.f_58858_.m_5484_(facing, 3)).m_82377_(4.0, 2.0, 4.0);
            List cows = this.f_58857_.m_6443_(Cow.class, aabb, arg_0 -> this.lambda$milking_process$5(t = this.f_58857_.m_46467_(), arg_0));
            if (cows.size() == 1) {
                cow = (Cow)cows.get(0);
            } else if (cows.size() > 1) {
                cow = (Cow)cows.get(this.f_58857_.f_46441_.nextInt(cows.size() - 1));
            }
            if (this.state_ != MilkingState.IDLE && (this.state_timeout_ -= 20) <= 0) {
                this.release_cow(cow);
                this.log("Cow motion timeout");
                cow = null;
            }
            if (cow == null || !cow.m_6084_()) {
                this.release_cow(cow);
                cow = null;
            }
            if (this.tracked_cow_ == null) {
                this.state_ = MilkingState.IDLE;
            }
            if (cow == null) {
                this.log("Init: No cow");
                return false;
            }
            this.tick_timer_ = 20;
            this.state_timer_ -= 20;
            if (this.state_timer_ > 0) {
                return false;
            }
            switch (this.state_) {
                case IDLE: {
                    List blocking_entities = this.f_58857_.m_45976_(LivingEntity.class, new AABB(this.f_58858_.m_142300_(facing)).m_82377_(0.5, 0.5, 0.5));
                    if (blocking_entities.size() > 0) {
                        this.tick_timer_ = 80;
                        this.log("Idle: Position blocked");
                        Object e = blocking_entities.get(0);
                        if (e instanceof Cow) {
                            Cow blocker = (Cow)e;
                            BlockPos p = this.m_58899_().m_5484_(facing, 2);
                            this.log("Idle: Shove off");
                            blocker.m_21557_(false);
                            SingleMoveGoal.startFor((PathfinderMob)blocker, p, 2, 1.0, (goal, world, pos) -> pos.m_123331_((Vec3i)goal.getCreature().m_142538_()) > 100.0);
                        }
                        return false;
                    }
                    if (cow.m_21523_() || cow.m_6162_() || cow.m_27593_() || !cow.m_20096_() || cow.m_20160_() || cow.m_20142_()) {
                        return false;
                    }
                    tracked_cows_.put(cow.m_142049_(), cow.m_20193_().m_46467_());
                    this.tracked_cow_ = cow.m_142081_();
                    this.state_ = MilkingState.PICKED;
                    this.state_timeout_ = 200;
                    this.tracked_cow_original_position_ = cow.m_142538_();
                    this.log("Idle: Picked cow " + this.tracked_cow_);
                    return false;
                }
                case PICKED: {
                    SingleMoveGoal.startFor((PathfinderMob)cow, target_pos, 2, 1.0, (goal, world, pos) -> pos.m_123331_((Vec3i)goal.getCreature().m_142538_()) > 100.0, (goal, world, pos) -> {
                        this.log("move: position reached");
                        goal.getCreature().m_7678_(goal.getTargetPosition().m_7096_(), goal.getTargetPosition().m_7098_(), goal.getTargetPosition().m_7094_(), facing.m_122435_(), 0.0f);
                    }, (goal, world, pos) -> this.log("move: aborted"));
                    this.state_ = MilkingState.COMING;
                    this.state_timeout_ = 400;
                    this.log("Picked: coming to " + target_pos);
                    return false;
                }
                case COMING: {
                    if (target_pos.m_82557_(cow.m_20182_()) <= 1.0) {
                        this.log("Coming: position reached");
                        this.state_ = MilkingState.POSITIONING;
                        this.state_timeout_ = 100;
                    } else if (!SingleMoveGoal.isActiveFor((PathfinderMob)cow)) {
                        this.release_cow(cow);
                        this.log("Coming: aborted");
                    } else {
                        this.state_timeout_ -= 100;
                    }
                    return false;
                }
                case POSITIONING: {
                    this.log("Positioning: start milking");
                    SingleMoveGoal.abortFor((PathfinderMob)cow);
                    cow.m_21557_(true);
                    cow.m_7678_(target_pos.m_7096_(), target_pos.m_7098_(), target_pos.m_7094_(), facing.m_122435_(), 0.0f);
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11833_, SoundSource.BLOCKS, 0.5f, 1.0f);
                    this.state_timeout_ = 600;
                    this.state_ = MilkingState.MILKING;
                    this.state_timer_ = 30;
                    return false;
                }
                case MILKING: {
                    this.tank_.fill(milk_fluid_.copy(), IFluidHandler.FluidAction.EXECUTE);
                    this.state_timeout_ = 600;
                    this.state_ = MilkingState.LEAVING;
                    this.state_timer_ = 20;
                    cow.m_21557_(false);
                    cow.m_21573_().m_26573_();
                    this.log("Milking: done, leave");
                    return true;
                }
                case LEAVING: {
                    BlockPos p = this.tracked_cow_original_position_ != null ? this.tracked_cow_original_position_ : this.m_58899_().m_5484_(facing, 2).m_142300_(facing.m_122428_());
                    SingleMoveGoal.startFor((PathfinderMob)cow, p, 2, 1.0, (goal, world, pos) -> pos.m_123331_((Vec3i)goal.getCreature().m_142538_()) > 100.0);
                    this.state_timeout_ = 600;
                    this.state_timer_ = 500;
                    this.tick_timer_ = 80;
                    this.state_ = MilkingState.WAITING;
                    tracked_cows_.put(cow.m_142049_(), cow.m_20193_().m_46467_());
                    this.log("Leaving: process done");
                    return true;
                }
                case WAITING: {
                    this.tick_timer_ = 80;
                    if (this.state_timer_ < 40) {
                        this.tracked_cow_ = null;
                        this.release_cow(null);
                    }
                    this.log("Waiting time elapsed");
                    return true;
                }
            }
            this.release_cow(cow);
            return this.tracked_cow_ != null;
        }

        @Override
        public void tick() {
            BlockState new_state;
            if (this.f_58857_.f_46443_ || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 80;
            boolean dirty = false;
            BlockState block_state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(block_state.m_60734_() instanceof MilkerBlock)) {
                return;
            }
            if (!this.f_58857_.m_46753_(this.f_58858_) || this.state_ != MilkingState.IDLE) {
                if (energy_consumption_ > 0 && !this.battery_.draw(energy_consumption_)) {
                    return;
                }
                if (this.milking_process()) {
                    dirty = true;
                }
                if (this.has_milk_fluid() && !this.tank_.isEmpty()) {
                    this.log("Fluid transfer");
                    for (Direction facing : FLUID_TRANSFER_DIRECTRIONS) {
                        FluidStack fs;
                        int nfilled;
                        IFluidHandler fh = Fluidics.handler(this.f_58857_, this.f_58858_.m_142300_(facing), facing.m_122424_());
                        if (fh == null || (nfilled = fh.fill(fs = this.tank_.drain(1000, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                        this.tank_.drain(nfilled, IFluidHandler.FluidAction.EXECUTE);
                        dirty = true;
                        break;
                    }
                }
                if (!dirty && this.fluid_level() > 0) {
                    this.log("Try item transfer");
                    if (this.fill_adjacent_tank() || this.fluid_level() >= 1000 && this.fill_adjacent_inventory_item_containers((Direction)block_state.m_61143_((Property)MilkerBlock.HORIZONTAL_FACING))) {
                        dirty = true;
                    }
                }
            }
            if (block_state != (new_state = (BlockState)((BlockState)block_state.m_61124_((Property)MilkerBlock.FILLED, (Comparable)Boolean.valueOf(this.fluid_level() >= 1000))).m_61124_((Property)MilkerBlock.ACTIVE, (Comparable)Boolean.valueOf(this.state_ == MilkingState.MILKING)))) {
                this.f_58857_.m_7731_(this.f_58858_, new_state, 19);
            }
            if (dirty) {
                this.m_6596_();
            }
        }

        private /* synthetic */ boolean lambda$milking_process$5(long t, Cow e) {
            if (e.m_142081_().equals(this.tracked_cow_)) {
                return true;
            }
            if (this.tracked_cow_ != null || e.m_6162_() || e.m_27593_() || e.m_20160_()) {
                return false;
            }
            if (!e.m_21573_().m_26571_()) {
                return false;
            }
            return Math.abs(tracked_cows_.getOrDefault(e.m_142049_(), 0L) - t) >= min_milking_delay_per_cow_ticks_;
        }

        private static enum MilkingState {
            IDLE,
            PICKED,
            COMING,
            POSITIONING,
            MILKING,
            LEAVING,
            WAITING;

        }
    }

    public static class MilkerBlock
    extends StandardBlocks.Horizontal
    implements StandardEntityBlocks.IStandardEntityBlock<MilkerTileEntity> {
        public static final BooleanProperty FILLED = BooleanProperty.m_61465_((String)"filled");
        public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

        public MilkerBlock(long config, BlockBehaviour.Properties builder, AABB[] unrotatedAABBs) {
            super(config, builder, unrotatedAABBs);
        }

        @Override
        @Nullable
        public BlockEntityType<MilkerTileEntity> getBlockEntityType() {
            return ModContent.TET_SMALL_MILKING_MACHINE;
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{ACTIVE});
            builder.m_61104_(new Property[]{FILLED});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState state, Level world, BlockPos pos) {
            MilkerTileEntity te = this.getTe(world, pos);
            return te == null ? 0 : Mth.m_14045_((int)(16 * te.fluid_level() / 12000), (int)0, (int)15);
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
            ItemStack insert_stack;
            ItemStack remainder;
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            MilkerTileEntity te = this.getTe(world, pos);
            if (te == null) {
                return InteractionResult.FAIL;
            }
            ItemStack in_stack = player.m_21120_(hand);
            ItemStack out_stack = MilkerTileEntity.milk_filled_container_item(in_stack);
            if (in_stack.m_41619_()) {
                te.state_message(player);
                return InteractionResult.CONSUME;
            }
            if (out_stack.m_41619_() && te.fluid_handler() != null) {
                return Fluidics.manualFluidHandlerInteraction(player, hand, te.fluid_handler()) ? InteractionResult.CONSUME : InteractionResult.FAIL;
            }
            boolean drained = false;
            IItemHandler player_inventory = Inventories.itemhandler(player);
            if (te.fluid_level() >= 1000 && (remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)player_inventory, (ItemStack)(insert_stack = out_stack.m_41777_()), (boolean)false)).m_41613_() < insert_stack.m_41613_()) {
                te.drain(1000);
                in_stack.m_41774_(1);
                drained = true;
                if (remainder.m_41613_() > 0) {
                    ItemEntity ei = new ItemEntity(world, player.m_20182_().m_7096_(), player.m_20182_().m_7098_() + 0.5, player.m_20182_().m_7094_(), remainder);
                    ei.m_32010_(40);
                    ei.m_20334_(0.0, 0.0, 0.0);
                    world.m_7967_((Entity)ei);
                }
            }
            if (drained) {
                world.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 0.8f, 1.0f);
            }
            return InteractionResult.CONSUME;
        }

        @Nullable
        private MilkerTileEntity getTe(Level world, BlockPos pos) {
            BlockEntity te = world.m_7702_(pos);
            return !(te instanceof MilkerTileEntity) ? null : (MilkerTileEntity)te;
        }
    }
}

