/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class EdRoofBlock
extends StandardBlocks.HorizontalWaterLoggable {
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    private final VoxelShape[][][] shape_cache_;

    public EdRoofBlock(long config, BlockBehaviour.Properties properties) {
        this(config, properties.m_60988_(), Shapes.m_83040_(), Shapes.m_83040_());
    }

    public EdRoofBlock(long config, BlockBehaviour.Properties properties, VoxelShape add, VoxelShape cut) {
        super(config, properties, Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 8.0, 16.0));
        this.m_49959_((BlockState)((BlockState)super.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT));
        this.shape_cache_ = EdRoofBlock.makeShapes(add, cut);
    }

    public boolean m_7923_(BlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 0.98f;
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shape_cache_[((Half)state.m_61143_(HALF)).ordinal()][((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122411_()][((StairsShape)state.m_61143_(SHAPE)).ordinal()];
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SHAPE, HALF});
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        BlockState state = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)(face == Direction.DOWN ? Half.TOP : Half.BOTTOM))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(pos).m_76152_() == Fluids.f_76193_));
        return (BlockState)state.m_61124_(SHAPE, (Comparable)EdRoofBlock.getStairsShapeProperty(state, (BlockGetter)context.m_43725_(), pos));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_6217_().m_5945_(pos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return facing.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)EdRoofBlock.getStairsShapeProperty(state, (BlockGetter)world, pos)) : super.m_7417_(state, facing, facingState, world, pos, facingPos);
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror where) {
        if (where == Mirror.LEFT_RIGHT && ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122434_() == Direction.Axis.Z) {
            return switch ((StairsShape)state.m_61143_(SHAPE)) {
                case StairsShape.INNER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                case StairsShape.INNER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                case StairsShape.OUTER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                case StairsShape.OUTER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                default -> state.m_60717_(Rotation.CLOCKWISE_180);
            };
        }
        if (where == Mirror.FRONT_BACK && ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122434_() == Direction.Axis.X) {
            return switch ((StairsShape)state.m_61143_(SHAPE)) {
                case StairsShape.INNER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                case StairsShape.INNER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                case StairsShape.OUTER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                case StairsShape.OUTER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                case StairsShape.STRAIGHT -> state.m_60717_(Rotation.CLOCKWISE_180);
                default -> throw new IncompatibleClassChangeError();
            };
        }
        return super.m_6943_(state, where);
    }

    private static boolean isRoofBlock(BlockState state) {
        return state.m_60734_() instanceof EdRoofBlock;
    }

    private static boolean isOtherRoofState(BlockState state, BlockGetter world, BlockPos pos, Direction facing) {
        BlockState st = world.m_8055_(pos.m_142300_(facing));
        return !EdRoofBlock.isRoofBlock(st) || st.m_61143_((Property)HORIZONTAL_FACING) != state.m_61143_((Property)HORIZONTAL_FACING);
    }

    private static VoxelShape[][][] makeShapes(VoxelShape add, VoxelShape cut) {
        VoxelShape[][][] shapes = new VoxelShape[2][6][5];
        for (int half_index = 0; half_index < Half.values().length; ++half_index) {
            for (int direction_index = 0; direction_index < Direction.values().length; ++direction_index) {
                for (int stairs_shape_index = 0; stairs_shape_index < StairsShape.values().length; ++stairs_shape_index) {
                    VoxelShape shape = EdRoofBlock.makeShape(half_index, direction_index, stairs_shape_index);
                    try {
                        if (!add.m_83281_()) {
                            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)add, (BooleanOp)BooleanOp.f_82695_);
                        }
                        if (!cut.m_83281_()) {
                            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)cut, (BooleanOp)BooleanOp.f_82685_);
                        }
                    }
                    catch (Throwable ex) {
                        Auxiliaries.logError("Failed to cut shape using Boolean function. This is bug.");
                    }
                    shapes[half_index][direction_index][stairs_shape_index] = shape;
                }
            }
        }
        return shapes;
    }

    private static VoxelShape makeShape(int half_index, int direction_index, int stairs_shape_index) {
        Direction direction;
        AABB[] straight = new AABB[]{Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 16.0, 8.0, 16.0), Auxiliaries.getPixeledAABB(8.0, 8.0, 0.0, 16.0, 12.0, 16.0), Auxiliaries.getPixeledAABB(12.0, 12.0, 0.0, 16.0, 16.0, 16.0)};
        AABB[] pyramid = new AABB[]{Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Auxiliaries.getPixeledAABB(4.0, 4.0, 4.0, 16.0, 8.0, 16.0), Auxiliaries.getPixeledAABB(8.0, 8.0, 8.0, 16.0, 12.0, 16.0), Auxiliaries.getPixeledAABB(12.0, 12.0, 12.0, 16.0, 16.0, 16.0)};
        Half half = Half.values()[half_index];
        if (half == Half.TOP) {
            straight = Auxiliaries.getMirroredAABB(straight, Direction.Axis.Y);
            pyramid = Auxiliaries.getMirroredAABB(pyramid, Direction.Axis.Y);
        }
        if ((direction = Direction.m_122376_((int)direction_index)) == Direction.UP || direction == Direction.DOWN) {
            return Shapes.m_83144_();
        }
        direction_index = direction.m_122416_() + 1 & 3;
        StairsShape stairs = StairsShape.values()[stairs_shape_index];
        return switch (stairs) {
            case StairsShape.STRAIGHT -> Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(straight, direction_index));
            case StairsShape.OUTER_LEFT -> Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(pyramid, direction_index - 1));
            case StairsShape.OUTER_RIGHT -> Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(pyramid, direction_index));
            case StairsShape.INNER_LEFT -> Auxiliaries.getUnionShape(new AABB[][]{Auxiliaries.getYRotatedAABB(straight, direction_index), Auxiliaries.getYRotatedAABB(straight, direction_index - 1)});
            case StairsShape.INNER_RIGHT -> Auxiliaries.getUnionShape(new AABB[][]{Auxiliaries.getYRotatedAABB(straight, direction_index), Auxiliaries.getYRotatedAABB(straight, direction_index + 1)});
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static StairsShape getStairsShapeProperty(BlockState state, BlockGetter world, BlockPos pos) {
        Direction nf;
        Direction direction = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        BlockState ns = world.m_8055_(pos.m_142300_(direction));
        if (EdRoofBlock.isRoofBlock(ns) && state.m_61143_(HALF) == ns.m_61143_(HALF) && (nf = (Direction)ns.m_61143_((Property)HORIZONTAL_FACING)).m_122434_() != ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122434_() && EdRoofBlock.isOtherRoofState(state, world, pos, nf.m_122424_())) {
            return nf == direction.m_122428_() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        ns = world.m_8055_(pos.m_142300_(direction.m_122424_()));
        if (EdRoofBlock.isRoofBlock(ns) && state.m_61143_(HALF) == ns.m_61143_(HALF) && (nf = (Direction)ns.m_61143_((Property)HORIZONTAL_FACING)).m_122434_() != ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122434_() && EdRoofBlock.isOtherRoofState(state, world, pos, nf)) {
            return nf == direction.m_122428_() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }
}

