/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.StandardEntityBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Fluidics;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Overlay;
import wile.engineersdecor.libmc.detail.RfEnergy;

public class EdTestBlock {

    public static class TestTileEntity
    extends StandardEntityBlocks.StandardBlockEntity {
        private final RfEnergy.Battery battery_;
        private final LazyOptional<IEnergyStorage> energy_handler_;
        private final Fluidics.Tank tank_;
        private final LazyOptional<IFluidHandler> fluid_handler_;
        private final Inventories.StorageInventory inventory_;
        private final LazyOptional<IItemHandler> item_handler_;
        private int tick_timer = 0;
        private int rf_fed_avg = 0;
        private int rf_fed_total = 0;
        private int rf_fed_acc = 0;
        private int rf_received_avg = 0;
        private int rf_received_total = 0;
        private int liq_filled_avg = 0;
        private int liq_filled_total = 0;
        private int liq_filled_acc = 0;
        private int liq_received_avg = 0;
        private int liq_received_total = 0;
        private int items_inserted_total = 0;
        private int items_received_total = 0;
        private int rf_feed_setting = 4096;
        private FluidStack liq_fill_stack = new FluidStack((Fluid)Fluids.f_76193_, 128);
        private ItemStack insertion_item = ItemStack.f_41583_;
        private Direction block_facing = Direction.NORTH;
        private boolean paused = false;

        public TestTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_TEST_BLOCK, pos, state);
            this.battery_ = new RfEnergy.Battery(1000000000, 1000000000, 0, 0);
            this.energy_handler_ = this.battery_.createEnergyHandler();
            this.tank_ = new Fluidics.Tank(1000000000);
            this.fluid_handler_ = this.tank_.createFluidHandler();
            this.inventory_ = new Inventories.StorageInventory(this, 1);
            this.item_handler_ = Inventories.MappedItemHandler.createInsertionHandler(this.inventory_);
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.tank_.load(nbt);
            this.battery_.load(nbt);
            this.rf_fed_avg = nbt.m_128451_("rf_fed_avg");
            this.rf_fed_total = nbt.m_128451_("rf_fed_total");
            this.rf_fed_acc = nbt.m_128451_("rf_fed_acc");
            this.rf_received_avg = nbt.m_128451_("rf_received_avg");
            this.rf_received_total = nbt.m_128451_("rf_received_total");
            this.liq_filled_avg = nbt.m_128451_("liq_filled_avg");
            this.liq_filled_total = nbt.m_128451_("liq_filled_total");
            this.liq_filled_acc = nbt.m_128451_("liq_filled_acc");
            this.liq_received_avg = nbt.m_128451_("liq_received_avg");
            this.liq_received_total = nbt.m_128451_("liq_received_total");
            this.rf_feed_setting = nbt.m_128451_("rf_feed_setting");
            this.items_received_total = nbt.m_128451_("items_received_total");
            this.items_inserted_total = nbt.m_128451_("items_inserted_total");
            if (nbt.m_128441_("liq_fill_stack")) {
                this.liq_fill_stack = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("liq_fill_stack"));
            }
            if (nbt.m_128441_("insertion_item")) {
                this.insertion_item = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("insertion_item"));
            }
        }

        public CompoundTag m_6945_(CompoundTag nbt) {
            super.m_6945_(nbt);
            this.tank_.save(nbt);
            this.battery_.save(nbt);
            nbt.m_128405_("rf_fed_avg", this.rf_fed_avg);
            nbt.m_128405_("rf_fed_total", this.rf_fed_total);
            nbt.m_128405_("rf_fed_acc", this.rf_fed_acc);
            nbt.m_128405_("rf_received_avg", this.rf_received_avg);
            nbt.m_128405_("rf_received_total", this.rf_received_total);
            nbt.m_128405_("liq_filled_avg", this.liq_filled_avg);
            nbt.m_128405_("liq_filled_total", this.liq_filled_total);
            nbt.m_128405_("liq_filled_acc", this.liq_filled_acc);
            nbt.m_128405_("liq_received_avg", this.liq_received_avg);
            nbt.m_128405_("liq_received_total", this.liq_received_total);
            nbt.m_128405_("rf_feed_setting", this.rf_feed_setting);
            nbt.m_128405_("items_received_total", this.items_received_total);
            nbt.m_128405_("items_inserted_total", this.items_inserted_total);
            if (!this.liq_fill_stack.isEmpty()) {
                nbt.m_128365_("liq_fill_stack", (Tag)this.liq_fill_stack.writeToNBT(new CompoundTag()));
            }
            if (!this.insertion_item.m_41619_()) {
                nbt.m_128365_("insertion_item", (Tag)this.insertion_item.m_41739_(new CompoundTag()));
            }
            return nbt;
        }

        private FluidStack getFillFluid(ItemStack stack) {
            if (stack.m_41720_() == Items.f_42447_) {
                return new FluidStack((Fluid)Fluids.f_76193_, 1000);
            }
            if (stack.m_41720_() == Items.f_42448_) {
                return new FluidStack((Fluid)Fluids.f_76195_, 1000);
            }
            return FluidStack.EMPTY;
        }

        private ItemStack getRandomItemstack() {
            int n = (int)Math.floor(Math.random() * (double)ForgeRegistries.ITEMS.getValues().size());
            ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValues().stream().skip(n).findAny().orElse(Items.f_42594_));
            stack.m_41764_((int)Math.floor(Math.random() * (double)stack.m_41741_()));
            return stack;
        }

        public boolean activated(Player player, InteractionHand hand, BlockHitResult hit) {
            ItemStack held = player.m_21120_(hand);
            if (held.m_41619_()) {
                ArrayList<Object> msgs = new ArrayList<Object>();
                if (this.rf_fed_avg > 0) {
                    msgs.add("-" + this.rf_fed_avg + "rf/t");
                }
                if (this.rf_fed_total > 0) {
                    msgs.add("-" + this.rf_fed_total + "rf");
                }
                if (this.rf_received_avg > 0) {
                    msgs.add("+" + this.rf_received_avg + "rf/t");
                }
                if (this.rf_received_total > 0) {
                    msgs.add("+" + this.rf_received_total + "rf");
                }
                if (this.liq_filled_avg > 0) {
                    msgs.add("-" + this.liq_filled_avg + "mb/t");
                }
                if (this.liq_filled_total > 0) {
                    msgs.add("-" + this.liq_filled_total + "mb");
                }
                if (this.liq_received_avg > 0) {
                    msgs.add("+" + this.liq_received_avg + "mb/t");
                }
                if (this.liq_received_total > 0) {
                    msgs.add("+" + this.liq_received_total + "mb");
                }
                if (this.items_received_total > 0) {
                    msgs.add("+" + this.items_received_total + "items");
                }
                if (this.items_inserted_total > 0) {
                    msgs.add("-" + this.items_inserted_total + "items");
                }
                if (msgs.isEmpty()) {
                    msgs.add("Nothing transferred yet.");
                }
                Overlay.show(player, (Component)new TextComponent(String.join((CharSequence)" | ", msgs)), 1000);
                return true;
            }
            if (this.paused) {
                if (!this.getFillFluid(held).isEmpty()) {
                    FluidStack fs = this.getFillFluid(held);
                    if (this.liq_fill_stack.isEmpty() || !this.liq_fill_stack.isFluidEqual(fs)) {
                        fs.setAmount(128);
                        this.liq_fill_stack = fs;
                    } else {
                        int amount = this.liq_fill_stack.getAmount() * 2;
                        if (amount > 4096) {
                            amount = 16;
                        }
                        this.liq_fill_stack.setAmount(amount);
                    }
                    if (this.liq_fill_stack.isEmpty()) {
                        Overlay.show(player, (Component)new TextComponent("Fluid fill: none"), 1000);
                    } else {
                        Overlay.show(player, (Component)new TextComponent("Fluid fill: " + this.liq_fill_stack.getAmount() + "mb/t of " + this.liq_fill_stack.getFluid().getRegistryName()), 1000);
                    }
                } else if (held.m_41720_() == Items.f_42451_) {
                    this.rf_feed_setting = this.rf_feed_setting << 1 & 0xFFFFF0;
                    if (this.rf_feed_setting == 0) {
                        this.rf_feed_setting = 16;
                    }
                    Overlay.show(player, (Component)new TextComponent("RF feed rate: " + this.rf_feed_setting + "rf/t"), 1000);
                } else {
                    BlockState adjacent_state = this.f_58857_.m_8055_(this.f_58858_.m_142300_(this.block_facing));
                    if (adjacent_state.m_60734_() == Blocks.f_50332_ || adjacent_state.m_60734_() == ModContent.FACTORY_HOPPER) {
                        this.insertion_item = held.m_41777_();
                        Overlay.show(player, (Component)new TextComponent("Insertion item: " + (this.insertion_item.m_41720_() == Items.f_41966_ ? "random" : this.insertion_item.toString()) + "/s"), 1000);
                    }
                }
                return true;
            }
            return false;
        }

        public void m_7651_() {
            super.m_7651_();
            this.energy_handler_.invalidate();
            this.fluid_handler_.invalidate();
            this.item_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (!this.paused && facing != this.block_facing) {
                if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                    return this.fluid_handler_.cast();
                }
                if (capability == CapabilityEnergy.ENERGY) {
                    return this.energy_handler_.cast();
                }
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return this.item_handler_.cast();
                }
            }
            return super.getCapability(capability, facing);
        }

        @Override
        public void tick() {
            if (this.f_58857_.m_5776_()) {
                return;
            }
            this.block_facing = (Direction)this.m_58900_().m_61143_((Property)TestBlock.FACING);
            this.paused = this.f_58857_.m_46753_(this.m_58899_());
            if (!this.paused) {
                boolean dirty = false;
                int p = RfEnergy.feed(this.m_58904_(), this.m_58899_().m_142300_(this.block_facing), this.block_facing.m_122424_(), this.rf_feed_setting);
                this.rf_fed_acc += p;
                dirty |= p > 0;
                if (!this.liq_fill_stack.isEmpty()) {
                    int f = Fluidics.fill(this.m_58904_(), this.m_58899_().m_142300_(this.block_facing), this.block_facing.m_122424_(), this.liq_fill_stack);
                    this.liq_filled_acc += f;
                    dirty |= f > 0;
                }
                if (!this.inventory_.m_7983_()) {
                    int i = this.inventory_.m_8020_(0).m_41613_();
                    this.items_received_total += i;
                    this.inventory_.m_6211_();
                    dirty |= i > 0;
                }
                if (this.tick_timer == 1 && !this.insertion_item.m_41619_()) {
                    ItemStack stack;
                    BlockState adjacent_state = this.f_58857_.m_8055_(this.f_58858_.m_142300_(this.block_facing));
                    ItemStack itemStack = stack = this.insertion_item.m_41720_() == Items.f_41966_ ? this.getRandomItemstack() : this.insertion_item.m_41777_();
                    if (adjacent_state.m_60734_() == Blocks.f_50332_ || adjacent_state.m_60734_() == ModContent.FACTORY_HOPPER) {
                        ItemStack remaining = Inventories.insert(this.m_58904_(), this.m_58899_().m_142300_(this.block_facing), this.block_facing.m_122424_(), stack, false);
                        int n = stack.m_41613_() - remaining.m_41613_();
                        this.items_inserted_total += n;
                        dirty |= n > 0;
                    }
                }
                if (dirty) {
                    this.m_6596_();
                }
            }
            if (--this.tick_timer <= 0) {
                this.tick_timer = 20;
                this.rf_fed_avg = this.rf_fed_acc / 20;
                this.rf_fed_total += this.rf_fed_acc;
                this.rf_fed_acc = 0;
                this.rf_received_avg = this.battery_.getEnergyStored() / 20;
                this.rf_received_total += this.battery_.getEnergyStored();
                this.battery_.clear();
                this.liq_received_avg = this.tank_.getFluidAmount();
                this.liq_received_total += this.tank_.getFluidAmount();
                this.tank_.clear();
                this.liq_filled_avg = this.liq_fill_stack.isEmpty() ? 0 : this.liq_filled_acc / 20;
                this.liq_filled_total = this.liq_fill_stack.isEmpty() ? 0 : this.liq_filled_total + this.liq_filled_acc;
                this.liq_filled_acc = 0;
            }
        }
    }

    public static class TestBlock
    extends StandardBlocks.Directed
    implements StandardEntityBlocks.IStandardEntityBlock<TestTileEntity>,
    Auxiliaries.IExperimentalFeature {
        public TestBlock(long config, BlockBehaviour.Properties builder, AABB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        @Nullable
        public BlockEntityType<TestTileEntity> getBlockEntityType() {
            return ModContent.TET_TEST_BLOCK;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return Shapes.m_83144_();
        }

        public boolean m_7899_(BlockState p_60571_) {
            return true;
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            return Collections.singletonList(new ItemStack((ItemLike)this));
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof TestTileEntity)) {
                return InteractionResult.FAIL;
            }
            return ((TestTileEntity)te).activated(player, hand, hit) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
    }
}

