/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enchancedcelestials;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import corgitaco.enchancedcelestials.config.EnhancedCelestialsConfig;
import corgitaco.enchancedcelestials.data.network.NetworkHandler;
import corgitaco.enchancedcelestials.data.network.packet.LunarEventPacket;
import corgitaco.enchancedcelestials.data.world.LunarData;
import corgitaco.enchancedcelestials.lunarevent.LunarEvent;
import corgitaco.enchancedcelestials.lunarevent.LunarEventSystem;
import corgitaco.enchancedcelestials.modcompat.OptifineCompat;
import corgitaco.enchancedcelestials.server.SetLunarEventCommand;
import corgitaco.enchancedcelestials.util.EnhancedCelestialsUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enhancedcelestials")
public class EnhancedCelestials {
    public static final String MOD_ID = "enhancedcelestials";
    public static final Logger LOGGER = LogManager.getLogger();
    public static LunarData lunarData = null;
    public static LunarEvent currentLunarEvent = null;
    public static final Path CONFIG_PATH = new File(String.valueOf(FMLPaths.CONFIGDIR.get().resolve("enhancedcelestials"))).toPath();
    public static boolean usingOptifine;

    public EnhancedCelestials() {
        CONFIG_PATH.toFile().mkdirs();
        EnhancedCelestialsConfig.loadConfig(CONFIG_PATH.resolve("enhancedcelestials-common.toml"));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::lateSetup);
    }

    private void setup(FMLCommonSetupEvent event) {
        NetworkHandler.init();
        LunarEventSystem.registerDefaultLunarEvents();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        usingOptifine = (Boolean)OptifineCompat.IS_OPTIFINE_PRESENT.func_179281_c();
    }

    private void lateSetup(FMLLoadCompleteEvent event) {
        currentLunarEvent = LunarEventSystem.DEFAULT_EVENT;
        LunarEventSystem.fillLunarEventsMapAndWeatherEventController();
    }

    public static LunarData getLunarData(@Nullable IWorld world) {
        if (lunarData == null) {
            if (world == null) {
                throw new NullPointerException("Attempting to set Lunar data w/ a null world!");
            }
            lunarData = LunarData.get(world);
        }
        return lunarData;
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LOGGER.debug("Registering Enhanced Celestials commands...");
        LiteralArgumentBuilder requires = (LiteralArgumentBuilder)Commands.func_197057_a((String)MOD_ID).requires(commandSource -> commandSource.func_197034_c(3));
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)requires.then(SetLunarEventCommand.register(dispatcher)));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)MOD_ID).redirect((CommandNode)source));
        LOGGER.debug("Registered Enhanced Celestials Commands!");
    }

    @Mod.EventBusSubscriber(modid="enhancedcelestials", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class EnhancedCelestialsEvents {
        @SubscribeEvent
        public static void worldTick(TickEvent.WorldTickEvent event) {
            ServerWorld serverWorld;
            if (event.phase == TickEvent.Phase.END && event.side.isServer() && EnhancedCelestialsUtils.isOverworld((RegistryKey<World>)(serverWorld = (ServerWorld)event.world).func_234923_W_())) {
                World world = event.world;
                if (EnhancedCelestialsUtils.modulosDaytime(world.func_72912_H().func_76073_f()) % 13005L == 0L) {
                    AtomicBoolean lunarEventWasSet = new AtomicBoolean(false);
                    LunarEventSystem.LUNAR_EVENTS_CONTROLLER.forEach((eventName, eventChance) -> {
                        if (world.field_73012_v.nextDouble() < eventChance) {
                            lunarEventWasSet.set(true);
                            EnhancedCelestials.getLunarData((IWorld)event.world).setEvent((String)eventName);
                        }
                    });
                    if (!lunarEventWasSet.get()) {
                        EnhancedCelestials.getLunarData((IWorld)event.world).setEvent(LunarEventSystem.DEFAULT_EVENT.getID());
                    }
                    ((ServerWorld)event.world).func_217369_A().forEach(player -> NetworkHandler.sendToClient(player, new LunarEventPacket(EnhancedCelestials.getLunarData((IWorld)event.world).getEvent())));
                }
                LunarEventSystem.updateLunarEventPacket(serverWorld);
            }
        }

        @SubscribeEvent
        public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
            EnhancedCelestialsEvents.updateLunarEventPacket(Collections.singletonList((ServerPlayerEntity)event.getPlayer()));
        }

        public static void updateLunarEventPacket(List<ServerPlayerEntity> players) {
            players.forEach(player -> NetworkHandler.sendToClient(player, new LunarEventPacket(EnhancedCelestials.getLunarData((IWorld)player.func_71121_q()).getEvent())));
        }

        @SubscribeEvent
        public static void commandRegisterEvent(FMLServerStartingEvent event) {
            LOGGER.debug("Enhanced Celestials: \"Server Starting\" Event Starting...");
            EnhancedCelestials.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
            LOGGER.info("Enhanced Celestials: \"Server Starting\" Event Complete!");
        }
    }
}

