/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enchancedcelestials.lunarevent;

import corgitaco.enchancedcelestials.config.EnhancedCelestialsConfig;
import corgitaco.enchancedcelestials.lunarevent.LunarEvent;
import corgitaco.enchancedcelestials.util.EnhancedCelestialsUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class BloodMoon
extends LunarEvent {
    public static final Color COLOR = new Color(166, 16, 30);
    static double spawnCapMultiplier = (Double)EnhancedCelestialsConfig.spawnCapMultiplier.get();
    static boolean redClouds = (Boolean)EnhancedCelestialsConfig.redClouds.get();

    public BloodMoon() {
        super("BLOOD_MOON", (Double)EnhancedCelestialsConfig.bloodMoonChance.get());
    }

    @Override
    public boolean modifySkyLightMapColor(Vector3f lightMapSkyColor) {
        if (lightMapSkyColor != null) {
            lightMapSkyColor.func_229190_a_(new Vector3f(2.0f, 0.0f, 0.0f), 1.0f);
        }
        return true;
    }

    @Override
    public void multiplySpawnCap(EntityClassification mobCategory, int spawningChunkCount, Object2IntOpenHashMap<EntityClassification> currentMobCategoryCounts, CallbackInfoReturnable<Boolean> cir) {
        if (mobCategory == EntityClassification.MONSTER) {
            int spawnCap = (int)((double)mobCategory.func_75601_b() * ((double)spawningChunkCount * spawnCapMultiplier) / (double)EnhancedCelestialsUtils.CHUNK_AREA);
            cir.setReturnValue((Object)(currentMobCategoryCounts.getInt((Object)mobCategory) < spawnCap ? 1 : 0));
        }
    }

    @Override
    public Color modifyMoonColor() {
        return new Color(166, 16, 30, 255);
    }

    @Override
    public Color modifySkyColor(Color originalSkyColor) {
        return COLOR;
    }

    @Override
    public Color modifyFogColor(Color originalSkyColor) {
        return COLOR;
    }

    @Override
    public Color modifyWaterColor(Color originalWaterColor) {
        return COLOR;
    }

    @Override
    public Color modifyWaterFogColor(Color originalWaterFogColor) {
        return new Color(206, 56, 70);
    }

    @Override
    public Color modifyCloudColor(Color originalCloudColor) {
        if (redClouds) {
            return COLOR;
        }
        return super.modifyCloudColor(originalCloudColor);
    }

    @Override
    public boolean stopSleeping(PlayerEntity player) {
        player.func_146105_b((ITextComponent)new TranslationTextComponent("enhancedcelestials.sleep.fail.blood_moon"), true);
        return true;
    }
}

